/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

public class SizedUtil {
    public static final int POINTER_SIZE = 8;
    public static final int OBJECT_SIZE = 16;
    public static final int ARRAY_SIZE = 24;
    public static final int CHAR_SIZE = 2;
    public static final int INT_SIZE = 4;
    public static final int LONG_SIZE = 8;
    public static final int TREE_MAP_SIZE = 40;
    public static final int MAP_ENTRY_SIZE = 44;
    public static final int IMMUTABLE_BYTES_WRITABLE_SIZE = 48;
    public static final int IMMUTABLE_BYTES_PTR_SIZE = 52;
    public static final int KEY_VALUE_SIZE = 64;
    public static final int RESULT_SIZE = 88;
    public static final int INT_OBJECT_SIZE = 20;
    public static final int LONG_OBJECT_SIZE = 24;
    public static final int BIG_DECIMAL_SIZE = 116;

    private SizedUtil() {
    }

    public static int sizeOfTreeMap(int size) {
        return 40 + 60 * size;
    }

    public static int sizeOfArrayList(int capacity) {
        return 52 + 8 * capacity;
    }

    public static long sizeOfMap(int nRows) {
        return SizedUtil.sizeOfMap(nRows, 8, 8);
    }

    public static long sizeOfMap(int nRows, int keySize, int valueSize) {
        return 64 + SizedUtil.sizeOfArrayList(nRows) + nRows * (44 + keySize + valueSize);
    }
}

