/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.sql.SQLException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.transaction.PhoenixTransactionalTable;
import org.apache.phoenix.transaction.TephraTransactionTable;
import org.apache.phoenix.transaction.TransactionFactory;

public class TransactionUtil {
    private TransactionUtil() {
    }

    public static boolean isDelete(Cell cell) {
        return CellUtil.matchingValue((Cell)cell, (byte[])HConstants.EMPTY_BYTE_ARRAY);
    }

    public static long convertToNanoseconds(long serverTimeStamp) {
        return serverTimeStamp * TransactionFactory.getTransactionFactory().getTransactionContext().getMaxTransactionsPerSecond();
    }

    public static long convertToMilliseconds(long serverTimeStamp) {
        return serverTimeStamp / TransactionFactory.getTransactionFactory().getTransactionContext().getMaxTransactionsPerSecond();
    }

    public static PhoenixTransactionalTable getPhoenixTransactionTable(PhoenixTransactionContext phoenixTransactionContext, HTableInterface htable, PTable pTable) {
        return new TephraTransactionTable(phoenixTransactionContext, htable, pTable);
    }

    public static long getResolvedTimestamp(PhoenixConnection connection, boolean isTransactional, long defaultResolvedTimestamp) {
        MutationState mutationState = connection.getMutationState();
        Long scn = connection.getSCN();
        return scn != null ? scn : (isTransactional && mutationState.isTransactionStarted() ? TransactionUtil.convertToMilliseconds(mutationState.getInitialWritePointer()) : defaultResolvedTimestamp);
    }

    public static long getResolvedTime(PhoenixConnection connection, MetaDataProtocol.MetaDataMutationResult result) {
        PTable table = result.getTable();
        boolean isTransactional = table != null && table.isTransactional();
        return TransactionUtil.getResolvedTimestamp(connection, isTransactional, result.getMutationTime());
    }

    public static long getResolvedTimestamp(PhoenixConnection connection, MetaDataProtocol.MetaDataMutationResult result) {
        PTable table = result.getTable();
        MutationState mutationState = connection.getMutationState();
        boolean txInProgress = table != null && table.isTransactional() && mutationState.isTransactionStarted();
        return txInProgress ? TransactionUtil.convertToMilliseconds(mutationState.getInitialWritePointer()) : result.getMutationTime();
    }

    public static Long getTableTimestamp(PhoenixConnection connection, boolean transactional) throws SQLException {
        Long timestamp = null;
        if (!transactional) {
            return timestamp;
        }
        MutationState mutationState = connection.getMutationState();
        if (!mutationState.isTransactionStarted()) {
            mutationState.startTransaction();
        }
        timestamp = TransactionUtil.convertToMilliseconds(mutationState.getInitialWritePointer());
        return timestamp;
    }
}

