/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tearoa;

import com.aliyun.tea.Tea;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.TeaModel;
import com.aliyun.tea.TeaPair;
import com.aliyun.tea.TeaRequest;
import com.aliyun.tea.TeaResponse;
import com.aliyun.tea.TeaUnretryableException;
import com.aliyun.tearoa.models.Config;
import com.aliyun.teautil.Common;
import com.aliyun.teautil.models.RuntimeOptions;
import java.io.InputStream;
import java.util.Map;

public class Client {
    public String _protocol;
    public Integer _readTimeout;
    public Integer _connectTimeout;
    public String _httpProxy;
    public String _httpsProxy;
    public String _noProxy;
    public Integer _maxIdleConns;
    public String _endpointHost;
    public String _network;
    public String _endpointRule;
    public Map<String, String> _endpointMap;
    public String _suffix;
    public String _productId;
    public String _regionId;
    public com.aliyun.credentials.Client _credential;

    public Client(Config config) throws Exception {
        if (Common.isUnset((Object)TeaModel.buildMap((TeaModel)config))) {
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'config' can not be unset")}));
        }
        if (!Common.empty((String)config.accessKeyId) && !Common.empty((String)config.accessKeySecret)) {
            config.type = !Common.empty((String)config.securityToken) ? "sts" : "access_key";
            com.aliyun.credentials.models.Config credentialConfig = com.aliyun.credentials.models.Config.build((Map)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("accessKeyId", (Object)config.accessKeyId), new TeaPair("type", (Object)config.type), new TeaPair("accessKeySecret", (Object)config.accessKeySecret), new TeaPair("securityToken", (Object)config.securityToken)}));
            this._credential = new com.aliyun.credentials.Client(credentialConfig);
        } else if (!Common.isUnset((Object)config.credential)) {
            this._credential = config.credential;
        } else {
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'accessKeyId' and 'accessKeySecret' or 'credential' can not be unset")}));
        }
        this._network = config.network;
        this._regionId = config.regionId;
        this._suffix = config.suffix;
        this._protocol = config.protocol;
        this._endpointHost = config.endpoint;
        this._readTimeout = config.readTimeout;
        this._connectTimeout = config.connectTimeout;
        this._httpProxy = config.httpProxy;
        this._httpsProxy = config.httpsProxy;
        this._maxIdleConns = config.maxIdleConns;
    }

    public Map<String, Object> doRequest(String version, String protocol, String method, String authType, String pathname, Map<String, String> query, Map<String, String> headers, Object body, RuntimeOptions runtime) throws Exception {
        Map runtime_ = TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("timeouted", (Object)"retry"), new TeaPair("readTimeout", (Object)Common.defaultNumber((Number)runtime.readTimeout, (Number)this._readTimeout)), new TeaPair("connectTimeout", (Object)Common.defaultNumber((Number)runtime.connectTimeout, (Number)this._connectTimeout)), new TeaPair("httpProxy", (Object)Common.defaultString((String)runtime.httpProxy, (String)this._httpProxy)), new TeaPair("httpsProxy", (Object)Common.defaultString((String)runtime.httpsProxy, (String)this._httpsProxy)), new TeaPair("noProxy", (Object)Common.defaultString((String)runtime.noProxy, (String)this._noProxy)), new TeaPair("maxIdleConns", (Object)Common.defaultNumber((Number)runtime.maxIdleConns, (Number)this._maxIdleConns)), new TeaPair("retry", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("retryable", (Object)runtime.autoretry), new TeaPair("maxAttempts", (Object)Common.defaultNumber((Number)runtime.maxAttempts, (Number)3))})), new TeaPair("backoff", (Object)TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("policy", (Object)Common.defaultString((String)runtime.backoffPolicy, (String)"no")), new TeaPair("period", (Object)Common.defaultNumber((Number)runtime.backoffPeriod, (Number)1))})), new TeaPair("ignoreSSL", (Object)runtime.ignoreSSL)});
        TeaRequest _lastRequest = null;
        long _now = System.currentTimeMillis();
        int _retryTimes = 0;
        while (Tea.allowRetry((Map)((Map)runtime_.get("retry")), (int)_retryTimes, (long)_now)) {
            int backoffTime;
            if (_retryTimes > 0 && (backoffTime = Tea.getBackoffTime(runtime_.get("backoff"), (int)_retryTimes)) > 0) {
                Tea.sleep((int)backoffTime);
            }
            ++_retryTimes;
            try {
                TeaRequest request_ = new TeaRequest();
                request_.protocol = Common.defaultString((String)this._protocol, (String)protocol);
                request_.method = method;
                request_.pathname = pathname;
                request_.headers = TeaConverter.merge(String.class, (Map[])new Map[]{TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("date", (Object)Common.getDateUTCString()), new TeaPair("host", (Object)this._endpointHost), new TeaPair("accept", (Object)"application/json"), new TeaPair("x-acs-signature-nonce", (Object)Common.getNonce()), new TeaPair("x-acs-signature-method", (Object)"HMAC-SHA1"), new TeaPair("x-acs-signature-version", (Object)"1.0"), new TeaPair("x-acs-version", (Object)version)}), headers});
                if (!Common.isUnset((Object)body)) {
                    request_.body = Tea.toReadable((String)Common.toJSONString((Object)body));
                }
                if (!Common.isUnset(query)) {
                    request_.query = query;
                }
                if (!Common.equalString((String)authType, (String)"Anonymous")) {
                    String accessKeyId = this._credential.getAccessKeyId();
                    String accessKeySecret = this._credential.getAccessKeySecret();
                    String securityToken = this._credential.getSecurityToken();
                    if (!Common.empty((String)securityToken)) {
                        request_.headers.put("x-acs-accesskey-id", accessKeyId);
                        request_.headers.put("x-acs-security-token", securityToken);
                    }
                    String stringToSign = com.aliyun.roautil.Client.getStringToSign((TeaRequest)request_);
                    request_.headers.put("authorization", "acs " + accessKeyId + ":" + com.aliyun.roautil.Client.getSignature((String)stringToSign, (String)accessKeySecret) + "");
                }
                _lastRequest = request_;
                TeaResponse response_ = Tea.doAction((TeaRequest)request_, (Map)runtime_);
                if (Common.equalNumber((Number)response_.statusCode, (Number)204)) {
                    return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("headers", (Object)response_.headers)});
                }
                Object result = Common.readAsJSON((InputStream)response_.body);
                if (Common.is4xx((Number)response_.statusCode) || Common.is5xx((Number)response_.statusCode)) {
                    Map err = Common.assertAsMap((Object)result);
                    throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)("" + Client.defaultAny(err.get("Code"), err.get("code")) + "Error")), new TeaPair("message", (Object)("code: " + response_.statusCode + ", " + Client.defaultAny(err.get("Message"), err.get("message")) + " requestid: " + Client.defaultAny(err.get("RequestId"), err.get("requestId")) + "")), new TeaPair("data", (Object)err)}));
                }
                return TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("headers", (Object)response_.headers), new TeaPair("body", result)});
            }
            catch (Exception e) {
                if (Tea.isRetryable((Exception)e)) continue;
                throw e;
            }
        }
        throw new TeaUnretryableException(_lastRequest);
    }

    public static Object defaultAny(Object inputValue, Object defaultValue) throws Exception {
        if (Common.isUnset((Object)inputValue)) {
            return defaultValue;
        }
        return inputValue;
    }

    public void checkConfig(Config config) throws Exception {
        if (Common.empty((String)this._endpointRule) && Common.empty((String)config.endpoint)) {
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'config.endpoint' can not be empty")}));
        }
    }
}

