/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.alexaforbusiness.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.alexaforbusiness.model.Feature;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartDeviceSyncRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String roomArn;
    private String deviceArn;
    private List<String> features;

    public void setRoomArn(String roomArn) {
        this.roomArn = roomArn;
    }

    public String getRoomArn() {
        return this.roomArn;
    }

    public StartDeviceSyncRequest withRoomArn(String roomArn) {
        this.setRoomArn(roomArn);
        return this;
    }

    public void setDeviceArn(String deviceArn) {
        this.deviceArn = deviceArn;
    }

    public String getDeviceArn() {
        return this.deviceArn;
    }

    public StartDeviceSyncRequest withDeviceArn(String deviceArn) {
        this.setDeviceArn(deviceArn);
        return this;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public void setFeatures(Collection<String> features) {
        if (features == null) {
            this.features = null;
            return;
        }
        this.features = new ArrayList<String>(features);
    }

    public StartDeviceSyncRequest withFeatures(String ... features) {
        if (this.features == null) {
            this.setFeatures(new ArrayList<String>(features.length));
        }
        for (String ele : features) {
            this.features.add(ele);
        }
        return this;
    }

    public StartDeviceSyncRequest withFeatures(Collection<String> features) {
        this.setFeatures(features);
        return this;
    }

    public StartDeviceSyncRequest withFeatures(Feature ... features) {
        ArrayList<String> featuresCopy = new ArrayList<String>(features.length);
        for (Feature value : features) {
            featuresCopy.add(value.toString());
        }
        if (this.getFeatures() == null) {
            this.setFeatures(featuresCopy);
        } else {
            this.getFeatures().addAll(featuresCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRoomArn() != null) {
            sb.append("RoomArn: ").append(this.getRoomArn()).append(",");
        }
        if (this.getDeviceArn() != null) {
            sb.append("DeviceArn: ").append(this.getDeviceArn()).append(",");
        }
        if (this.getFeatures() != null) {
            sb.append("Features: ").append(this.getFeatures());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDeviceSyncRequest)) {
            return false;
        }
        StartDeviceSyncRequest other = (StartDeviceSyncRequest)obj;
        if (other.getRoomArn() == null ^ this.getRoomArn() == null) {
            return false;
        }
        if (other.getRoomArn() != null && !other.getRoomArn().equals(this.getRoomArn())) {
            return false;
        }
        if (other.getDeviceArn() == null ^ this.getDeviceArn() == null) {
            return false;
        }
        if (other.getDeviceArn() != null && !other.getDeviceArn().equals(this.getDeviceArn())) {
            return false;
        }
        if (other.getFeatures() == null ^ this.getFeatures() == null) {
            return false;
        }
        return other.getFeatures() == null || other.getFeatures().equals(this.getFeatures());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRoomArn() == null ? 0 : this.getRoomArn().hashCode());
        hashCode = 31 * hashCode + (this.getDeviceArn() == null ? 0 : this.getDeviceArn().hashCode());
        hashCode = 31 * hashCode + (this.getFeatures() == null ? 0 : this.getFeatures().hashCode());
        return hashCode;
    }

    public StartDeviceSyncRequest clone() {
        return (StartDeviceSyncRequest)super.clone();
    }
}

