/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eks.model.LogType;
import com.amazonaws.services.eks.model.transform.LogSetupMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LogSetup
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> types;
    private Boolean enabled;

    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(Collection<String> types) {
        if (types == null) {
            this.types = null;
            return;
        }
        this.types = new ArrayList<String>(types);
    }

    public LogSetup withTypes(String ... types) {
        if (this.types == null) {
            this.setTypes(new ArrayList<String>(types.length));
        }
        for (String ele : types) {
            this.types.add(ele);
        }
        return this;
    }

    public LogSetup withTypes(Collection<String> types) {
        this.setTypes(types);
        return this;
    }

    public LogSetup withTypes(LogType ... types) {
        ArrayList<String> typesCopy = new ArrayList<String>(types.length);
        for (LogType value : types) {
            typesCopy.add(value.toString());
        }
        if (this.getTypes() == null) {
            this.setTypes(typesCopy);
        } else {
            this.getTypes().addAll(typesCopy);
        }
        return this;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public LogSetup withEnabled(Boolean enabled) {
        this.setEnabled(enabled);
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTypes() != null) {
            sb.append("Types: ").append(this.getTypes()).append(",");
        }
        if (this.getEnabled() != null) {
            sb.append("Enabled: ").append(this.getEnabled());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogSetup)) {
            return false;
        }
        LogSetup other = (LogSetup)obj;
        if (other.getTypes() == null ^ this.getTypes() == null) {
            return false;
        }
        if (other.getTypes() != null && !other.getTypes().equals(this.getTypes())) {
            return false;
        }
        if (other.getEnabled() == null ^ this.getEnabled() == null) {
            return false;
        }
        return other.getEnabled() == null || other.getEnabled().equals(this.getEnabled());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTypes() == null ? 0 : this.getTypes().hashCode());
        hashCode = 31 * hashCode + (this.getEnabled() == null ? 0 : this.getEnabled().hashCode());
        return hashCode;
    }

    public LogSetup clone() {
        try {
            return (LogSetup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LogSetupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

