/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eks.model.CreateNodegroupRequest;
import com.amazonaws.util.IdempotentUtils;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class CreateNodegroupRequestMarshaller {
    private static final MarshallingInfo<String> CLUSTERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("name").build();
    private static final MarshallingInfo<String> NODEGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nodegroupName").build();
    private static final MarshallingInfo<StructuredPojo> SCALINGCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scalingConfig").build();
    private static final MarshallingInfo<Integer> DISKSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("diskSize").build();
    private static final MarshallingInfo<List> SUBNETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("subnets").build();
    private static final MarshallingInfo<List> INSTANCETYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceTypes").build();
    private static final MarshallingInfo<String> AMITYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("amiType").build();
    private static final MarshallingInfo<StructuredPojo> REMOTEACCESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("remoteAccess").build();
    private static final MarshallingInfo<String> NODEROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nodeRole").build();
    private static final MarshallingInfo<Map> LABELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("labels").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final MarshallingInfo<String> CLIENTREQUESTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientRequestToken").defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final MarshallingInfo<String> RELEASEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("releaseVersion").build();
    private static final CreateNodegroupRequestMarshaller instance = new CreateNodegroupRequestMarshaller();

    public static CreateNodegroupRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(CreateNodegroupRequest createNodegroupRequest, ProtocolMarshaller protocolMarshaller) {
        if (createNodegroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)createNodegroupRequest.getClusterName(), CLUSTERNAME_BINDING);
            protocolMarshaller.marshall((Object)createNodegroupRequest.getNodegroupName(), NODEGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)createNodegroupRequest.getScalingConfig(), SCALINGCONFIG_BINDING);
            protocolMarshaller.marshall((Object)createNodegroupRequest.getDiskSize(), DISKSIZE_BINDING);
            protocolMarshaller.marshall(createNodegroupRequest.getSubnets(), SUBNETS_BINDING);
            protocolMarshaller.marshall(createNodegroupRequest.getInstanceTypes(), INSTANCETYPES_BINDING);
            protocolMarshaller.marshall((Object)createNodegroupRequest.getAmiType(), AMITYPE_BINDING);
            protocolMarshaller.marshall((Object)createNodegroupRequest.getRemoteAccess(), REMOTEACCESS_BINDING);
            protocolMarshaller.marshall((Object)createNodegroupRequest.getNodeRole(), NODEROLE_BINDING);
            protocolMarshaller.marshall(createNodegroupRequest.getLabels(), LABELS_BINDING);
            protocolMarshaller.marshall(createNodegroupRequest.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)createNodegroupRequest.getClientRequestToken(), CLIENTREQUESTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)createNodegroupRequest.getVersion(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)createNodegroupRequest.getReleaseVersion(), RELEASEVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

