/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.core.util.logging.ClientLogger;
import java.util.Objects;

public final class NonAzureOpenAIKeyCredential {
    private static final ClientLogger LOGGER = new ClientLogger(NonAzureOpenAIKeyCredential.class);
    private String key;

    public NonAzureOpenAIKeyCredential(String key) {
        Objects.requireNonNull(key, "'key' cannot be null.");
        if (key.isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'key' cannot be empty."));
        }
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public NonAzureOpenAIKeyCredential update(String key) {
        Objects.requireNonNull(key, "'key' cannot be null.");
        if (key.isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'key' cannot be empty."));
        }
        this.key = key;
        return this;
    }
}

