/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.util.concurrent.FastThreadLocal;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;

public class RpcContext {
    private static final FastThreadLocal<RpcContext> CURRENT_RPC_CONTEXT = new FastThreadLocal<RpcContext>(){

        protected RpcContext initialValue() {
            return new RpcContext();
        }
    };
    private Integer readTimeoutMillis;
    private Integer writeTimeoutMillis;
    private Integer logId;
    private String serviceTag;
    private Map<String, Object> requestKvAttachment;
    private ByteBuf requestBinaryAttachment;
    private Map<String, Object> responseKvAttachment;
    private ByteBuf responseBinaryAttachment;
    private Channel channel;
    private SocketAddress remoteAddress;

    public static boolean isSet() {
        return CURRENT_RPC_CONTEXT.isSet();
    }

    public static RpcContext getContext() {
        return (RpcContext)CURRENT_RPC_CONTEXT.get();
    }

    public static void removeContext() {
        CURRENT_RPC_CONTEXT.remove();
    }

    public void reset() {
        this.readTimeoutMillis = null;
        this.writeTimeoutMillis = null;
        this.logId = null;
        this.requestKvAttachment = null;
        this.requestBinaryAttachment = null;
        this.responseBinaryAttachment = null;
        this.responseKvAttachment = null;
        this.channel = null;
        this.remoteAddress = null;
        this.serviceTag = null;
    }

    public void setRequestBinaryAttachment(ByteBuf byteBuf) {
        this.requestBinaryAttachment = byteBuf == null ? null : Unpooled.wrappedBuffer((ByteBuf)byteBuf);
    }

    public void setRequestBinaryAttachment(byte[] bytes) {
        this.requestBinaryAttachment = bytes == null ? null : Unpooled.wrappedBuffer((byte[])bytes);
    }

    public void setRequestKvAttachment(String key, Object value) {
        if (this.requestKvAttachment == null) {
            this.requestKvAttachment = new HashMap<String, Object>();
        }
        this.requestKvAttachment.put(key, value);
    }

    public void setRequestKvAttachment(Map<String, Object> attachment) {
        if (this.requestKvAttachment == null) {
            this.requestKvAttachment = attachment;
        } else {
            this.requestKvAttachment.putAll(attachment);
        }
    }

    public void setResponseKvAttachment(String key, Object value) {
        if (this.responseKvAttachment == null) {
            this.responseKvAttachment = new HashMap<String, Object>();
        }
        this.responseKvAttachment.put(key, value);
    }

    public void setResponseKvAttachment(Map<String, Object> attachment) {
        if (this.responseKvAttachment == null) {
            this.responseKvAttachment = attachment;
        } else {
            this.responseKvAttachment.putAll(attachment);
        }
    }

    public String getRemoteHost() {
        if (this.remoteAddress != null) {
            InetSocketAddress remoteAddress = (InetSocketAddress)this.remoteAddress;
            InetAddress address = remoteAddress.getAddress();
            return address.getHostAddress();
        }
        return null;
    }

    public void setReadTimeoutMillis(Integer readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public void setWriteTimeoutMillis(Integer writeTimeoutMillis) {
        this.writeTimeoutMillis = writeTimeoutMillis;
    }

    public void setLogId(Integer logId) {
        this.logId = logId;
    }

    public void setServiceTag(String serviceTag) {
        this.serviceTag = serviceTag;
    }

    public void setResponseBinaryAttachment(ByteBuf responseBinaryAttachment) {
        this.responseBinaryAttachment = responseBinaryAttachment;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void setRemoteAddress(SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public Integer getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public Integer getWriteTimeoutMillis() {
        return this.writeTimeoutMillis;
    }

    public Integer getLogId() {
        return this.logId;
    }

    public String getServiceTag() {
        return this.serviceTag;
    }

    public Map<String, Object> getRequestKvAttachment() {
        return this.requestKvAttachment;
    }

    public ByteBuf getRequestBinaryAttachment() {
        return this.requestBinaryAttachment;
    }

    public Map<String, Object> getResponseKvAttachment() {
        return this.responseKvAttachment;
    }

    public ByteBuf getResponseBinaryAttachment() {
        return this.responseBinaryAttachment;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }
}

