/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.client;

import com.baidu.brpc.JprotobufRpcMethodInfo;
import com.baidu.brpc.ProtobufRpcMethodInfo;
import com.baidu.brpc.RpcMethodInfo;
import com.baidu.brpc.client.RpcCallback;
import com.baidu.brpc.utils.ProtobufUtils;
import java.lang.reflect.Method;
import java.util.concurrent.Future;

public class MethodUtils {
    public static RpcMethodInfo getRpcMethodInfo(Class clazz, String methodName) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            ProtobufUtils.MessageType messageType;
            if (!method.getName().equals(methodName)) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            int paramLength = parameterTypes.length;
            if (paramLength < 1) {
                throw new IllegalArgumentException("invalid params, the correct is ([RpcContext], Request, [Callback])");
            }
            if (Future.class.isAssignableFrom(method.getReturnType()) && (paramLength < 1 || !RpcCallback.class.isAssignableFrom(parameterTypes[paramLength - 1]))) {
                throw new IllegalArgumentException("returnType is Future, but last argument is not RpcCallback");
            }
            Method syncMethod = method;
            if (paramLength > 1) {
                int startIndex = 0;
                int endIndex = paramLength - 1;
                if (RpcCallback.class.isAssignableFrom(parameterTypes[paramLength - 1])) {
                    --endIndex;
                    --paramLength;
                }
                Class[] actualParameterTypes = new Class[paramLength];
                int i = 0;
                while (startIndex <= endIndex) {
                    actualParameterTypes[i] = parameterTypes[startIndex++];
                    ++i;
                }
                try {
                    syncMethod = method.getDeclaringClass().getMethod(method.getName(), actualParameterTypes);
                }
                catch (NoSuchMethodException ex) {
                    throw new IllegalArgumentException("can not find sync method:" + method.getName());
                }
            }
            RpcMethodInfo methodInfo = (messageType = ProtobufUtils.getMessageType(syncMethod)) == ProtobufUtils.MessageType.PROTOBUF ? new ProtobufRpcMethodInfo(syncMethod) : (messageType == ProtobufUtils.MessageType.JPROTOBUF ? new JprotobufRpcMethodInfo(syncMethod) : new RpcMethodInfo(syncMethod));
            return methodInfo;
        }
        return null;
    }
}

