/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.client.instance;

import com.baidu.brpc.client.RpcClient;
import com.baidu.brpc.client.channel.BrpcChannel;
import com.baidu.brpc.client.channel.BrpcChannelFactory;
import com.baidu.brpc.client.instance.InstanceProcessor;
import com.baidu.brpc.client.instance.ServiceInstance;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class BasicInstanceProcessor
implements InstanceProcessor {
    private CopyOnWriteArraySet<ServiceInstance> instances = new CopyOnWriteArraySet();
    private CopyOnWriteArrayList<BrpcChannel> instanceChannels = new CopyOnWriteArrayList();
    private ConcurrentMap<ServiceInstance, BrpcChannel> instanceChannelMap = new ConcurrentHashMap<ServiceInstance, BrpcChannel>();
    private Lock lock = new ReentrantLock();
    private RpcClient rpcClient;

    public BasicInstanceProcessor(RpcClient rpcClient) {
        this.rpcClient = rpcClient;
    }

    @Override
    public void addInstance(ServiceInstance instance) {
        this.lock.lock();
        try {
            if (this.instances.add(instance)) {
                BrpcChannel brpcChannel = BrpcChannelFactory.createChannel(instance, this.rpcClient);
                this.instanceChannels.add(brpcChannel);
                this.instanceChannelMap.putIfAbsent(instance, brpcChannel);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void addInstances(Collection<ServiceInstance> addList) {
        for (ServiceInstance instance : addList) {
            this.addInstance(instance);
        }
    }

    @Override
    public void deleteInstances(Collection<ServiceInstance> deleteList) {
        for (ServiceInstance instance : deleteList) {
            this.deleteInstance(instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteInstance(ServiceInstance instance) {
        block4: {
            this.lock.lock();
            try {
                if (!this.instances.remove(instance)) break block4;
                for (BrpcChannel brpcChannel : this.instanceChannels) {
                    if (!brpcChannel.getServiceInstance().equals(instance)) continue;
                    brpcChannel.close();
                    this.instanceChannels.remove(brpcChannel);
                    this.instanceChannelMap.remove(instance);
                    break;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public CopyOnWriteArraySet<ServiceInstance> getInstances() {
        return this.instances;
    }

    @Override
    public CopyOnWriteArrayList<BrpcChannel> getHealthyInstanceChannels() {
        return this.instanceChannels;
    }

    @Override
    public CopyOnWriteArrayList<BrpcChannel> getUnHealthyInstanceChannels() {
        return this.instanceChannels;
    }

    @Override
    public ConcurrentMap<ServiceInstance, BrpcChannel> getInstanceChannelMap() {
        return this.instanceChannelMap;
    }

    @Override
    public void stop() {
        for (BrpcChannel brpcChannel : this.instanceChannels) {
            brpcChannel.close();
        }
    }
}

