/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.protocol.nshead;

import com.baidu.brpc.RpcMethodInfo;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.protocol.nshead.NSHeadRpcProtocol;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.netty.buffer.ByteBuf;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSHeadJsonProtocol
extends NSHeadRpcProtocol {
    private static final Logger log = LoggerFactory.getLogger(NSHeadJsonProtocol.class);
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().serializeSpecialFloatingPointValues().create();

    public NSHeadJsonProtocol(String encoding) {
        super(encoding);
    }

    @Override
    public byte[] encodeBody(Object body, RpcMethodInfo rpcMethodInfo) {
        byte[] bytes;
        Validate.notNull((Object)body, (String)"body must not be empty", (Object[])new Object[0]);
        String json = gson.toJson(body);
        try {
            bytes = json.getBytes(this.encoding);
        }
        catch (Exception e) {
            log.error("can not serialize object using mcpack", (Throwable)e);
            throw new RpcException(5, (Throwable)e);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object decodeBody(ByteBuf bodyBuf, RpcMethodInfo rpcMethodInfo) {
        try {
            Object result;
            try {
                int readableBytes = bodyBuf.readableBytes();
                byte[] bodyBytes = new byte[readableBytes];
                bodyBuf.readBytes(bodyBytes);
                String jsonString = new String(bodyBytes, this.encoding);
                result = rpcMethodInfo.getTarget() != null ? gson.fromJson(jsonString, rpcMethodInfo.getInputClasses()[0]) : gson.fromJson(jsonString, rpcMethodInfo.getOutputClass());
            }
            catch (Exception e) {
                log.error("can not deserialize object", (Throwable)e);
                throw new RpcException(5, (Throwable)e);
            }
            Object object = result;
            return object;
        }
        finally {
            if (bodyBuf != null) {
                bodyBuf.release();
            }
        }
    }
}

