/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.vod;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.Region;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.bos.BosClient;
import com.baidubce.services.bos.BosClientConfiguration;
import com.baidubce.services.bos.model.ObjectMetadata;
import com.baidubce.services.vod.FileUploadSession;
import com.baidubce.services.vod.model.CreateMediaResourceResponse;
import com.baidubce.services.vod.model.DeleteMediaResourceRequest;
import com.baidubce.services.vod.model.DeleteMediaResourceResponse;
import com.baidubce.services.vod.model.GenerateMediaIdRequest;
import com.baidubce.services.vod.model.GenerateMediaIdResponse;
import com.baidubce.services.vod.model.GetMediaResourceRequest;
import com.baidubce.services.vod.model.GetMediaResourceResponse;
import com.baidubce.services.vod.model.GetPlayableUrlRequest;
import com.baidubce.services.vod.model.GetPlayableUrlResponse;
import com.baidubce.services.vod.model.GetPlayerCodeRequest;
import com.baidubce.services.vod.model.GetPlayerCodeResponse;
import com.baidubce.services.vod.model.InternalCreateMediaRequest;
import com.baidubce.services.vod.model.InternalCreateMediaResponse;
import com.baidubce.services.vod.model.ListMediaResourceRequest;
import com.baidubce.services.vod.model.ListMediaResourceResponse;
import com.baidubce.services.vod.model.PublishMediaResourceRequest;
import com.baidubce.services.vod.model.PublishMediaResourceResponse;
import com.baidubce.services.vod.model.StopMediaResourceRequest;
import com.baidubce.services.vod.model.StopMediaResourceResponse;
import com.baidubce.services.vod.model.UpdateMediaResourceRequest;
import com.baidubce.services.vod.model.UpdateMediaResourceResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VodClient
extends AbstractBceClient {
    private static final String VERSION = "v1";
    private static final String PATH_MEDIA = "media";
    private static final String PATH_INTERNAL_MEDIA = "media/internal";
    private static final String PATH_SERVICE_CODE = "service/code";
    private static final String PATH_SERVICE_FILE = "service/file";
    private static final String PARA_PUBLISH = "publish";
    private static final String PARA_DISABLE = "disable";
    private static final String PARA_MEDIA_ID = "media_id";
    private static final String PARA_WIDTH = "width";
    private static final String PARA_HEIGHT = "height";
    private static final String PARA_AUTO_START = "auto_start";
    private static final String PARA_ATTRIBUTES = "attributes";
    private static Logger logger = LoggerFactory.getLogger(VodClient.class);
    private BosClient bosClient;
    private static final HttpResponseHandler[] responseHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public VodClient(BceClientConfiguration vodConfig) {
        super(vodConfig, responseHandlers, true);
        BosClientConfiguration bosConfig = new BosClientConfiguration(vodConfig, null).withRegion(Region.CN_N1);
        this.bosClient = new BosClient(bosConfig);
    }

    VodClient(BceClientConfiguration vodConfig, BosClientConfiguration bosConfig) {
        super(vodConfig, responseHandlers, true);
        this.bosClient = new BosClient(bosConfig);
    }

    public CreateMediaResourceResponse createMediaResource(String title, String description, File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException("The media file " + file.getAbsolutePath() + " doesn't exist!");
        }
        GenerateMediaIdResponse generateMediaIdresponse = this.generateMediaId();
        String bosKey = generateMediaIdresponse.getSourceKey();
        String mediaId = generateMediaIdresponse.getMediaId();
        String bucket = generateMediaIdresponse.getSourceBucket();
        logger.info("[bucket] = " + bucket + ", [bosKey] = " + bosKey + ", [mediaId] = " + mediaId);
        FileUploadSession session = new FileUploadSession(this.bosClient);
        CreateMediaResourceResponse response = new CreateMediaResourceResponse();
        if (session.upload(file, bucket, bosKey)) {
            InternalCreateMediaRequest request = new InternalCreateMediaRequest().withMediaId(mediaId).withTitle(title).withDescription(description);
            InternalCreateMediaResponse internalResponse = this.internalCreateMediaResource(request);
            response.setMediaId(internalResponse.getMediaId());
        }
        return response;
    }

    public CreateMediaResourceResponse createMediaResource(String sourceBucket, String sourceKey, String title, String description) {
        Validate.checkStringNotEmpty(sourceBucket, "sourceBucket should not be null or empty!");
        Validate.checkStringNotEmpty(sourceKey, "key should not be null or empty!");
        ObjectMetadata metaData = this.bosClient.getObjectMetadata(sourceBucket, sourceKey);
        Validate.checkIsTrue(metaData != null && metaData.getContentLength() > 0L, "The object corresponding to [bucket] = " + sourceBucket + ", [key] = " + sourceKey + " doesn't exist.");
        GenerateMediaIdResponse generateMediaIdresponse = this.generateMediaId();
        String mediaId = generateMediaIdresponse.getMediaId();
        String targetBucket = generateMediaIdresponse.getSourceBucket();
        String targetKey = generateMediaIdresponse.getSourceKey();
        this.bosClient.copyObject(sourceBucket, sourceKey, targetBucket, targetKey);
        InternalCreateMediaRequest request = new InternalCreateMediaRequest().withMediaId(mediaId).withTitle(title).withDescription(description);
        InternalCreateMediaResponse internalResponse = this.internalCreateMediaResource(request);
        CreateMediaResourceResponse response = new CreateMediaResourceResponse();
        response.setMediaId(internalResponse.getMediaId());
        return response;
    }

    private InternalCreateMediaResponse internalCreateMediaResource(InternalCreateMediaRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, PATH_INTERNAL_MEDIA, request.getMediaId());
        return this.invokeHttpClient(internalRequest, InternalCreateMediaResponse.class);
    }

    private GenerateMediaIdResponse generateMediaId() {
        GenerateMediaIdRequest request = new GenerateMediaIdRequest();
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PATH_INTERNAL_MEDIA);
        return this.invokeHttpClient(internalRequest, GenerateMediaIdResponse.class);
    }

    public GetMediaResourceResponse getMediaResource(String mediaId) {
        GetMediaResourceRequest request = new GetMediaResourceRequest().withMediaId(mediaId);
        return this.getMediaResource(request);
    }

    public GetMediaResourceResponse getMediaResource(GetMediaResourceRequest request) {
        Validate.checkStringNotEmpty(request.getMediaId(), "Media ID should not be null or empty!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PATH_MEDIA, request.getMediaId());
        return this.invokeHttpClient(internalRequest, GetMediaResourceResponse.class);
    }

    public ListMediaResourceResponse listMediaResources() {
        ListMediaResourceRequest request = new ListMediaResourceRequest();
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PATH_MEDIA);
        return this.invokeHttpClient(internalRequest, ListMediaResourceResponse.class);
    }

    public UpdateMediaResourceResponse updateMediaResource(String mediaId, String title, String description) {
        UpdateMediaResourceRequest request = new UpdateMediaResourceRequest().withMediaId(mediaId).withTitle(title).withDescription(description);
        return this.updateMediaResource(request);
    }

    public UpdateMediaResourceResponse updateMediaResource(UpdateMediaResourceRequest request) {
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, PATH_MEDIA, request.getMediaId());
        internalRequest.addParameter(PARA_ATTRIBUTES, null);
        return this.invokeHttpClient(internalRequest, UpdateMediaResourceResponse.class);
    }

    public StopMediaResourceResponse stopMediaResource(String mediaId) {
        StopMediaResourceRequest request = new StopMediaResourceRequest().withMediaId(mediaId);
        return this.stopMediaResource(request);
    }

    public StopMediaResourceResponse stopMediaResource(StopMediaResourceRequest request) {
        Validate.checkStringNotEmpty(request.getMediaId(), "Media ID should not be null or empty!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, PATH_MEDIA, request.getMediaId());
        internalRequest.addParameter(PARA_DISABLE, null);
        return this.invokeHttpClient(internalRequest, StopMediaResourceResponse.class);
    }

    public PublishMediaResourceResponse publishMediaResource(String mediaId) {
        PublishMediaResourceRequest request = new PublishMediaResourceRequest().withMediaId(mediaId);
        return this.publishMediaResource(request);
    }

    public PublishMediaResourceResponse publishMediaResource(PublishMediaResourceRequest request) {
        Validate.checkStringNotEmpty(request.getMediaId(), "Media ID should not be null or empty!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, PATH_MEDIA, request.getMediaId());
        internalRequest.addParameter(PARA_PUBLISH, null);
        return this.invokeHttpClient(internalRequest, PublishMediaResourceResponse.class);
    }

    public DeleteMediaResourceResponse deleteMediaResource(String mediaId) {
        DeleteMediaResourceRequest request = new DeleteMediaResourceRequest().withMediaId(mediaId);
        return this.deleteMediaResource(request);
    }

    public DeleteMediaResourceResponse deleteMediaResource(DeleteMediaResourceRequest request) {
        Validate.checkStringNotEmpty(request.getMediaId(), "Media ID should not be null or empty!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.DELETE, request, PATH_MEDIA, request.getMediaId());
        return this.invokeHttpClient(internalRequest, DeleteMediaResourceResponse.class);
    }

    public GetPlayableUrlResponse getPlayableUrl(String mediaId) {
        GetPlayableUrlRequest request = new GetPlayableUrlRequest().withMediaId(mediaId);
        return this.getPlayableUrl(request);
    }

    public GetPlayableUrlResponse getPlayableUrl(GetPlayableUrlRequest request) {
        Validate.checkStringNotEmpty(request.getMediaId(), "Media ID should not be null or empty!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PATH_SERVICE_FILE);
        internalRequest.addParameter(PARA_MEDIA_ID, request.getMediaId());
        return this.invokeHttpClient(internalRequest, GetPlayableUrlResponse.class);
    }

    public GetPlayerCodeResponse getPlayerCode(String mediaId, int width, int height, boolean autoStart) {
        GetPlayerCodeRequest request = new GetPlayerCodeRequest().withMediaId(mediaId).withWidth(width).withHeight(height).withAutoStart(autoStart);
        return this.getPlayerCode(request);
    }

    public GetPlayerCodeResponse getPlayerCode(GetPlayerCodeRequest request) {
        Validate.checkStringNotEmpty(request.getMediaId(), "Media ID should not be null or empty!");
        Validate.checkIsTrue(request.getHeight() > 0, "Height of playback view should be positive!");
        Validate.checkIsTrue(request.getWidth() > 0, "Width of playback view should be positive!");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, PATH_SERVICE_CODE);
        internalRequest.addParameter(PARA_MEDIA_ID, request.getMediaId());
        internalRequest.addParameter(PARA_WIDTH, Integer.toString(request.getWidth()));
        internalRequest.addParameter(PARA_HEIGHT, Integer.toString(request.getHeight()));
        internalRequest.addParameter(PARA_AUTO_START, Boolean.toString(request.isAutoStart()));
        return this.invokeHttpClient(internalRequest, GetPlayerCodeResponse.class);
    }

    private InternalRequest createRequest(HttpMethodName httpMethod, AbstractBceRequest request, String ... pathVariables) {
        ArrayList<String> pathComponents = new ArrayList<String>();
        pathComponents.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                pathComponents.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), pathComponents.toArray(new String[pathComponents.size()]));
        InternalRequest internalRequest = new InternalRequest(httpMethod, uri);
        internalRequest.setCredentials(request.getRequestCredentials());
        if (httpMethod == HttpMethodName.POST || httpMethod == HttpMethodName.PUT) {
            this.fillRequestPayload(internalRequest, request);
        }
        return internalRequest;
    }

    private InternalRequest fillRequestPayload(InternalRequest internalRequest, AbstractBceRequest request) {
        String strJson = JsonUtils.toJsonString(request);
        byte[] requestJson = null;
        try {
            requestJson = strJson.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Unsupported encode.", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
        internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        return internalRequest;
    }

    @Override
    public boolean isRegionSupported() {
        return false;
    }
}

