/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.http.handler;

import com.baidubce.BceResponseMetadata;
import com.baidubce.http.BceHttpResponse;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.model.AbstractBceResponse;
import com.google.common.base.CharMatcher;

public class BceMetadataResponseHandler
implements HttpResponseHandler {
    @Override
    public boolean handle(BceHttpResponse httpResponse, AbstractBceResponse response) throws Exception {
        BceResponseMetadata metadata = response.getMetadata();
        metadata.setBceRequestId(httpResponse.getHeader("x-bce-request-id"));
        metadata.setBceContentSha256(httpResponse.getHeader("x-bce-content-sha256"));
        metadata.setContentDisposition(httpResponse.getHeader("Content-Disposition"));
        metadata.setContentEncoding(httpResponse.getHeader("Content-Encoding"));
        metadata.setContentLength(httpResponse.getHeaderAsLong("Content-Length"));
        metadata.setContentMd5(httpResponse.getHeader("Content-MD5"));
        metadata.setContentRange(httpResponse.getHeader("Content-Range"));
        metadata.setContentType(httpResponse.getHeader("Content-Type"));
        metadata.setDate(httpResponse.getHeaderAsRfc822Date("Date"));
        metadata.setTransferEncoding(httpResponse.getHeader("Transfer-Encoding"));
        String eTag = httpResponse.getHeader("ETag");
        if (eTag != null) {
            metadata.setETag(CharMatcher.is((char)'\"').trimFrom((CharSequence)eTag));
        }
        metadata.setExpires(httpResponse.getHeaderAsRfc822Date("Expires"));
        metadata.setLastModified(httpResponse.getHeaderAsRfc822Date("Last-Modified"));
        metadata.setServer(httpResponse.getHeader("Server"));
        return false;
    }
}

