/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestorage.model.transform;

import com.baidubce.BceClientException;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.tablestorage.model.BatchGetRowResponse;
import com.baidubce.services.tablestorage.model.TableStorageResult;
import com.baidubce.services.tablestorage.model.transform.TableStorageResultUnmarshaller;
import com.baidubce.services.tablestorage.model.transform.Unmarshaller;
import com.baidubce.services.tablestorage.model.transform.Unmarshallers;
import com.baidubce.util.JsonUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class BatchGetRowResponseUnmarshaller
implements Unmarshaller<BatchGetRowResponse, InputStream> {
    private BatchGetRowResponse result;

    public BatchGetRowResponseUnmarshaller(AbstractBceResponse response) {
        this.result = (BatchGetRowResponse)response;
    }

    @Override
    public BatchGetRowResponse unmarshall(InputStream in) throws Exception {
        String streamContents = Unmarshallers.readStreamContents(in);
        JsonNode root = JsonUtils.jsonNodeOf(streamContents);
        if (!root.isObject()) {
            throw new BceClientException("The input json object:" + root.toString() + " is not an object.");
        }
        JsonNode resultsNode = root.get("result");
        ArrayList<TableStorageResult> results = new ArrayList<TableStorageResult>();
        if (resultsNode != null) {
            Iterator resultList = resultsNode.elements();
            TableStorageResultUnmarshaller unmarshaller = new TableStorageResultUnmarshaller();
            while (resultList.hasNext()) {
                JsonNode resultNode = (JsonNode)resultList.next();
                TableStorageResult result = unmarshaller.unmarshall(resultNode);
                results.add(result);
            }
        }
        this.result.setResults(results);
        return this.result;
    }
}

