/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tsdb.model;

import com.baidubce.services.tsdb.model.GroupInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Group {
    private List<GroupInfo> groupInfos = Lists.newArrayList();
    private List<List<JsonNode>> values = Lists.newArrayList();

    public List<GroupInfo> getGroupInfos() {
        return this.groupInfos;
    }

    public void setGroupInfos(List<GroupInfo> groupInfos) {
        this.groupInfos = groupInfos;
    }

    public List<List<JsonNode>> getValues() {
        return this.values;
    }

    public void setValues(List<List<JsonNode>> values) {
        this.values = values;
    }

    @JsonIgnore
    public List<TimeAndValue> getTimeAndValueList() throws IOException {
        if (this.values == null || this.values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayList();
        for (List<JsonNode> nodeList : this.values) {
            long timestamp = nodeList.get(0).asLong();
            ArrayList<JsonNode> values = new ArrayList<JsonNode>();
            for (int index = 1; index < nodeList.size(); ++index) {
                values.add(nodeList.get(index));
            }
            list.add(new TimeAndValue(timestamp, values));
        }
        return list;
    }

    public static class TimeAndValue {
        private long time;
        private List<? extends JsonNode> value;

        public TimeAndValue(long time, JsonNode value) {
            this.time = time;
            this.value = Collections.singletonList(value);
        }

        public TimeAndValue(long time, List<? extends JsonNode> values) {
            this.time = time;
            this.value = values;
        }

        public int getValueLength() {
            return this.value.size();
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public JsonNode getValue() {
            return this.value.get(0);
        }

        public void setValue(JsonNode value) {
            this.value = Collections.singletonList(value);
        }

        @JsonIgnore
        public boolean isLong() {
            return this.isLong(0);
        }

        @JsonIgnore
        public boolean isLong(int index) {
            return this.value.get(index).isIntegralNumber();
        }

        @JsonIgnore
        public boolean isDouble() {
            return this.isDouble(0);
        }

        @JsonIgnore
        public boolean isDouble(int index) {
            return this.value.get(index).isFloatingPointNumber();
        }

        @Deprecated
        @JsonIgnore
        public boolean isString() {
            throw new RuntimeException("Interface is deprecated");
        }

        @Deprecated
        @JsonIgnore
        public boolean isBytes() {
            throw new RuntimeException("Interface is deprecated");
        }

        @JsonIgnore
        public long getLongValue() {
            return this.getLongValue(0);
        }

        @JsonIgnore
        public long getLongValue(int index) {
            return this.value.get(index).asLong();
        }

        @JsonIgnore
        public double getDoubleValue() {
            return this.getDoubleValue(0);
        }

        @JsonIgnore
        public double getDoubleValue(int index) {
            return this.value.get(index).asDouble();
        }

        @JsonIgnore
        public String getStringValue() {
            return this.getStringValue(0);
        }

        @JsonIgnore
        public String getStringValue(int index) {
            if (this.isNull(index)) {
                return null;
            }
            return this.value.get(index).asText();
        }

        @JsonIgnore
        public byte[] getBytesValue() throws IOException {
            return this.getBytesValue(0);
        }

        @JsonIgnore
        public byte[] getBytesValue(int index) throws IOException {
            return this.value.get(index).binaryValue();
        }

        @JsonIgnore
        public BigDecimal getBigDecimalValue() throws IOException {
            return this.getBigDecimalValue(0);
        }

        @JsonIgnore
        public BigDecimal getBigDecimalValue(int index) {
            return new BigDecimal(this.value.get(index).asText());
        }

        @JsonIgnore
        public boolean isNull() {
            return this.isNull(0);
        }

        @JsonIgnore
        public boolean isNull(int index) {
            return this.value.get(index) == null || this.value.get(index).isNull();
        }
    }
}

