/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.vca.example;

import com.baidubce.BceClientConfiguration;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.vca.VcaClient;
import com.baidubce.services.vca.model.HighlightAnalyzeRequest;
import com.baidubce.services.vca.model.ImageAnalyzeResponse;
import com.baidubce.services.vca.model.QueryResultResponse;
import com.baidubce.services.vca.model.QuerySubTaskResponse;
import com.baidubce.services.vca.model.StreamAnalyzeRequest;
import com.baidubce.services.vca.model.StreamAnalyzeResponse;

public class VcaExample {
    public static void main(String[] args) {
        String ak = "YourAk";
        String sk = "YourSk";
        BceClientConfiguration config = new BceClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ak, sk));
        VcaClient client = new VcaClient(config);
        String source = "YourMediaSource";
        String title = "title";
        client.analyze(source, title);
        QueryResultResponse resultResponse = client.queryResult(source);
        System.out.println(resultResponse);
        QuerySubTaskResponse subTaskResponse = client.querySubTask(source, "ocr");
        System.out.println(subTaskResponse);
        String streamSource = "YourStreamSource";
        String streamNotification = "YourNotification";
        String streamPreset = "YourPreset";
        StreamAnalyzeRequest streamAnalyzeRequest = new StreamAnalyzeRequest();
        streamAnalyzeRequest.setSource(streamSource);
        streamAnalyzeRequest.setPreset(streamPreset);
        streamAnalyzeRequest.setNotification(streamNotification);
        streamAnalyzeRequest.setIntervalInSecond(10);
        client.analyzeStream(streamAnalyzeRequest);
        StreamAnalyzeResponse queryStreamInfo = client.queryStream(streamSource);
        System.out.println(queryStreamInfo);
        client.stopStream(streamSource);
        String imageSource = "YourImageSource";
        ImageAnalyzeResponse imageAnalyzeResponse = client.analyzeImage(imageSource);
        System.out.println(imageAnalyzeResponse);
        HighlightAnalyzeRequest highlightAnalyzeRequest = new HighlightAnalyzeRequest();
        highlightAnalyzeRequest.setSource("YourMediaSource");
        highlightAnalyzeRequest.setMaxDurationTime(100);
        highlightAnalyzeRequest.setVideoType("news");
        client.analyzeHighlight(highlightAnalyzeRequest);
        resultResponse = client.queryHighlightResult("YourMediaSource");
        System.out.println(resultResponse);
        client.cancelHighlightResult("YourMediaSource");
    }
}

