/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.ddl.history;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.ddl.history.IDdlGenerator;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Function;

public class PostgreDdlGenerator
implements IDdlGenerator {
    private String schema = "public";

    @Deprecated
    public PostgreDdlGenerator() {
    }

    public PostgreDdlGenerator(String schema) {
        this.schema = schema;
    }

    public static IDdlGenerator newInstance() {
        return PostgreDdlGenerator.newInstanceWithSchema("public");
    }

    public static IDdlGenerator newInstanceWithSchema(String schema) {
        return new PostgreDdlGenerator(schema);
    }

    public static IDdlGenerator newInstanceWithAutoSchema() {
        return new PostgreDdlGenerator("");
    }

    @Override
    public boolean existTable(String databaseName, Function<String, Boolean> executeFunction) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT(1) AS NUM from INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME='ddl_history' AND TABLE_TYPE='BASE TABLE'");
        if (StringUtils.isNotBlank((CharSequence)this.getSchema())) {
            sql.append(" AND TABLE_SCHEMA='").append(this.getSchema()).append("'");
        }
        return executeFunction.apply(sql.toString());
    }

    @Override
    public boolean existTable(Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        String tableName = this.getDdlHistory();
        int index = tableName.lastIndexOf(".");
        if (index > 0) {
            tableName = tableName.substring(index + 1);
        }
        tableName = tableName.replace("\"", "");
        try (ResultSet resultSet = metaData.getTables(connection.getCatalog(), StringUtils.isBlank((CharSequence)this.getSchema()) ? connection.getSchema() : this.getSchema(), tableName, new String[]{"TABLE"});){
            boolean bl = resultSet.next();
            return bl;
        }
    }

    @Override
    public String getDdlHistory() {
        String schema = this.getSchema();
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            return "\"" + schema + "\".\"ddl_history\"";
        }
        return "\"ddl_history\"";
    }

    @Override
    public String createDdlHistory() {
        StringBuffer sql = new StringBuffer();
        String ddlHistory = this.getDdlHistory();
        sql.append("CREATE TABLE IF NOT EXISTS ").append(ddlHistory).append(" (");
        sql.append("\"script\" varchar(500) NOT NULL,");
        sql.append("\"type\" varchar(30) NOT NULL,");
        sql.append("\"version\" varchar(30) NOT NULL");
        sql.append(");");
        sql.append("COMMENT ON COLUMN ").append(ddlHistory).append(".\"script\" IS '\u811a\u672c';");
        sql.append("COMMENT ON COLUMN ").append(ddlHistory).append(".\"type\" IS '\u7c7b\u578b';");
        sql.append("COMMENT ON COLUMN ").append(ddlHistory).append(".\"version\" IS '\u7248\u672c';");
        sql.append("COMMENT ON TABLE ").append(ddlHistory).append(" IS 'DDL \u7248\u672c';");
        return sql.toString();
    }

    @Deprecated
    protected String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }
}

