/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.po;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.builder.ConfigBuilder;
import com.baomidou.mybatisplus.generator.config.builder.Entity;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.rules.IColumnType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class TableInfo {
    private final StrategyConfig strategyConfig;
    private final GlobalConfig globalConfig;
    private final Set<String> importPackages = new TreeSet<String>();
    private boolean convert;
    private String name;
    private String comment;
    private String entityName;
    private String mapperName;
    private String xmlName;
    private String serviceName;
    private String serviceImplName;
    private String controllerName;
    private final List<TableField> fields = new ArrayList<TableField>();
    private boolean havePrimaryKey;
    private final List<TableField> commonFields = new ArrayList<TableField>();
    private String fieldNames;
    private final Entity entity;

    public TableInfo(@NotNull ConfigBuilder configBuilder, @NotNull String name) {
        this.strategyConfig = configBuilder.getStrategyConfig();
        this.globalConfig = configBuilder.getGlobalConfig();
        this.entity = configBuilder.getStrategyConfig().entity();
        this.name = name;
    }

    protected TableInfo setConvert() {
        this.convert = this.strategyConfig.startsWithTablePrefix(this.name) || this.entity.isTableFieldAnnotationEnable() ? true : !this.entityName.equalsIgnoreCase(this.name);
        return this;
    }

    public String getEntityPath() {
        return this.entityName.substring(0, 1).toLowerCase() + this.entityName.substring(1);
    }

    public TableInfo setEntityName(@NotNull String entityName) {
        this.entityName = entityName;
        this.setConvert();
        return this;
    }

    public void addField(@NotNull TableField field) {
        if (this.entity.matchIgnoreColumns(field.getColumnName())) {
            return;
        }
        if (this.entity.matchSuperEntityColumns(field.getColumnName())) {
            this.commonFields.add(field);
        } else {
            this.fields.add(field);
        }
    }

    public TableInfo addImportPackages(String ... pkgs) {
        return this.addImportPackages(Arrays.asList(pkgs));
    }

    public TableInfo addImportPackages(@NotNull List<String> pkgList) {
        this.importPackages.addAll(pkgList);
        return this;
    }

    public String getFieldNames() {
        if (StringUtils.isBlank((CharSequence)this.fieldNames)) {
            this.fieldNames = this.fields.stream().map(TableField::getColumnName).collect(Collectors.joining(", "));
        }
        return this.fieldNames;
    }

    public void importPackage() {
        IdType idType;
        String superEntity = this.entity.getSuperClass();
        if (StringUtils.isNotBlank((CharSequence)superEntity)) {
            this.importPackages.add(superEntity);
        } else if (this.entity.isActiveRecord()) {
            this.importPackages.add("com.baomidou.mybatisplus.extension.activerecord.Model");
        }
        if (this.entity.isSerialVersionUID() || this.entity.isActiveRecord()) {
            this.importPackages.add(Serializable.class.getCanonicalName());
        }
        if (this.isConvert()) {
            this.importPackages.add(TableName.class.getCanonicalName());
        }
        if (null != (idType = this.entity.getIdType()) && this.isHavePrimaryKey()) {
            this.importPackages.add(IdType.class.getCanonicalName());
            this.importPackages.add(TableId.class.getCanonicalName());
        }
        this.fields.forEach(field -> {
            IColumnType columnType = field.getColumnType();
            if (null != columnType && null != columnType.getPkg()) {
                this.importPackages.add(columnType.getPkg());
            }
            if (field.isKeyFlag()) {
                if (field.isConvert() || field.isKeyIdentityFlag()) {
                    this.importPackages.add(TableId.class.getCanonicalName());
                }
                if (field.isKeyIdentityFlag()) {
                    this.importPackages.add(IdType.class.getCanonicalName());
                }
            } else if (field.isConvert()) {
                this.importPackages.add(com.baomidou.mybatisplus.annotation.TableField.class.getCanonicalName());
            }
            if (null != field.getFill()) {
                this.importPackages.add(com.baomidou.mybatisplus.annotation.TableField.class.getCanonicalName());
                this.importPackages.add(FieldFill.class.getCanonicalName());
            }
            if (field.isVersionField()) {
                this.importPackages.add(Version.class.getCanonicalName());
            }
            if (field.isLogicDeleteField()) {
                this.importPackages.add(TableLogic.class.getCanonicalName());
            }
        });
    }

    public void processTable() {
        String entityName = this.entity.getNameConvert().entityNameConvert(this);
        this.setEntityName(this.entity.getConverterFileName().convert(entityName));
        this.mapperName = this.strategyConfig.mapper().getConverterMapperFileName().convert(entityName);
        this.xmlName = this.strategyConfig.mapper().getConverterXmlFileName().convert(entityName);
        this.serviceName = this.strategyConfig.service().getConverterServiceFileName().convert(entityName);
        this.serviceImplName = this.strategyConfig.service().getConverterServiceImplFileName().convert(entityName);
        this.controllerName = this.strategyConfig.controller().getConverterFileName().convert(entityName);
        this.importPackage();
    }

    public TableInfo setComment(String comment) {
        this.comment = this.globalConfig.isSwagger() && StringUtils.isNotBlank((CharSequence)comment) ? comment.replace("\"", "\\\"") : comment;
        return this;
    }

    public TableInfo setHavePrimaryKey(boolean havePrimaryKey) {
        this.havePrimaryKey = havePrimaryKey;
        return this;
    }

    @NotNull
    public Set<String> getImportPackages() {
        return this.importPackages;
    }

    public TableInfo setConvert(boolean convert) {
        this.convert = convert;
        return this;
    }

    @NotNull
    public List<TableField> getFields() {
        return this.fields;
    }

    @NotNull
    public List<TableField> getCommonFields() {
        return this.commonFields;
    }

    @Deprecated
    public boolean isServiceInterface() {
        return this.globalConfig.isServiceInterface();
    }

    public boolean isConvert() {
        return this.convert;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getMapperName() {
        return this.mapperName;
    }

    public String getXmlName() {
        return this.xmlName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceImplName() {
        return this.serviceImplName;
    }

    public String getControllerName() {
        return this.controllerName;
    }

    public boolean isHavePrimaryKey() {
        return this.havePrimaryKey;
    }
}

