/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.autoconfigure;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.ddl.DdlHelper;
import com.baomidou.mybatisplus.extension.ddl.DdlScriptErrorHandler;
import com.baomidou.mybatisplus.extension.ddl.IDdl;
import com.baomidou.mybatisplus.extension.ddl.history.IDdlGenerator;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;

public class DdlApplicationRunner
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(DdlApplicationRunner.class);
    private final List<IDdl> ddlList;
    private boolean autoCommit = true;
    private DdlScriptErrorHandler ddlScriptErrorHandler = DdlScriptErrorHandler.PrintlnLogErrorHandler.INSTANCE;
    private Consumer<ScriptRunner> scriptRunnerConsumer;
    private boolean throwException = false;

    public DdlApplicationRunner(List<IDdl> ddlList) {
        this.ddlList = ddlList;
    }

    public void run(ApplicationArguments args) {
        if (CollectionUtils.isNotEmpty(this.ddlList)) {
            log.debug("  ...  DDL start create  ...  ");
            this.ddlList.forEach(ddl -> ddl.runScript(dataSource -> {
                block3: {
                    String ddlClassName = AopUtils.getTargetClass((Object)ddl).getName();
                    if (CollectionUtils.isEmpty((Collection)ddl.getSqlFiles())) {
                        log.warn("{}, sql files is empty", (Object)ddlClassName);
                        return;
                    }
                    log.info("{}, run sql files {}", (Object)ddlClassName, (Object)ddl.getSqlFiles());
                    try {
                        DdlHelper.runScript((IDdlGenerator)ddl.getDdlGenerator(), (DataSource)dataSource, (List)ddl.getSqlFiles(), this.scriptRunnerConsumer, (boolean)this.autoCommit, (DdlScriptErrorHandler)this.ddlScriptErrorHandler);
                    }
                    catch (Exception e) {
                        log.error("{}, run sql file error: ", (Object)ddlClassName, (Object)e);
                        if (!this.throwException) break block3;
                        throw new RuntimeException(e);
                    }
                }
            }));
            log.debug("  ...  DDL end create  ...  ");
        }
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public void setDdlScriptErrorHandler(DdlScriptErrorHandler ddlScriptErrorHandler) {
        this.ddlScriptErrorHandler = ddlScriptErrorHandler;
    }

    public void setScriptRunnerConsumer(Consumer<ScriptRunner> scriptRunnerConsumer) {
        this.scriptRunnerConsumer = scriptRunnerConsumer;
    }

    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }
}

