/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.autoconfigure;

import com.baomidou.mybatisplus.core.toolkit.AES;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.util.HashMap;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class SafetyEncryptProcessor
implements EnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String mpwKey = environment.getProperty("mpw.key");
        if (StringUtils.isNotBlank((CharSequence)mpwKey)) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (PropertySource ps : environment.getPropertySources()) {
                if (!(ps instanceof OriginTrackedMapPropertySource)) continue;
                OriginTrackedMapPropertySource source = (OriginTrackedMapPropertySource)ps;
                for (String name : source.getPropertyNames()) {
                    String str;
                    Object value = source.getProperty(name);
                    if (!(value instanceof String) || !(str = (String)value).startsWith("mpw:")) continue;
                    map.put(name, AES.decrypt((String)str.substring(4), (String)mpwKey));
                }
            }
            if (CollectionUtils.isNotEmpty(map)) {
                environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("custom-encrypt", map));
            }
        }
    }
}

