/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsonorg;

import com.fasterxml.jackson.datatype.jsonorg.JSONBaseSerializer;
import com.fasterxml.jackson.datatype.jsonorg.JSONObjectSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.TypeSerializer;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONArraySerializer
extends JSONBaseSerializer<JSONArray> {
    public static final JSONArraySerializer instance = new JSONArraySerializer();

    public JSONArraySerializer() {
        super(JSONArray.class);
    }

    @Override
    public void serialize(JSONArray value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeStartArray();
        this.serializeContents(value, jgen, provider);
        jgen.writeEndArray();
    }

    @Override
    public void serializeWithType(JSONArray value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        typeSer.writeTypePrefixForArray(value, jgen);
        this.serializeContents(value, jgen, provider);
        typeSer.writeTypeSuffixForArray(value, jgen);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("array", true);
    }

    protected void serializeContents(JSONArray value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            Object ob = value.opt(i);
            if (ob == null || ob == JSONObject.NULL) {
                jgen.writeNull();
                continue;
            }
            Class<?> cls = ob.getClass();
            if (cls == JSONObject.class) {
                JSONObjectSerializer.instance.serialize((JSONObject)ob, jgen, provider);
                continue;
            }
            if (cls == JSONArray.class) {
                this.serialize((JSONArray)ob, jgen, provider);
                continue;
            }
            if (cls == String.class) {
                jgen.writeString((String)ob);
                continue;
            }
            if (cls == Integer.class) {
                jgen.writeNumber((Integer)ob);
                continue;
            }
            if (cls == Long.class) {
                jgen.writeNumber((Long)ob);
                continue;
            }
            if (cls == Boolean.class) {
                jgen.writeBoolean((Boolean)ob);
                continue;
            }
            if (cls == Double.class) {
                jgen.writeNumber((Double)ob);
                continue;
            }
            if (JSONObject.class.isAssignableFrom(cls)) {
                JSONObjectSerializer.instance.serialize((JSONObject)ob, jgen, provider);
                continue;
            }
            if (JSONArray.class.isAssignableFrom(cls)) {
                this.serialize((JSONArray)ob, jgen, provider);
                continue;
            }
            if (JSONArray.class.isAssignableFrom(cls)) {
                instance.serialize((JSONArray)ob, jgen, provider);
                continue;
            }
            provider.defaultSerializeValue(ob, jgen);
        }
    }
}

