/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsonorg;

import com.fasterxml.jackson.datatype.jsonorg.JSONArrayDeserializer;
import java.io.IOException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.deser.StdDeserializer;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONObjectDeserializer
extends StdDeserializer<JSONObject> {
    public static final JSONObjectDeserializer instance = new JSONObjectDeserializer();

    public JSONObjectDeserializer() {
        super(JSONObject.class);
    }

    @Override
    public JSONObject deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JSONObject ob = new JSONObject();
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = jp.nextToken();
        }
        while (t == JsonToken.FIELD_NAME) {
            block15: {
                String fieldName = jp.getCurrentName();
                t = jp.nextToken();
                try {
                    switch (t) {
                        case START_ARRAY: {
                            ob.put(fieldName, JSONArrayDeserializer.instance.deserialize(jp, ctxt));
                            break block15;
                        }
                        case START_OBJECT: {
                            ob.put(fieldName, this.deserialize(jp, ctxt));
                            break block15;
                        }
                        case VALUE_STRING: {
                            ob.put(fieldName, jp.getText());
                            break block15;
                        }
                        case VALUE_NULL: {
                            ob.put(fieldName, JSONObject.NULL);
                            break block15;
                        }
                        case VALUE_TRUE: {
                            ob.put(fieldName, Boolean.TRUE);
                            break block15;
                        }
                        case VALUE_FALSE: {
                            ob.put(fieldName, Boolean.FALSE);
                            break block15;
                        }
                        case VALUE_NUMBER_INT: {
                            ob.put(fieldName, jp.getNumberValue());
                            break block15;
                        }
                        case VALUE_NUMBER_FLOAT: {
                            ob.put(fieldName, jp.getNumberValue());
                            break block15;
                        }
                        case VALUE_EMBEDDED_OBJECT: {
                            ob.put(fieldName, jp.getEmbeddedObject());
                            break block15;
                        }
                    }
                }
                catch (JSONException e) {
                    throw ctxt.mappingException("Failed to construct JSONObject: " + e.getMessage());
                }
                throw ctxt.mappingException("Urecognized or unsupported JsonToken type: " + (Object)((Object)t));
            }
            t = jp.nextToken();
        }
        return ob;
    }
}

