/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt;

import com.bazaarvoice.jolt.ContextualTransform;
import com.bazaarvoice.jolt.JoltTransform;
import com.bazaarvoice.jolt.Transform;
import com.bazaarvoice.jolt.chainr.ChainrBuilder;
import com.bazaarvoice.jolt.chainr.instantiator.ChainrInstantiator;
import com.bazaarvoice.jolt.exception.SpecException;
import com.bazaarvoice.jolt.exception.TransformException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Chainr
implements Transform,
ContextualTransform {
    private final List<ContextualTransform> transformsList;
    private final List<ContextualTransform> actualContextualTransforms;

    public static Chainr fromSpec(Object input) {
        return new ChainrBuilder(input).build();
    }

    public static Chainr fromSpec(Object input, ChainrInstantiator instantiator) {
        return new ChainrBuilder(input).loader(instantiator).build();
    }

    public Chainr(List<JoltTransform> joltTransforms) {
        if (joltTransforms == null) {
            throw new IllegalArgumentException("Chainr requires a list of JoltTransforms.");
        }
        this.transformsList = new ArrayList<ContextualTransform>(joltTransforms.size());
        LinkedList<ContextualTransform> realContextualTransforms = new LinkedList<ContextualTransform>();
        for (JoltTransform joltTransform : joltTransforms) {
            boolean isTransform = joltTransform instanceof Transform;
            boolean isContextual = joltTransform instanceof ContextualTransform;
            if (isContextual && isTransform) {
                throw new SpecException("JOLT Chainr - JoltTransform className:" + joltTransform.getClass().getCanonicalName() + " implements both Transform and ContextualTransform, should only implement one of those interfaces.");
            }
            if (!isContextual && !isTransform) {
                throw new SpecException("JOLT Chainr - Transform className:" + joltTransform.getClass().getCanonicalName() + " should implement Transform or ContextualTransform.");
            }
            if (isContextual) {
                this.transformsList.add((ContextualTransform)joltTransform);
                realContextualTransforms.add((ContextualTransform)joltTransform);
                continue;
            }
            this.transformsList.add(new ContextualTransformAdapter((Transform)joltTransform));
        }
        this.actualContextualTransforms = Collections.unmodifiableList(realContextualTransforms);
    }

    @Override
    public Object transform(Object input, Map<String, Object> context) {
        return Chainr.doTransform(this.transformsList, input, context);
    }

    @Override
    public Object transform(Object input) {
        return Chainr.doTransform(this.transformsList, input, null);
    }

    public Object transform(int to, Object input) {
        return this.transform(0, to, input, null);
    }

    public Object transform(int to, Object input, Map<String, Object> context) {
        return this.transform(0, to, input, context);
    }

    public Object transform(int from, int to, Object input) {
        return this.transform(from, to, input, null);
    }

    public Object transform(int from, int to, Object input, Map<String, Object> context) {
        if (from < 0 || to > this.transformsList.size() || to <= from) {
            throw new TransformException("JOLT Chainr : invalid from and to parameters : from=" + from + " to=" + to);
        }
        return Chainr.doTransform(this.transformsList.subList(from, to), input, context);
    }

    private static Object doTransform(List<ContextualTransform> transforms, Object input, Map<String, Object> context) {
        Object intermediate = input;
        for (ContextualTransform transform : transforms) {
            intermediate = transform.transform(intermediate, context);
        }
        return intermediate;
    }

    public boolean hasContextualTransforms() {
        return !this.actualContextualTransforms.isEmpty();
    }

    public List<ContextualTransform> getContextualTransforms() {
        return this.actualContextualTransforms;
    }

    private static class ContextualTransformAdapter
    implements ContextualTransform {
        private final Transform transform;

        private ContextualTransformAdapter(Transform transform) {
            this.transform = transform;
        }

        @Override
        public Object transform(Object input, Map<String, Object> context) {
            return this.transform.transform(input);
        }
    }
}

