/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.common.reference;

import com.bazaarvoice.jolt.common.reference.PathAndGroupReference;
import com.bazaarvoice.jolt.exception.SpecException;

public abstract class BasePathAndGroupReference
implements PathAndGroupReference {
    private final int keyGroup;
    private final int pathIndex;

    protected abstract char getToken();

    public BasePathAndGroupReference(String refStr) {
        if (refStr == null || refStr.length() == 0 || this.getToken() != refStr.charAt(0)) {
            throw new SpecException("Invalid reference key=" + refStr + " either blank or doesn't start with correct character=" + this.getToken());
        }
        int pI = 0;
        int kG = 0;
        try {
            if (refStr.length() > 1) {
                String meat = refStr.substring(1);
                if (meat.length() >= 3 && meat.startsWith("(") && meat.endsWith(")")) {
                    String parenMeat = meat.substring(1, meat.length() - 1);
                    String[] intStrs = parenMeat.split(",");
                    if (intStrs.length > 2) {
                        throw new SpecException("Invalid Reference=" + refStr);
                    }
                    pI = Integer.parseInt(intStrs[0]);
                    if (intStrs.length == 2) {
                        kG = Integer.parseInt(intStrs[1]);
                    }
                } else {
                    pI = Integer.parseInt(meat);
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new SpecException("Unable to parse '" + this.getToken() + "' reference key:" + refStr, nfe);
        }
        if (pI < 0 || kG < 0) {
            throw new SpecException("Reference:" + refStr + " can not have a negative value.");
        }
        this.pathIndex = pI;
        this.keyGroup = kG;
    }

    @Override
    public int getPathIndex() {
        return this.pathIndex;
    }

    @Override
    public int getKeyGroup() {
        return this.keyGroup;
    }

    @Override
    public String getCanonicalForm() {
        return this.getToken() + "(" + this.pathIndex + "," + this.keyGroup + ")";
    }
}

