/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.modifier.function;

import com.bazaarvoice.jolt.common.Optional;
import com.bazaarvoice.jolt.modifier.function.Function;
import java.util.Arrays;
import java.util.List;

public class Strings {
    private static Optional<Object> padString(boolean leftPad2, String source, List<Object> args) {
        String filler;
        Integer width;
        if (source != null && args != null && args.get(0) instanceof Integer && args.get(1) instanceof String && (width = (Integer)args.get(0)) > 0 && width <= 500 && (filler = (String)args.get(1)).length() == 1) {
            char fillerChar = filler.charAt(0);
            if (width <= source.length()) {
                return Optional.of(source);
            }
            int padLength = width - source.length();
            char[] padArray = new char[padLength];
            Arrays.fill(padArray, fillerChar);
            StringBuilder sb = new StringBuilder();
            if (leftPad2) {
                sb.append(padArray).append(source);
            } else {
                sb.append(source).append(padArray);
            }
            return Optional.of(sb.toString());
        }
        return Optional.empty();
    }

    public static final class rightPad
    extends Function.ArgDrivenListFunction<String> {
        @Override
        protected Optional<Object> applyList(String source, List<Object> args) {
            return Strings.padString(false, source, args);
        }
    }

    public static final class leftPad
    extends Function.ArgDrivenListFunction<String> {
        @Override
        protected Optional<Object> applyList(String source, List<Object> args) {
            return Strings.padString(true, source, args);
        }
    }

    public static final class split
    extends Function.ArgDrivenSingleFunction<String, List> {
        @Override
        protected Optional<List> applySingle(String separator, Object source) {
            if (source == null || separator == null) {
                return Optional.empty();
            }
            if (source instanceof String) {
                String inputString = (String)source;
                return Optional.of(Arrays.asList(inputString.split(separator)));
            }
            return Optional.empty();
        }
    }

    public static final class join
    extends Function.ArgDrivenListFunction<String> {
        @Override
        protected Optional<Object> applyList(String specialArg, List<Object> args) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < args.size(); ++i) {
                String argString;
                Object arg = args.get(i);
                if (arg == null || "".equals(argString = arg.toString())) continue;
                sb.append(argString);
                if (i >= args.size() - 1) continue;
                sb.append(specialArg);
            }
            return Optional.of(sb.toString());
        }
    }

    public static final class substring
    extends Function.ListFunction {
        @Override
        protected Optional<Object> applyList(List<Object> argList) {
            if (argList != null && argList.size() == 3 && argList.get(0) instanceof String && argList.get(1) instanceof Integer && argList.get(2) instanceof Integer) {
                int end;
                String tuna = (String)argList.get(0);
                int start = (Integer)argList.get(1);
                if (start < (end = ((Integer)argList.get(2)).intValue()) && start >= 0 && end >= 1 && end <= tuna.length()) {
                    return Optional.of(tuna.substring(start, end));
                }
            }
            return Optional.empty();
        }
    }

    public static final class concat
    extends Function.ListFunction {
        @Override
        protected Optional<Object> applyList(List<Object> argList) {
            StringBuilder sb = new StringBuilder();
            for (Object arg : argList) {
                if (arg == null) continue;
                sb.append(arg.toString());
            }
            return Optional.of(sb.toString());
        }
    }

    public static final class trim
    extends Function.SingleFunction<String> {
        @Override
        protected Optional<String> applySingle(Object arg) {
            if (!(arg instanceof String)) {
                return Optional.empty();
            }
            String argString = (String)arg;
            return Optional.of(argString.trim());
        }
    }

    public static final class toUpperCase
    extends Function.SingleFunction<String> {
        @Override
        protected Optional<String> applySingle(Object arg) {
            if (!(arg instanceof String)) {
                return Optional.empty();
            }
            String argString = (String)arg;
            return Optional.of(argString.toUpperCase());
        }
    }

    public static final class toLowerCase
    extends Function.SingleFunction<String> {
        @Override
        protected Optional<String> applySingle(Object arg) {
            if (!(arg instanceof String)) {
                return Optional.empty();
            }
            String argString = (String)arg;
            return Optional.of(argString.toLowerCase());
        }
    }
}

