/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.support;

import java.util.Locale;
import org.frameworkset.spi.support.LocaleContext;
import org.frameworkset.spi.support.NamedInheritableThreadLocal;
import org.frameworkset.spi.support.NamedThreadLocal;
import org.frameworkset.spi.support.SimpleLocaleContext;

public abstract class LocaleContextHolder {
    private static final ThreadLocal localeContextHolder = new NamedThreadLocal("Locale context");
    private static final ThreadLocal inheritableLocaleContextHolder = new NamedInheritableThreadLocal("Locale context");

    public static void resetLocaleContext() {
        localeContextHolder.set(null);
        inheritableLocaleContextHolder.set(null);
    }

    public static void setLocaleContext(LocaleContext localeContext) {
        LocaleContextHolder.setLocaleContext(localeContext, false);
    }

    public static void setLocaleContext(LocaleContext localeContext, boolean inheritable) {
        if (inheritable) {
            inheritableLocaleContextHolder.set(localeContext);
            localeContextHolder.set(null);
        } else {
            localeContextHolder.set(localeContext);
            inheritableLocaleContextHolder.set(null);
        }
    }

    public static LocaleContext getLocaleContext() {
        LocaleContext localeContext = (LocaleContext)localeContextHolder.get();
        if (localeContext == null) {
            localeContext = (LocaleContext)inheritableLocaleContextHolder.get();
        }
        return localeContext;
    }

    public static void setLocale(Locale locale) {
        LocaleContextHolder.setLocale(locale, false);
    }

    public static void setLocale(Locale locale, boolean inheritable) {
        SimpleLocaleContext localeContext = locale != null ? new SimpleLocaleContext(locale) : null;
        LocaleContextHolder.setLocaleContext(localeContext, inheritable);
    }

    public static Locale getLocale() {
        LocaleContext localeContext = LocaleContextHolder.getLocaleContext();
        return localeContext != null ? localeContext.getLocale() : Locale.getDefault();
    }
}

