/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.support.bind;

import org.frameworkset.spi.support.DefaultMessageSourceResolvable;
import org.frameworkset.spi.support.bind.BindingErrorProcessor;
import org.frameworkset.spi.support.validate.BindingResult;
import org.frameworkset.spi.support.validate.FieldError;
import org.frameworkset.util.beans.PropertyAccessException;

public class DefaultBindingErrorProcessor
implements BindingErrorProcessor {
    public static final String MISSING_FIELD_ERROR_CODE = "required";

    @Override
    public void processMissingFieldError(String missingField, BindingResult bindingResult) {
        String fixedField = bindingResult.getNestedPath() + missingField;
        String[] codes = bindingResult.resolveMessageCodes(MISSING_FIELD_ERROR_CODE, missingField, null);
        Object[] arguments = this.getArgumentsForBindError(bindingResult.getObjectName(), fixedField);
        bindingResult.addError(new FieldError(bindingResult.getObjectName(), fixedField, "", null, true, codes, arguments, "Field '" + fixedField + "' is required"));
    }

    @Override
    public void processPropertyAccessException(PropertyAccessException ex, BindingResult bindingResult) {
        String field = ex.getPropertyChangeEvent().getPropertyName();
        Object value = ex.getPropertyChangeEvent().getNewValue();
        String[] codes = bindingResult.resolveMessageCodes(ex.getErrorCode(), field, null);
        Object[] arguments = this.getArgumentsForBindError(bindingResult.getObjectName(), field);
        bindingResult.addError(new FieldError(bindingResult.getObjectName(), field, value, null, true, codes, arguments, ex.getLocalizedMessage()));
    }

    protected Object[] getArgumentsForBindError(String objectName, String field) {
        String[] codes = new String[]{objectName + "." + field, field};
        String defaultMessage = field;
        return new Object[]{new DefaultMessageSourceResolvable(codes, defaultMessage)};
    }
}

