/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http;

import com.frameworkset.util.SimpleStringUtil;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.ResponseHandler;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.frameworkset.spi.remote.http.ClientConfiguration;
import org.frameworkset.spi.remote.http.DataSerialType;
import org.frameworkset.spi.remote.http.HttpRequestProxy;
import org.frameworkset.spi.remote.http.TimeUtil;
import org.frameworkset.spi.remote.http.proxy.ExceptionWare;
import org.frameworkset.spi.remote.http.proxy.HttpProxyRequestException;
import org.frameworkset.spi.remote.http.proxy.HttpServiceHosts;
import org.frameworkset.util.ClassUtil;
import org.frameworkset.util.annotations.DateFormateMeta;
import org.frameworkset.util.annotations.wraper.RequestParamWraper;

public class HttpParamsHandler {
    public static final String defaultDateformat = "yyyy-MM-dd HH:mm:ss";

    public static Exception getException(ResponseHandler responseHandler, HttpServiceHosts httpServiceHosts) {
        ExceptionWare exceptionWare = httpServiceHosts.getExceptionWare();
        if (exceptionWare != null) {
            return exceptionWare.getExceptionFromResponse(responseHandler);
        }
        return null;
    }

    public static String appendParams(String url, Object params) {
        if (params == null) {
            return url;
        }
        if (params instanceof Map) {
            return HttpParamsHandler.appendMapParams(url, (Map)params);
        }
        return HttpParamsHandler.appendObjectParams(url, params);
    }

    public static String appendMapParams(String url, Map params) {
        int idx = url.indexOf("?");
        boolean hasParams = idx > 0;
        boolean lastIdx = idx == url.length() - 1;
        StringBuilder ret = new StringBuilder();
        ret.append(url);
        if (params != null && params.size() > 0) {
            Iterator iterator = params.entrySet().iterator();
            boolean i = false;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String name = String.valueOf(entry.getKey());
                Object value_ = entry.getValue();
                if (value_ == null) continue;
                String value = HttpParamsHandler.convertValue(value_, null);
                try {
                    value = URLEncoder.encode(value, StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException e) {
                    throw new HttpProxyRequestException(e);
                }
                if (hasParams) {
                    if (lastIdx) {
                        ret.append(name).append("=").append(value);
                        lastIdx = false;
                        continue;
                    }
                    ret.append("&").append(name).append("=").append(value);
                    continue;
                }
                ret.append("?").append(name).append("=").append(value);
                hasParams = true;
            }
        }
        return ret.toString();
    }

    public static String convertValue(Object value, ClassUtil.PropertieDescription propertieDescription, DataSerialType dataSerialType) {
        if (value instanceof String) {
            return String.valueOf(value);
        }
        if (value instanceof Date) {
            String dateFormat = HttpParamsHandler.getDateformat(propertieDescription);
            return DateFormateMeta.format((Date)((Date)value), (String)dateFormat);
        }
        if (value instanceof LocalDateTime) {
            String dateFormat = HttpParamsHandler.getDateformat(propertieDescription);
            return TimeUtil.changeLocalDateTime2String((LocalDateTime)value, dateFormat);
        }
        if (value instanceof LocalDate) {
            String dateFormat = HttpParamsHandler.getDateformat(propertieDescription);
            return TimeUtil.changeLocalDate2String((LocalDate)value, dateFormat);
        }
        if (dataSerialType == null || dataSerialType != DataSerialType.JSON) {
            return String.valueOf(value);
        }
        return SimpleStringUtil.object2json((Object)value);
    }

    public static String convertValue(Object value, DataSerialType dataSerialType) {
        if (value instanceof String) {
            return String.valueOf(value);
        }
        if (value instanceof Date) {
            return DateFormateMeta.format((Date)((Date)value), (String)defaultDateformat);
        }
        if (value instanceof LocalDateTime) {
            return TimeUtil.changeLocalDateTime2String((LocalDateTime)value, defaultDateformat);
        }
        if (value instanceof LocalDate) {
            return TimeUtil.changeLocalDate2String((LocalDate)value, defaultDateformat);
        }
        if (dataSerialType == null || dataSerialType != DataSerialType.JSON) {
            return String.valueOf(value);
        }
        return SimpleStringUtil.object2json((Object)value);
    }

    public static String appendObjectParams(String url, Object params) {
        ClassUtil.ClassInfo classInfo = ClassUtil.getClassInfo(params.getClass());
        List propertieDescriptions = classInfo.getPropertyDescriptors();
        int idx = url.indexOf("?");
        boolean hasParams = idx > 0;
        boolean lastIdx = idx == url.length() - 1;
        StringBuilder ret = new StringBuilder();
        ret.append(url);
        for (ClassUtil.PropertieDescription propertieDescription : propertieDescriptions) {
            String name = propertieDescription.getName();
            Object value_ = null;
            try {
                value_ = propertieDescription.getValue(params);
            }
            catch (IllegalAccessException e) {
                throw new HttpProxyRequestException(e);
            }
            catch (InvocationTargetException e) {
                throw new HttpProxyRequestException(e);
            }
            if (value_ == null) continue;
            String value = HttpParamsHandler.convertValue(value_, propertieDescription, null);
            try {
                value = URLEncoder.encode(value, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new HttpProxyRequestException(e);
            }
            if (hasParams) {
                if (lastIdx) {
                    ret.append(name).append("=").append(value);
                    lastIdx = false;
                    continue;
                }
                ret.append("&").append(name).append("=").append(value);
                continue;
            }
            ret.append("?").append(name).append("=").append(value);
            hasParams = true;
        }
        return ret.toString();
    }

    public static boolean paramsHandle(MultipartEntityBuilder multipartEntityBuilder, HttpRequestProxy.HttpOption httpOption) throws HttpProxyRequestException {
        Object params = httpOption.params;
        if (params != null) {
            if (params instanceof Map) {
                return HttpParamsHandler.mapParamsHandle(multipartEntityBuilder, httpOption);
            }
            try {
                return HttpParamsHandler.objectParamsHandle(multipartEntityBuilder, httpOption);
            }
            catch (InvocationTargetException e) {
                throw new HttpProxyRequestException(e);
            }
            catch (IllegalAccessException e) {
                throw new HttpProxyRequestException(e);
            }
        }
        return false;
    }

    private static String getDateformat(ClassUtil.PropertieDescription propertieDescription) {
        RequestParamWraper requestParam = propertieDescription.getRequestParam();
        String dateFormat = null;
        dateFormat = requestParam != null && requestParam.dateformat() != null ? requestParam.dateformat() : defaultDateformat;
        return dateFormat;
    }

    private static boolean objectParamsHandle(MultipartEntityBuilder multipartEntityBuilder, HttpRequestProxy.HttpOption httpOption) throws InvocationTargetException, IllegalAccessException {
        boolean hasdata = false;
        if (httpOption.params != null) {
            Object params = httpOption.params;
            ClassUtil.ClassInfo classInfo = ClassUtil.getClassInfo(params.getClass());
            List propertieDescriptions = classInfo.getPropertyDescriptors();
            for (ClassUtil.PropertieDescription propertieDescription : propertieDescriptions) {
                String name = propertieDescription.getName();
                Object value_ = propertieDescription.getValue(params);
                if (value_ == null) continue;
                String value = HttpParamsHandler.convertValue(value_, propertieDescription, httpOption.dataSerialType);
                multipartEntityBuilder.addTextBody(name, value, ClientConfiguration.TEXT_PLAIN_UTF_8);
                hasdata = true;
            }
        }
        return hasdata;
    }

    public static List<NameValuePair> paramsPaires(HttpRequestProxy.HttpOption httpOption) throws HttpProxyRequestException {
        Object params = httpOption.params;
        List<NameValuePair> pairs = null;
        if (params != null) {
            if (params instanceof Map) {
                pairs = HttpParamsHandler.mapParamsPairs(httpOption);
            } else {
                try {
                    pairs = HttpParamsHandler.objectParamsPairs(httpOption);
                }
                catch (InvocationTargetException e) {
                    throw new HttpProxyRequestException(e);
                }
                catch (IllegalAccessException e) {
                    throw new HttpProxyRequestException(e);
                }
            }
        }
        return pairs;
    }

    private static List<NameValuePair> objectParamsPairs(HttpRequestProxy.HttpOption httpOption) throws InvocationTargetException, IllegalAccessException {
        ArrayList<NameValuePair> paramPair = new ArrayList<NameValuePair>();
        if (httpOption.params != null) {
            Object params = httpOption.params;
            ClassUtil.ClassInfo classInfo = ClassUtil.getClassInfo(params.getClass());
            List propertieDescriptions = classInfo.getPropertyDescriptors();
            BasicNameValuePair paramPair_ = null;
            for (ClassUtil.PropertieDescription propertieDescription : propertieDescriptions) {
                String name = propertieDescription.getName();
                Object value_ = propertieDescription.getValue(params);
                if (value_ == null) continue;
                String value = HttpParamsHandler.convertValue(value_, propertieDescription, httpOption.dataSerialType);
                paramPair_ = new BasicNameValuePair(name, value);
                paramPair.add((NameValuePair)paramPair_);
            }
        }
        return paramPair;
    }

    private static List<NameValuePair> mapParamsPairs(HttpRequestProxy.HttpOption httpOption) {
        Map params = (Map)httpOption.params;
        if (params.size() <= 0) {
            return null;
        }
        ArrayList<NameValuePair> paramPair = new ArrayList<NameValuePair>();
        Iterator it = params.entrySet().iterator();
        BasicNameValuePair paramPair_ = null;
        int i = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object value_ = entry.getValue();
            if (value_ != null) {
                String value = HttpParamsHandler.convertValue(value_, httpOption.dataSerialType);
                String name = String.valueOf(entry.getKey());
                paramPair_ = new BasicNameValuePair(name, value);
                paramPair.add((NameValuePair)paramPair_);
            }
            ++i;
        }
        return paramPair;
    }

    private static HttpParams objectHttpParams(Object params) {
        BasicHttpParams httpParams = null;
        if (params != null) {
            httpParams = new BasicHttpParams();
            ClassUtil.ClassInfo classInfo = ClassUtil.getClassInfo(params.getClass());
            List propertieDescriptions = classInfo.getPropertyDescriptors();
            for (ClassUtil.PropertieDescription propertieDescription : propertieDescriptions) {
                String name = propertieDescription.getName();
                Object value_ = null;
                try {
                    value_ = propertieDescription.getValue(params);
                }
                catch (IllegalAccessException e) {
                    throw new HttpProxyRequestException(e);
                }
                catch (InvocationTargetException e) {
                    throw new HttpProxyRequestException(e);
                }
                if (value_ == null) continue;
                String value = HttpParamsHandler.convertValue(value_, propertieDescription, null);
                httpParams.setParameter(name, (Object)value);
            }
        }
        return httpParams;
    }

    public static HttpParams httpParams(Object params) {
        if (params == null) {
            return null;
        }
        if (params instanceof Map) {
            return HttpParamsHandler.mapHttpParams((Map)params);
        }
        return HttpParamsHandler.objectHttpParams(params);
    }

    private static HttpParams mapHttpParams(Map params) {
        if (params.size() <= 0) {
            return null;
        }
        BasicHttpParams httpParams = new BasicHttpParams();
        Iterator it = params.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object value_ = entry.getValue();
            if (value_ != null) {
                String value = HttpParamsHandler.convertValue(value_, null);
                String name = String.valueOf(entry.getKey());
                httpParams.setParameter(name, (Object)value);
            }
            ++i;
        }
        return httpParams;
    }

    private static boolean mapParamsHandle(MultipartEntityBuilder multipartEntityBuilder, HttpRequestProxy.HttpOption httpOption) {
        boolean hasdata = false;
        Map params = (Map)httpOption.params;
        if (params != null) {
            for (Map.Entry entry : params.entrySet()) {
                Object value_ = entry.getValue();
                if (value_ == null) continue;
                String value = HttpParamsHandler.convertValue(value_, httpOption.dataSerialType);
                String name = String.valueOf(entry.getKey());
                multipartEntityBuilder.addTextBody(name, value, ClientConfiguration.TEXT_PLAIN_UTF_8);
                hasdata = true;
            }
        }
        return hasdata;
    }
}

