/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http;

import com.frameworkset.util.SimpleStringUtil;
import java.io.File;
import java.io.IOException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.frameworkset.spi.remote.http.BaseURLResponseHandler;
import org.frameworkset.spi.remote.http.ClientConfiguration;
import org.frameworkset.spi.remote.http.DataSerialType;
import org.frameworkset.spi.remote.http.HttpDeleteWithBody;
import org.frameworkset.spi.remote.http.HttpParamsHandler;
import org.frameworkset.spi.remote.http.HttpRequestUtil;
import org.frameworkset.spi.remote.http.ResponseUtil;
import org.frameworkset.spi.remote.http.StringResponseHandler;
import org.frameworkset.spi.remote.http.URLResponseHandler;
import org.frameworkset.spi.remote.http.callback.ExecuteIntercepter;
import org.frameworkset.spi.remote.http.kerberos.BaseRequestKerberosUrlUtils;
import org.frameworkset.spi.remote.http.kerberos.KerberosCallback;
import org.frameworkset.spi.remote.http.proxy.HttpAddress;
import org.frameworkset.spi.remote.http.proxy.HttpProxyRequestException;
import org.frameworkset.spi.remote.http.proxy.HttpServiceHosts;
import org.frameworkset.spi.remote.http.proxy.InvokeContext;
import org.frameworkset.spi.remote.http.proxy.NoHttpServerException;
import org.frameworkset.util.ResourceStartResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestProxy {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequestProxy.class);

    public static ResourceStartResult startHttpPools(String configFile) {
        return HttpRequestUtil.startHttpPools(configFile);
    }

    public static ResourceStartResult startHttpPools(Map<String, Object> configs) {
        return HttpRequestUtil.startHttpPools(configs);
    }

    public static ResourceStartResult startHttpPoolsFromApollo(String namespaces) {
        return HttpRequestUtil.startHttpPoolsFromApollo(namespaces);
    }

    public static ResourceStartResult startHttpPoolsFromApollo(String namespaces, String configChangeListener) {
        return HttpRequestUtil.startHttpPoolsFromApollo(namespaces, configChangeListener);
    }

    public static ResourceStartResult startHttpPoolsFromApolloAwaredChange(String namespaces) {
        return HttpRequestUtil.startHttpPoolsFromApolloAwaredChange(namespaces);
    }

    public static ResourceStartResult startHttpPoolsFromNacos(String namespace, String serverAddr, String dataId, String group, long timeOut, Map<String, String> pros) {
        return HttpRequestUtil.startHttpPoolsFromNacos(namespace, serverAddr, dataId, group, timeOut, pros);
    }

    public static ResourceStartResult startHttpPoolsFromNacos(String namespace, String serverAddr, String dataId, String group, long timeOut, String configChangeListener, Map<String, String> pros) {
        return HttpRequestUtil.startHttpPoolsFromNacos(namespace, serverAddr, dataId, group, timeOut, configChangeListener, pros);
    }

    public static ResourceStartResult startHttpPoolsFromNacosAwaredChange(String namespace, String serverAddr, String dataId, String group, long timeOut, Map<String, String> pros) {
        return HttpRequestUtil.startHttpPoolsFromNacosAwaredChange(namespace, serverAddr, dataId, group, timeOut, pros);
    }

    public static String httpGetforString(String url) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(url, (String)null, (String)null, (Map)null);
    }

    public static <T> T httpGetforObject(String url, final Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString("default", url, (String)null, (String)null, (Map)null, new BaseURLResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleResponse(this.url, response, resultType);
            }
        });
    }

    public static String httpGetforString(String poolname, String url) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(poolname, url, (String)null, (String)null, (Map)null);
    }

    public static String httpGetforString(ClientConfiguration clientConfiguration, String url) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(clientConfiguration, url, (String)null, (String)null, (Map)null);
    }

    public static <T> T httpGetforObject(String poolname, String url, final Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(poolname, url, (String)null, (String)null, (Map)null, new BaseURLResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> T httpGetforObjectWithParams(String poolname, String url, Object params, final Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(poolname, url, null, null, params, null, new BaseURLResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> T httpGetforObjectWithParams(String url, Object params, final Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(null, url, null, null, params, null, new BaseURLResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> T httpGetforObjectWithParamsHeaders(String poolname, String url, Object params, Map headers, final Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(poolname, url, null, null, params, headers, new BaseURLResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> T httpGetforObjectWithParamsHeaders(String url, Object params, Map headers, final Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(null, url, null, null, params, headers, new BaseURLResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> T httpGetforObject(String poolname, String url, Map<String, String> headers, final Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(poolname, url, (String)null, (String)null, headers, new BaseURLResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> List<T> httpGetforList(String url, final Class<T> resultType) throws HttpProxyRequestException {
        return (List)HttpRequestProxy.httpGetforString("default", url, (String)null, (String)null, (Map)null, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <K, T> Map<K, T> httpGetforMap(String url, final Class<K> keyType, final Class<T> resultType) throws HttpProxyRequestException {
        return (Map)HttpRequestProxy.httpGetforString("default", url, (String)null, (String)null, (Map)null, new BaseURLResponseHandler<Map<K, T>>(){

            public Map<K, T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleMapResponse(this.url, response, keyType, resultType);
            }
        });
    }

    public static <T> Set<T> httpGetforSet(String url, final Class<T> resultType) throws HttpProxyRequestException {
        return (Set)HttpRequestProxy.httpGetforString("default", url, (String)null, (String)null, (Map)null, new BaseURLResponseHandler<Set<T>>(){

            public Set<T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleSetResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> List<T> httpGetforList(String poolName, String url, final Class<T> resultType) throws HttpProxyRequestException {
        return (List)HttpRequestProxy.httpGetforString(poolName, url, (String)null, (String)null, (Map)null, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> List<T> httpGetforList(String poolName, String url, Object params, Map headers, final Class<T> resultType) throws HttpProxyRequestException {
        return (List)HttpRequestProxy.httpGetforString(poolName, url, null, null, params, headers, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> List<T> httpGetforList(String poolName, String url, Object params, Map headers, Class<T> resultType, BaseURLResponseHandler<List<T>> baseURLResponseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(poolName, url, null, null, params, headers, baseURLResponseHandler);
    }

    public static <T> List<T> httpGetforList(String poolName, String url, Map headers, Class<T> resultType, BaseURLResponseHandler<List<T>> baseURLResponseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(poolName, url, (String)null, (String)null, headers, baseURLResponseHandler);
    }

    public static <T> List<T> httpGetforList(String poolName, String url, Map headers, final Class<T> resultType) throws HttpProxyRequestException {
        return (List)HttpRequestProxy.httpGetforString(poolName, url, (String)null, (String)null, headers, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <D, T> D httpGetforTypeObject(String url, Class<D> containType, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforTypeObject("default", url, containType, resultType);
    }

    public static <D, T> D httpGetforTypeObject(String poolName, String url, final Class<D> containType, final Class<T> resultType) throws HttpProxyRequestException {
        return (D)HttpRequestProxy.httpGetforString(poolName, url, (String)null, (String)null, (Map)null, new BaseURLResponseHandler<D>(){

            public D handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleResponse(this.url, response, containType, resultType);
            }
        });
    }

    public static <D, T> D httpGetforTypeObjectWithParams(String url, Object params, Class<D> containType, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforTypeObject("default", url, params, containType, resultType);
    }

    public static <D, T> D httpGetforTypeObject(String poolName, String url, Object params, final Class<D> containType, final Class<T> resultType) throws HttpProxyRequestException {
        return (D)HttpRequestProxy.httpGetforString(poolName, url, null, null, params, null, new BaseURLResponseHandler<D>(){

            public D handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleResponse(this.url, response, containType, resultType);
            }
        });
    }

    public static <D, T> D httpGetforTypeObjectWithHeader(String url, Object params, Map headers, Class<D> containType, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforTypeObject("default", url, params, headers, containType, resultType);
    }

    public static <D, T> D httpGetforTypeObject(String poolName, String url, Object params, Map headers, final Class<D> containType, final Class<T> resultType) throws HttpProxyRequestException {
        return (D)HttpRequestProxy.httpGetforString(poolName, url, null, null, params, headers, new BaseURLResponseHandler<D>(){

            public D handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleResponse(this.url, response, containType, resultType);
            }
        });
    }

    public static <K, T> Map<K, T> httpGetforMap(String poolName, String url, final Class<K> keyType, final Class<T> resultType) throws HttpProxyRequestException {
        return (Map)HttpRequestProxy.httpGetforString(poolName, url, (String)null, (String)null, (Map)null, new BaseURLResponseHandler<Map<K, T>>(){

            public Map<K, T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleMapResponse(this.url, response, keyType, resultType);
            }
        });
    }

    public static <K, T> Map<K, T> httpGetforMap(String poolName, String url, Map headers, final Class<K> keyType, final Class<T> resultType) throws HttpProxyRequestException {
        return (Map)HttpRequestProxy.httpGetforString(poolName, url, (String)null, (String)null, headers, new BaseURLResponseHandler<Map<K, T>>(){

            public Map<K, T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleMapResponse(this.url, response, keyType, resultType);
            }
        });
    }

    public static <T> Set<T> httpGetforSet(String poolName, String url, Map headers, final Class<T> resultType) throws HttpProxyRequestException {
        return (Set)HttpRequestProxy.httpGetforString(poolName, url, (String)null, (String)null, headers, new BaseURLResponseHandler<Set<T>>(){

            public Set<T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleSetResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> Set<T> httpGetforSet(String poolName, String url, final Class<T> resultType) throws HttpProxyRequestException {
        return (Set)HttpRequestProxy.httpGetforString(poolName, url, (String)null, (String)null, (Map)null, new BaseURLResponseHandler<Set<T>>(){

            public Set<T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleSetResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> T httpGet(String poolname, String url, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(poolname, url, (String)null, (String)null, (Map)null, responseHandler);
    }

    public static <T> T httpGet(String poolname, String url, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(poolname, url, (String)null, (String)null, headers, responseHandler);
    }

    public static <T> T httpGet(String url, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString("default", url, (String)null, (String)null, headers, responseHandler);
    }

    public static String httpGetforString(String url, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(url, (String)null, (String)null, headers);
    }

    public static String httpGetforString(String poolname, String url, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(poolname, url, (String)null, (String)null, headers);
    }

    public static String httpGetforStringWithParams(String poolname, String url, Object params) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGet(poolname, url, (String)null, (String)null, params, (Map)null, new StringResponseHandler());
    }

    public static String httpGetforStringWithParams(String url, Object params) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGet((String)null, url, (String)null, (String)null, params, (Map)null, new StringResponseHandler());
    }

    public static String httpGetforStringWithParamsHeaders(String poolname, String url, Object params, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGet(poolname, url, (String)null, (String)null, params, headers, new StringResponseHandler());
    }

    public static String httpGetforStringWithParamsHeaders(String url, Object params, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGet((String)null, url, (String)null, (String)null, params, headers, new StringResponseHandler());
    }

    public static <T> T httpGetforString(String poolname, String url, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(poolname, url, (String)null, (String)null, headers, responseHandler);
    }

    public static <T> T httpGetforString(String url, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString("default", url, (String)null, (String)null, headers, responseHandler);
    }

    public static String httpGetforString(String url, String cookie, String userAgent, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString("default", url, cookie, userAgent, headers);
    }

    public static String httpGetforString(String poolname, String url, String cookie, String userAgent, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(poolname, url, cookie, userAgent, headers, new StringResponseHandler());
    }

    public static String httpGetforString(ClientConfiguration clientConfiguration, String url, String cookie, String userAgent, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGetforString(clientConfiguration, url, cookie, userAgent, headers, new StringResponseHandler());
    }

    public static <T> T httpGetforString(String poolname, String url, String cookie, String userAgent, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGet(poolname, url, cookie, userAgent, (Object)null, headers, responseHandler);
    }

    public static <T> T httpGetforString(ClientConfiguration clientConfiguration, String url, String cookie, String userAgent, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGet(clientConfiguration, url, cookie, userAgent, (Object)null, headers, responseHandler);
    }

    public static <T> T httpGetforString(String poolname, String url, String cookie, String userAgent, Object params, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpGet(poolname, url, cookie, userAgent, params, headers, responseHandler);
    }

    public static <T> T httpGet(String poolname, String url, final String cookie, final String userAgent, Object params, final Map headers, final ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        url = HttpParamsHandler.appendParams(url, params);
        return HttpRequestProxy._handleRequest(poolname, url, responseHandler, new ExecuteRequest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object execute(ClientConfiguration config, HttpClient httpClient, String url, int triesCount) throws Exception {
                HttpGet httpGet = null;
                try {
                    httpGet = HttpRequestUtil.getHttpGet(config, url, cookie, userAgent, headers);
                    Object object = httpClient.execute((HttpUriRequest)httpGet, responseHandler);
                    return object;
                }
                finally {
                    if (httpGet != null) {
                        httpGet.releaseConnection();
                    }
                }
            }
        });
    }

    public static <T> T httpGet(ClientConfiguration clientConfiguration, String url, final String cookie, final String userAgent, Object params, final Map headers, final ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        url = HttpParamsHandler.appendParams(url, params);
        return HttpRequestProxy._handleRequest(clientConfiguration, url, responseHandler, new ExecuteRequest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object execute(ClientConfiguration config, HttpClient httpClient, String url, int triesCount) throws Exception {
                HttpGet httpGet = null;
                try {
                    httpGet = HttpRequestUtil.getHttpGet(config, url, cookie, userAgent, headers);
                    Object object = httpClient.execute((HttpUriRequest)httpGet, responseHandler);
                    return object;
                }
                finally {
                    if (httpGet != null) {
                        httpGet.releaseConnection();
                    }
                }
            }
        });
    }

    public static <T> T httpHead(String poolname, String url, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpHead(poolname, url, null, null, null, responseHandler);
    }

    public static <T> T httpHead(String url, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpHead("default", url, null, null, null, responseHandler);
    }

    public static <T> T httpHead(String poolname, String url, Object params, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpHead(poolname, url, null, null, params, headers, responseHandler);
    }

    public static <T> T httpHead(String poolname, String url, String cookie, String userAgent, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpHead(poolname, url, cookie, userAgent, null, headers, responseHandler);
    }

    public static <T> T httpHead(String poolname, String url, final String cookie, final String userAgent, final Object params, final Map headers, final ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy._handleRequest(poolname, url, responseHandler, new ExecuteRequest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object execute(ClientConfiguration config, HttpClient httpClient, String url, int triesCount) throws Exception {
                HttpHead httpHead = null;
                try {
                    HttpParams httpParams;
                    httpHead = HttpRequestUtil.getHttpHead(config, url, cookie, userAgent, headers);
                    if (params != null && (httpParams = HttpParamsHandler.httpParams(params)) != null) {
                        httpHead.setParams(httpParams);
                    }
                    Object object = httpClient.execute((HttpUriRequest)httpHead, responseHandler);
                    return object;
                }
                finally {
                    if (httpHead != null) {
                        httpHead.releaseConnection();
                    }
                }
            }
        });
    }

    public static String httpPostFileforString(String url, Object params, Map<String, File> files) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostFileforString("default", url, (String)null, (String)null, params, files);
    }

    public static String httpPostFileforString(String poolname, String url, Object params, Map<String, File> files) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostFileforString(poolname, url, (String)null, (String)null, params, files);
    }

    public static String httpPostforStringWithParams(String url, Object params) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostforString(null, url, params);
    }

    public static <T> T httpPostWithParams(String url, Object params, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostforString(url, params, null, responseHandler);
    }

    public static <T> T httpPostForObject(String url, Object params, final Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostforString(url, params, null, new BaseURLResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> List<T> httpPostForListWithParams(String url, Object params, final Class<T> resultType) throws HttpProxyRequestException {
        return (List)HttpRequestProxy.httpPostforString(url, params, null, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> Set<T> httpPostForSet(String url, Object params, final Class<T> resultType) throws HttpProxyRequestException {
        return (Set)HttpRequestProxy.httpPostforString(url, params, null, new BaseURLResponseHandler<Set<T>>(){

            public Set<T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleSetResponse(this.url, response, resultType);
            }
        });
    }

    public static <K, T> Map<K, T> httpPostForMap(String url, Object params, final Class<K> keyType, final Class<T> resultType) throws HttpProxyRequestException {
        return (Map)HttpRequestProxy.httpPostforString(url, params, null, new BaseURLResponseHandler<Map<K, T>>(){

            public Map<K, T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleMapResponse(this.url, response, keyType, resultType);
            }
        });
    }

    public static <T> T httpPostForObject(String poolName, String url, Object params, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        return HttpRequestProxy.httpPost(poolName, url, httpOption, new BaseURLResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> T httpPostForObject(String poolName, String url, Object params, final Class<T> resultType, DataSerialType dataSerialType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.dataSerialType = dataSerialType;
        return HttpRequestProxy.httpPost(poolName, url, httpOption, new BaseURLResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> List<T> httpPostForList(String poolName, String url, Object params, final Class<T> resultType, DataSerialType dataSerialType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.dataSerialType = dataSerialType;
        return (List)HttpRequestProxy.httpPost(poolName, url, httpOption, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> Set<T> httpPostForSet(String poolName, String url, Object params, final Class<T> resultType, DataSerialType dataSerialType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.dataSerialType = dataSerialType;
        return (Set)HttpRequestProxy.httpPost(poolName, url, httpOption, new BaseURLResponseHandler<Set<T>>(){

            public Set<T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleSetResponse(this.url, response, resultType);
            }
        });
    }

    public static <K, T> Map<K, T> httpPostForMap(String poolName, String url, Object params, final Class<K> keyType, final Class<T> resultType, DataSerialType dataSerialType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.dataSerialType = dataSerialType;
        return (Map)HttpRequestProxy.httpPost(poolName, url, httpOption, new BaseURLResponseHandler<Map<K, T>>(){

            public Map<K, T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleMapResponse(this.url, response, keyType, resultType);
            }
        });
    }

    public static <T> List<T> httpPostForList(String poolName, String url, Object params, final Class<T> resultType) throws HttpProxyRequestException {
        return (List)HttpRequestProxy.httpPostforString(poolName, url, params, (Map)null, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> List<T> httpPostForList(String poolName, String url, Object params, Map headers, final Class<T> resultType) throws HttpProxyRequestException {
        return (List)HttpRequestProxy.httpPostforString(poolName, url, params, headers, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> List<T> httpPostForList(String poolName, String url, Object params, Map headers, Class<T> resultType, BaseURLResponseHandler<List<T>> baseURLResponseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostforString(poolName, url, params, headers, baseURLResponseHandler);
    }

    public static <T> List<T> httpPostForList(String poolName, String url, final Class<T> resultType) throws HttpProxyRequestException {
        return (List)HttpRequestProxy.httpPostforString(poolName, url, (Object)null, (Map)null, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> List<T> httpPostForList(String url, final Class<T> resultType) throws HttpProxyRequestException {
        return (List)HttpRequestProxy.httpPostforString((String)null, url, (Object)null, (Map)null, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> Set<T> httpPostForSet(String poolName, String url, Object params, final Class<T> resultType) throws HttpProxyRequestException {
        return (Set)HttpRequestProxy.httpPostforString(poolName, url, params, (Map)null, new BaseURLResponseHandler<Set<T>>(){

            public Set<T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleSetResponse(this.url, response, resultType);
            }
        });
    }

    public static <K, T> Map<K, T> httpPostForMap(String poolName, String url, Object params, final Class<K> keyType, final Class<T> resultType) throws HttpProxyRequestException {
        return (Map)HttpRequestProxy.httpPostforString(poolName, url, params, (Map)null, new BaseURLResponseHandler<Map<K, T>>(){

            public Map<K, T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleMapResponse(this.url, response, keyType, resultType);
            }
        });
    }

    public static String httpPostforStringWithHeaders(String url, Object params, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostFileforString("default", url, (String)null, (String)null, params, (Map<String, File>)null, headers);
    }

    public static String httpPostforString(String poolName, String url, Object params, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostFileforString(poolName, url, (String)null, (String)null, params, (Map<String, File>)null, headers);
    }

    public static <T> T httpPost(String url, Object params, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPost("default", url, (String)null, (String)null, params, (Map<String, File>)null, headers, responseHandler);
    }

    public static <T> T httpPostforString(String url, Object params, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPost("default", url, (String)null, (String)null, params, (Map<String, File>)null, headers, responseHandler);
    }

    public static <T> T httpPostforString(String poolName, String url, Object params, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPost(poolName, url, (String)null, (String)null, params, (Map<String, File>)null, headers, responseHandler);
    }

    public static String httpPostforString(String poolname, String url, Object params) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        return HttpRequestProxy.httpPost(poolname, url, httpOption, new StringResponseHandler());
    }

    public static String httpPostforString(String poolname, String url, Object params, DataSerialType dataSerialType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.dataSerialType = dataSerialType;
        return HttpRequestProxy.httpPost(poolname, url, httpOption, new StringResponseHandler());
    }

    public static String httpPostforString(String url) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostforString("default", url, null);
    }

    public static <T> T httpPost(String url, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPost("default", url, responseHandler);
    }

    public static String httpPostforString(String poolname, String url) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostFileforString(poolname, url, (String)null, (String)null, (Object)null, (Map<String, File>)null);
    }

    public static String httpPostforString(ClientConfiguration clientConfiguration, String url) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostFileforString(clientConfiguration, url, (String)null, (String)null, (Object)null, (Map<String, File>)null);
    }

    public static <T> T httpPost(String poolname, String url, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPost(poolname, url, (String)null, (String)null, (Object)null, (Map<String, File>)null, (Map)null, responseHandler);
    }

    public static String httpPostforStringWithFiles(String url, String cookie, String userAgent, Map<String, File> files) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostforString("default", url, cookie, userAgent, files);
    }

    public static String httpPostforString(String poolname, String url, String cookie, String userAgent, Map<String, File> files) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostFileforString(poolname, url, cookie, userAgent, null, files);
    }

    public static String httpPostforStringWithParams(String url, String cookie, String userAgent, Object params, Map<String, File> files) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostFileforString("default", url, cookie, userAgent, params, files);
    }

    public static String httpPostFileforString(String poolname, String url, String cookie, String userAgent, Object params, Map<String, File> files) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostFileforString(poolname, url, cookie, userAgent, params, files, null);
    }

    public static String httpPostFileforString(ClientConfiguration clientConfiguration, String url, String cookie, String userAgent, Object params, Map<String, File> files) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostFileforString(clientConfiguration, url, cookie, userAgent, params, files, null);
    }

    public static <T> T httpPost(String poolname, String url, HttpOption httpOption, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        ClientConfiguration config = ClientConfiguration.getClientConfiguration(poolname);
        return HttpRequestProxy.httpPost(config, url, httpOption, responseHandler);
    }

    public static <T> T httpPost(ClientConfiguration clientConfiguration, String url, final HttpOption httpOption, final ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        HttpEntity httpEntity = null;
        List<NameValuePair> paramPair = null;
        if (httpOption.files != null) {
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            boolean hasdata = HttpParamsHandler.paramsHandle(multipartEntityBuilder, httpOption);
            if (httpOption.files != null) {
                for (Map.Entry<String, File> entry : httpOption.files.entrySet()) {
                    File f = new File(String.valueOf(entry.getValue()));
                    if (!f.exists()) continue;
                    FileBody file = new FileBody(f);
                    multipartEntityBuilder.addPart(entry.getKey(), (ContentBody)file);
                    hasdata = true;
                }
            }
            if (hasdata) {
                httpEntity = multipartEntityBuilder.build();
            }
        } else if (httpOption.params != null) {
            paramPair = HttpParamsHandler.paramsPaires(httpOption);
        }
        final HttpEntity _httpEntity = httpEntity;
        final List<NameValuePair> _paramPair = paramPair;
        return HttpRequestProxy._handleRequest(clientConfiguration, url, responseHandler, new ExecuteRequest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object execute(ClientConfiguration config, HttpClient httpClient, String url, int triesCount) throws Exception {
                HttpPost httpPost = null;
                try {
                    httpPost = HttpRequestUtil.getHttpPost(config, url, httpOption.cookie, httpOption.userAgent, httpOption.headers);
                    if (_httpEntity != null) {
                        httpPost.setEntity(_httpEntity);
                    } else if (_paramPair != null && _paramPair.size() > 0) {
                        UrlEncodedFormEntity entity = new UrlEncodedFormEntity((Iterable)_paramPair, Consts.UTF_8);
                        httpPost.setEntity((HttpEntity)entity);
                    }
                    Object object = httpClient.execute((HttpUriRequest)httpPost, responseHandler);
                    return object;
                }
                finally {
                    if (httpPost != null) {
                        httpPost.releaseConnection();
                    }
                }
            }
        });
    }

    public static <T> T httpPost(String poolname, String url, String cookie, String userAgent, Object params, Map<String, File> files, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        ClientConfiguration config = ClientConfiguration.getClientConfiguration(poolname);
        return HttpRequestProxy.httpPost(config, url, cookie, userAgent, params, files, headers, responseHandler);
    }

    public static <T> T httpPost(ClientConfiguration clientConfiguration, String url, String cookie, String userAgent, Object params, Map<String, File> files, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.cookie = cookie;
        httpOption.userAgent = userAgent;
        httpOption.params = params;
        httpOption.files = files;
        httpOption.headers = headers;
        return HttpRequestProxy.httpPost(clientConfiguration, url, httpOption, responseHandler);
    }

    public static String httpPutforString(String poolname, String url, String cookie, String userAgent, Object params, Map<String, File> files, Map headers) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.cookie = cookie;
        httpOption.userAgent = userAgent;
        httpOption.params = params;
        httpOption.files = files;
        httpOption.headers = headers;
        return HttpRequestProxy.httpPut(poolname, url, httpOption, new StringResponseHandler());
    }

    public static String httpPutforString(String url, Object params, Map headers) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.headers = headers;
        return HttpRequestProxy.httpPut("default", url, httpOption, new StringResponseHandler());
    }

    public static <T> T httpPutforObject(String url, Object params, Map headers, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.headers = headers;
        return HttpRequestProxy.httpPut("default", url, httpOption, new BaseURLResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> List<T> httpPutforList(String url, Object params, Map headers, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.headers = headers;
        return (List)HttpRequestProxy.httpPut("default", url, httpOption, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> Set<T> httpPutforSet(String url, Object params, Map headers, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.headers = headers;
        return (Set)HttpRequestProxy.httpPut("default", url, httpOption, new BaseURLResponseHandler<Set<T>>(){

            public Set<T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleSetResponse(this.url, response, resultType);
            }
        });
    }

    public static <K, T> Map<K, T> httpPutforObject(String url, Object params, Map headers, final Class<K> keyType, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.headers = headers;
        return (Map)HttpRequestProxy.httpPut("default", url, httpOption, new BaseURLResponseHandler<Map<K, T>>(){

            public Map<K, T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleMapResponse(this.url, response, keyType, resultType);
            }
        });
    }

    public static <T> T httpPutforObject(String poolName, String url, Object params, Map headers, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.headers = headers;
        return HttpRequestProxy.httpPut(poolName, url, httpOption, new BaseURLResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> List<T> httpPutforList(String poolName, String url, Object params, Map headers, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.headers = headers;
        return (List)HttpRequestProxy.httpPut(poolName, url, httpOption, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> List<T> httpPutforList(String poolName, String url, Object params, Map headers, Class<T> resultType, BaseURLResponseHandler<List<T>> baseURLResponseHandler) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.headers = headers;
        return HttpRequestProxy.httpPut(poolName, url, httpOption, baseURLResponseHandler);
    }

    public static <T> Set<T> httpPutforSet(String poolName, String url, Object params, Map headers, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.headers = headers;
        return (Set)HttpRequestProxy.httpPut(poolName, url, httpOption, new BaseURLResponseHandler<Set<T>>(){

            public Set<T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleSetResponse(this.url, response, resultType);
            }
        });
    }

    public static <K, T> Map<K, T> httpPutforObject(String poolName, String url, Object params, Map headers, final Class<K> keyType, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.headers = headers;
        return (Map)HttpRequestProxy.httpPut(poolName, url, httpOption, new BaseURLResponseHandler<Map<K, T>>(){

            public Map<K, T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleMapResponse(this.url, response, keyType, resultType);
            }
        });
    }

    public static <T> T httpPutforString(String url, Object params, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.headers = headers;
        return HttpRequestProxy.httpPut("default", url, httpOption, responseHandler);
    }

    public static String httpPutforString(String poolname, String url, Object params, Map headers) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.headers = headers;
        return HttpRequestProxy.httpPut(poolname, url, httpOption, new StringResponseHandler());
    }

    public static <T> T httpPutforString(String poolname, String url, Object params, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.headers = headers;
        return HttpRequestProxy.httpPut(poolname, url, httpOption, responseHandler);
    }

    public static <T> T httpPut(String url, String cookie, String userAgent, Object params, Map<String, File> files, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.cookie = cookie;
        httpOption.userAgent = userAgent;
        httpOption.params = params;
        httpOption.headers = headers;
        httpOption.files = files;
        return HttpRequestProxy.httpPut("default", url, httpOption, responseHandler);
    }

    public static <T> T httpPut(String url, Object params, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPut(url, null, null, (Map)params, null, headers, responseHandler);
    }

    public static <T> T httpPut(String url, Object params, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPut(url, null, null, (Map)params, null, null, responseHandler);
    }

    public static <T> T httpPut(String url, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPut(url, null, null, null, null, null, responseHandler);
    }

    public static <T> T httpPut(String url, final Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPut(url, null, null, null, null, null, new BaseURLResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> List<T> httpPutForList(String url, final Class<T> resultType) throws HttpProxyRequestException {
        return (List)HttpRequestProxy.httpPut(url, null, null, null, null, null, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> Set<T> httpPutForSet(String url, final Class<T> resultType) throws HttpProxyRequestException {
        return (Set)HttpRequestProxy.httpPut(url, null, null, null, null, null, new BaseURLResponseHandler<Set<T>>(){

            public Set<T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleSetResponse(this.url, response, resultType);
            }
        });
    }

    public static <K, T> Map<K, T> httpPutForMap(String url, final Class<K> keyType, final Class<T> resultType) throws HttpProxyRequestException {
        return (Map)HttpRequestProxy.httpPut(url, null, null, null, null, null, new BaseURLResponseHandler<Map<K, T>>(){

            public Map<K, T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleMapResponse(this.url, response, keyType, resultType);
            }
        });
    }

    public static <T> T httpPut(String poolName, String url, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        return HttpRequestProxy.httpPut(poolName, url, httpOption, new BaseURLResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> List<T> httpPutForList(String poolName, String url, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        return (List)HttpRequestProxy.httpPut(poolName, url, httpOption, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> Set<T> httpPutForSet(String poolName, String url, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        return (Set)HttpRequestProxy.httpPut(poolName, url, httpOption, new BaseURLResponseHandler<Set<T>>(){

            public Set<T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleSetResponse(this.url, response, resultType);
            }
        });
    }

    public static <K, T> Map<K, T> httpPutForMap(String poolName, String url, final Class<K> keyType, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        return (Map)HttpRequestProxy.httpPut(poolName, url, httpOption, new BaseURLResponseHandler<Map<K, T>>(){

            public Map<K, T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleMapResponse(this.url, response, keyType, resultType);
            }
        });
    }

    public static <T> T httpPut(String poolname, String url, String cookie, String userAgent, Object params, Map<String, File> files, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.cookie = cookie;
        httpOption.userAgent = userAgent;
        httpOption.params = params;
        httpOption.files = files;
        httpOption.headers = headers;
        return HttpRequestProxy.httpPut(poolname, url, httpOption, responseHandler);
    }

    public static <T> T httpPut(String poolname, String url, final HttpOption httpOption, final ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        HttpEntity httpEntity = null;
        List<NameValuePair> paramPair = null;
        if (httpOption.files != null) {
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            boolean hasdata = HttpParamsHandler.paramsHandle(multipartEntityBuilder, httpOption);
            if (httpOption.files != null) {
                for (Map.Entry<String, File> entry : httpOption.files.entrySet()) {
                    File f = new File(String.valueOf(entry.getValue()));
                    if (!f.exists()) continue;
                    FileBody file = new FileBody(f);
                    multipartEntityBuilder.addPart(entry.getKey(), (ContentBody)file);
                    hasdata = true;
                }
            }
            if (hasdata) {
                httpEntity = multipartEntityBuilder.build();
            }
        } else if (httpOption.params != null) {
            paramPair = HttpParamsHandler.paramsPaires(httpOption);
        }
        final HttpEntity _httpEntity = httpEntity;
        final List<NameValuePair> _paramPair = paramPair;
        return HttpRequestProxy._handleRequest(poolname, url, responseHandler, new ExecuteRequest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object execute(ClientConfiguration config, HttpClient httpClient, String url, int triesCount) throws Exception {
                HttpPut httpPut = null;
                try {
                    httpPut = HttpRequestUtil.getHttpPut(config, url, httpOption.cookie, httpOption.userAgent, httpOption.headers);
                    if (_httpEntity != null) {
                        httpPut.setEntity(_httpEntity);
                    } else if (_paramPair != null && _paramPair.size() > 0) {
                        UrlEncodedFormEntity entity = new UrlEncodedFormEntity((Iterable)_paramPair, Consts.UTF_8);
                        httpPut.setEntity((HttpEntity)entity);
                    }
                    Object object = httpClient.execute((HttpUriRequest)httpPut, responseHandler);
                    return object;
                }
                finally {
                    if (httpPut != null) {
                        httpPut.releaseConnection();
                    }
                }
            }
        });
    }

    public static String httpPostFileforString(String poolname, String url, String cookie, String userAgent, Object params, Map<String, File> files, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPost(poolname, url, cookie, userAgent, params, files, headers, new StringResponseHandler());
    }

    public static String httpPostFileforString(ClientConfiguration clientConfiguration, String url, String cookie, String userAgent, Object params, Map<String, File> files, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPost(clientConfiguration, url, cookie, userAgent, params, files, headers, new StringResponseHandler());
    }

    public static String httpPostFileforString(String poolname, String url, Object params, Map<String, File> files, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPost(poolname, url, (String)null, (String)null, params, files, headers, new StringResponseHandler());
    }

    public static String httpPostFileforString(String url, Object params, Map<String, File> files, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPost("default", url, (String)null, (String)null, params, files, headers, new StringResponseHandler());
    }

    public static String httpDelete(String poolname, String url) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete(poolname, url, (String)null, null, (Object)null, (Map)null);
    }

    public static String httpDelete(String url) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete("default", url, (String)null, null, (Object)null, (Map)null);
    }

    public static String httpDeleteWithbody(String url, String requestBody) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete("default", url, requestBody, null, null, null, null);
    }

    public static String httpDelete(String url, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete("default", url, (String)null, null, (Object)null, headers);
    }

    public static String httpDelete(String url, String requestBody, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete("default", url, requestBody, null, null, null, headers);
    }

    public static String httpDeleteWithbody(String url, String requestBody, Object params, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete("default", url, requestBody, null, null, params, headers);
    }

    public static String httpDeleteWithParams(String url, Object params, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete("default", url, (String)null, null, params, headers);
    }

    public static <T> T httpDelete(String url, Object params, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete("default", url, null, null, null, params, headers, responseHandler);
    }

    public static <T> T httpDeleteWithBody(String url, String requestBody, Object params, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete("default", url, requestBody, null, null, params, headers, responseHandler);
    }

    public static String httpDelete(String poolname, String url, Object params, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete(poolname, url, (String)null, null, params, headers);
    }

    public static String httpDelete(String poolname, String url, String requestBody, Object params, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete(poolname, url, requestBody, null, null, params, headers);
    }

    public static <T> T httpDelete(String poolname, String url, Object params, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete(poolname, url, null, null, null, params, headers, responseHandler);
    }

    public static <T> T httpDelete(String poolname, String url, String requestBody, Object params, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete(poolname, url, requestBody, null, null, params, headers, responseHandler);
    }

    public static String httpDelete(String poolname, String url, String cookie, String userAgent, Object params, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete(poolname, url, null, cookie, userAgent, params, headers, new StringResponseHandler());
    }

    public static String httpDelete(String poolname, String url, String requestBody, String cookie, String userAgent, Object params, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.httpDelete(poolname, url, requestBody, cookie, userAgent, params, headers, new StringResponseHandler());
    }

    public static <T> T httpDelete(String poolname, String url, String requestBody, String cookie, String userAgent, Object params, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        StringEntity httpEntity = requestBody == null ? null : new StringEntity(requestBody, ContentType.APPLICATION_JSON);
        HttpParams httpParams = null;
        if (params != null) {
            httpParams = HttpParamsHandler.httpParams(params);
        }
        HttpParams _httpParams = httpParams;
        return HttpRequestProxy._handleRequest(poolname, url, responseHandler, new ExecuteRequest(){
            final /* synthetic */ HttpEntity val$httpEntity;
            final /* synthetic */ String val$cookie;
            final /* synthetic */ String val$userAgent;
            final /* synthetic */ Map val$headers;
            final /* synthetic */ HttpParams val$_httpParams;
            final /* synthetic */ ResponseHandler val$responseHandler;
            {
                this.val$httpEntity = httpEntity;
                this.val$cookie = string;
                this.val$userAgent = string2;
                this.val$headers = map;
                this.val$_httpParams = httpParams;
                this.val$responseHandler = responseHandler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object execute(ClientConfiguration config, HttpClient httpClient, String url, int triesCount) throws Exception {
                HttpDeleteWithBody httpDeleteWithBody = null;
                HttpDelete httpDelete = null;
                try {
                    Object responseBody = null;
                    if (this.val$httpEntity != null) {
                        httpDeleteWithBody = HttpRequestUtil.getHttpDeleteWithBody(config, url, this.val$cookie, this.val$userAgent, this.val$headers);
                        httpDeleteWithBody.setEntity(this.val$httpEntity);
                        if (this.val$_httpParams != null) {
                            httpDeleteWithBody.setParams(this.val$_httpParams);
                        }
                        responseBody = httpClient.execute((HttpUriRequest)httpDeleteWithBody, this.val$responseHandler);
                    } else {
                        httpDelete = HttpRequestUtil.getHttpDelete(config, url, this.val$cookie, this.val$userAgent, this.val$headers);
                        if (this.val$_httpParams != null) {
                            httpDelete.setParams(this.val$_httpParams);
                        }
                        responseBody = httpClient.execute((HttpUriRequest)httpDelete, this.val$responseHandler);
                    }
                    Object object = responseBody;
                    return object;
                }
                finally {
                    if (httpDelete != null) {
                        try {
                            httpDelete.releaseConnection();
                        }
                        catch (Exception exception) {}
                    }
                    if (httpDeleteWithBody != null) {
                        try {
                            httpDeleteWithBody.releaseConnection();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        });
    }

    public static String sendStringBody(String poolname, String requestBody, String url, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody(poolname, requestBody, url, headers, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8));
    }

    public static String sendJsonBody(String poolname, Object requestBody, String url) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody(poolname, HttpRequestUtil.object2json(requestBody), url, null, ContentType.APPLICATION_JSON);
    }

    public static <T> T sendJsonBody(String poolname, Object requestBody, String url, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody(poolname, HttpRequestUtil.object2json(requestBody), url, null, ContentType.APPLICATION_JSON, resultType);
    }

    public static <T> T sendJsonBody(String poolname, Object requestBody, Map<String, String> headers, String url, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody(poolname, HttpRequestUtil.object2json(requestBody), url, headers, ContentType.APPLICATION_JSON, resultType);
    }

    public static <T> List<T> sendJsonBodyForList(String poolname, Object requestBody, String url, Map headers, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBodyForList(poolname, HttpRequestUtil.object2json(requestBody), url, headers, ContentType.APPLICATION_JSON, resultType);
    }

    public static <T> List<T> sendJsonBodyForList(String poolname, Object requestBody, String url, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBodyForList(poolname, HttpRequestUtil.object2json(requestBody), url, null, ContentType.APPLICATION_JSON, resultType);
    }

    public static <T> List<T> sendJsonBodyForList(Object requestBody, String url, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBodyForList(null, HttpRequestUtil.object2json(requestBody), url, null, ContentType.APPLICATION_JSON, resultType);
    }

    public static <D, T> D sendJsonBodyTypeObject(String poolname, String url, Object requestBody, Map headers, Class<D> containerType, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBodyForTypeObject(poolname, url, HttpRequestUtil.object2json(requestBody), headers, ContentType.APPLICATION_JSON, containerType, resultType);
    }

    public static <D, T> D sendJsonBodyTypeObject(String poolname, String url, Object requestBody, Class<D> containerType, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBodyForTypeObject(poolname, url, HttpRequestUtil.object2json(requestBody), null, ContentType.APPLICATION_JSON, containerType, resultType);
    }

    public static <D, T> D sendJsonBodyTypeObject(String url, Object requestBody, Class<D> containerType, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBodyForTypeObject(null, url, HttpRequestUtil.object2json(requestBody), null, ContentType.APPLICATION_JSON, containerType, resultType);
    }

    public static <T> Set<T> sendJsonBodyForSet(String poolname, Object requestBody, String url, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBodyForSet(poolname, HttpRequestUtil.object2json(requestBody), url, null, ContentType.APPLICATION_JSON, resultType);
    }

    public static <T> Set<T> sendJsonBodyForSet(Object requestBody, String url, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBodyForSet(null, HttpRequestUtil.object2json(requestBody), url, null, ContentType.APPLICATION_JSON, resultType);
    }

    public static <K, T> Map<K, T> sendJsonBodyForMap(String poolname, Object requestBody, String url, Class<K> keyType, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBodyForMap(poolname, HttpRequestUtil.object2json(requestBody), url, null, ContentType.APPLICATION_JSON, keyType, resultType);
    }

    public static <K, T> Map<K, T> sendJsonBodyForMap(Object requestBody, String url, Class<K> keyType, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBodyForMap(null, HttpRequestUtil.object2json(requestBody), url, null, ContentType.APPLICATION_JSON, keyType, resultType);
    }

    public static String sendStringBody(String poolname, String requestBody, String url) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody(poolname, requestBody, url, null, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8));
    }

    public static <T> T sendJsonBody(String poolname, Object requestBody, String url, Map headers, Class<T> type) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody(poolname, HttpRequestUtil.object2json(requestBody), url, headers, ContentType.APPLICATION_JSON, type);
    }

    public static String sendJsonBody(String poolname, Object requestBody, String url, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody(poolname, HttpRequestUtil.object2json(requestBody), url, headers, ContentType.APPLICATION_JSON);
    }

    public static String sendStringBody(String requestBody, String url, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody("default", requestBody, url, headers, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8));
    }

    public static String sendJsonBody(String url) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody("default", (String)null, url, null, ContentType.APPLICATION_JSON);
    }

    public static String sendJsonBodyWithPool(String poolName, String url) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody(poolName, (String)null, url, null, ContentType.APPLICATION_JSON);
    }

    public static String sendJsonBody(Object requestBody, String url) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody("default", HttpRequestUtil.object2json(requestBody), url, null, ContentType.APPLICATION_JSON);
    }

    public static <T> T sendJsonBody(Object requestBody, String url, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody("default", HttpRequestUtil.object2json(requestBody), url, null, ContentType.APPLICATION_JSON, resultType);
    }

    public static <T> T sendJsonBody(Object requestBody, String url, Map headers, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody("default", HttpRequestUtil.object2json(requestBody), url, headers, ContentType.APPLICATION_JSON, resultType);
    }

    public static <T> T sendJsonBody(Object requestBody, String url, InvokeContext invokeContext, Class<T> resultType) throws HttpProxyRequestException {
        if (invokeContext != null && invokeContext.getRequestContentType() == null) {
            invokeContext.setRequestContentType(ContentType.APPLICATION_JSON);
        }
        return HttpRequestProxy.sendBody("default", HttpRequestUtil.object2json(requestBody), url, invokeContext, resultType);
    }

    public static <D, T> D sendJsonBody(Object requestBody, String url, Class<D> containType, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody("default", HttpRequestUtil.object2json(requestBody), url, null, ContentType.APPLICATION_JSON, containType, resultType);
    }

    public static String sendStringBody(String requestBody, String url) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody("default", requestBody, url, null, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8));
    }

    public static String sendStringBody(String requestBody, String url, String mimeType, Charset charSet) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody("default", requestBody, url, null, ContentType.create((String)mimeType, (Charset)charSet));
    }

    public static String sendJsonBody(String requestBody, String url, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody("default", requestBody, url, headers, ContentType.APPLICATION_JSON);
    }

    public static String sendJsonBody(String requestBody, String url, InvokeContext invokeContext) throws HttpProxyRequestException {
        if (invokeContext != null && invokeContext.getRequestContentType() == null) {
            invokeContext.setRequestContentType(ContentType.APPLICATION_JSON);
        }
        return HttpRequestProxy.sendBody("default", requestBody, url, invokeContext);
    }

    public static <T> T sendJsonBody(String requestBody, String url, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody("default", requestBody, url, headers, ContentType.APPLICATION_JSON, responseHandler);
    }

    public static <T> T sendJsonBody(String poolname, String requestBody, String url, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody(poolname, requestBody, url, headers, ContentType.APPLICATION_JSON, responseHandler);
    }

    private static void injectBody(ResponseHandler responseHandler, String requestBody) {
        BaseURLResponseHandler baseURLResponseHandler;
        if (requestBody == null || responseHandler == null) {
            return;
        }
        if (responseHandler instanceof BaseURLResponseHandler && !(baseURLResponseHandler = (BaseURLResponseHandler)responseHandler).isEnableSetRequestBody() && baseURLResponseHandler.getRequestBody() == null) {
            baseURLResponseHandler.setRequestBody(requestBody);
            baseURLResponseHandler.setEnableSetRequestBody(true);
            baseURLResponseHandler.setTruncateLogBody(true);
        }
    }

    public static <T> T sendBody(String poolname, String requestBody, String url, Map headers, ContentType contentType, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        InvokeContext invokeContext = new InvokeContext();
        invokeContext.setHeaders(headers);
        invokeContext.setRequestContentType(contentType);
        return HttpRequestProxy.sendBody(poolname, requestBody, url, invokeContext, responseHandler);
    }

    public static <T> T sendBody(String poolname, String requestBody, String url, final InvokeContext invokeContext, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        StringEntity httpEntity = new StringEntity(requestBody, invokeContext.getRequestContentType());
        HttpRequestProxy.injectBody(responseHandler, requestBody);
        return HttpRequestProxy._handleRequest(poolname, url, responseHandler, new ExecuteRequest(){
            final /* synthetic */ HttpEntity val$httpEntity;
            final /* synthetic */ ResponseHandler val$responseHandler;
            {
                this.val$httpEntity = httpEntity;
                this.val$responseHandler = responseHandler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object execute(ClientConfiguration config, HttpClient httpClient, String url, int triesCount) throws Exception {
                HttpPost httpPost = null;
                try {
                    httpPost = HttpRequestUtil.getHttpPost(config, url, "", "", invokeContext.getHeaders());
                    httpPost.setEntity(this.val$httpEntity);
                    Object object = httpClient.execute((HttpUriRequest)httpPost, this.val$responseHandler);
                    return object;
                }
                finally {
                    if (httpPost != null) {
                        httpPost.releaseConnection();
                    }
                }
            }
        });
    }

    public static ClientConfiguration stopHttpClient(String poolName) {
        return ClientConfiguration.stopHttpClient(poolName);
    }

    public static void stopHttpClients(ResourceStartResult resourceStartResult) {
        Map reses;
        if (resourceStartResult != null && (reses = resourceStartResult.getResourceStartResult()) != null && reses.size() > 0) {
            for (Map.Entry entry : reses.entrySet()) {
                try {
                    ClientConfiguration.stopHttpClient((String)entry.getKey());
                }
                catch (Exception e) {
                    logger.warn("stop http pool " + (String)entry.getKey() + " failed:", (Throwable)e);
                }
            }
        }
    }

    private static StringBuilder trucateData(ResponseHandler responseHandler) {
        BaseURLResponseHandler baseURLResponseHandler;
        if (responseHandler instanceof BaseURLResponseHandler && (baseURLResponseHandler = (BaseURLResponseHandler)responseHandler).isEnableSetRequestBody()) {
            StringBuilder builder = new StringBuilder();
            String requestBody = baseURLResponseHandler.getRequestBody();
            builder.append("RequestBody:");
            if (baseURLResponseHandler.isTruncateLogBody() && requestBody != null && requestBody.length() > 4096) {
                builder.append(requestBody.substring(0, 4095)).append("......");
            } else {
                builder.append(requestBody);
            }
            return builder;
        }
        return null;
    }

    private static <T> T _handleRequest(String poolname, String url, ResponseHandler<T> responseHandler, ExecuteRequest executeRequest) throws HttpProxyRequestException {
        ClientConfiguration config = ClientConfiguration.getClientConfiguration(poolname);
        return HttpRequestProxy._handleRequest(config, url, responseHandler, executeRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T _handleRequest(final ClientConfiguration config, String url, ResponseHandler<T> responseHandler, final ExecuteRequest executeRequest) throws HttpProxyRequestException {
        StringBuilder requestBody;
        Exception httpResponseStatusException;
        Throwable e;
        Object responseBody;
        block59: {
            HttpClient httpClient = null;
            String poolname = config.getBeanName();
            responseBody = null;
            String endpoint = null;
            e = null;
            httpResponseStatusException = null;
            int triesCount = 0;
            requestBody = HttpRequestProxy.trucateData(responseHandler);
            ExecuteIntercepter executeIntercepter = null;
            URLResponseHandler urlResponseHandler = null;
            if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                urlResponseHandler = (URLResponseHandler)responseHandler;
                executeIntercepter = urlResponseHandler.getExecuteIntercepter();
            }
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                endpoint = url;
                HttpAddress httpAddress = null;
                HttpServiceHosts httpServiceHosts = config.getHttpServiceHosts();
                HttpRequestProxy.assertCheck(httpServiceHosts, endpoint, config.getBeanName());
                while (true) {
                    try {
                        httpAddress = httpServiceHosts.getHttpAddress();
                        url = SimpleStringUtil.getPath((String)httpAddress.getAddress(), (String)endpoint);
                        if (logger.isDebugEnabled()) {
                            logger.debug("Send request {}", (Object)url);
                        }
                        if (urlResponseHandler != null) {
                            urlResponseHandler.setUrl(url);
                        }
                        httpClient = HttpRequestUtil.getHttpClient(config);
                        BaseRequestKerberosUrlUtils baseRequestKerberosUrlUtils = config.getRequestKerberosUrlUtils();
                        if (executeIntercepter != null) {
                            executeIntercepter.before(url, urlResponseHandler, triesCount);
                        }
                        if (baseRequestKerberosUrlUtils == null) {
                            responseBody = executeRequest.execute(config, httpClient, url, triesCount);
                        } else {
                            final String tempUrl = url;
                            final HttpClient tempHttpClient = httpClient;
                            final int tempTriesCount = triesCount;
                            responseBody = baseRequestKerberosUrlUtils.callRestUrl(new KerberosCallback<T>(){

                                @Override
                                public T call() throws Exception {
                                    return executeRequest.execute(config, tempHttpClient, tempUrl, tempTriesCount);
                                }
                            });
                        }
                        httpAddress.recover();
                        httpResponseStatusException = HttpParamsHandler.getException(responseHandler, httpServiceHosts);
                        break block59;
                    }
                    catch (HttpHostConnectException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block59;
                    }
                    catch (UnknownHostException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block59;
                    }
                    catch (NoRouteToHostException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block59;
                    }
                    catch (NoHttpResponseException ex) {
                        httpAddress.setStatus(1);
                        e = new NoHttpServerException(ex);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block59;
                    }
                    catch (ConnectionPoolTimeoutException ex) {
                        e = HttpRequestProxy.handleConnectionPoolTimeOutException(poolname, url, config, ex);
                        break block59;
                    }
                    catch (ConnectTimeoutException connectTimeoutException) {
                        httpAddress.setStatus(1);
                        e = HttpRequestProxy.handleConnectionTimeOutException(poolname, url, config, connectTimeoutException);
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block59;
                    }
                    catch (SocketTimeoutException ex) {
                        e = HttpRequestProxy.handleSocketTimeoutException(poolname, url, config, ex);
                        break block59;
                    }
                    catch (NoHttpServerException ex) {
                        e = ex;
                        break block59;
                    }
                    catch (ClientProtocolException ex) {
                        httpAddress.setStatus(1);
                        e = ex;
                        if (logger.isErrorEnabled()) {
                            logger.error("Send request[" + url + "] handle failed: must use http/https protocol port such as 9200,do not use other transport such as 9300.", (Throwable)ex);
                        }
                        if (!httpServiceHosts.reachEnd(triesCount)) {
                            ++triesCount;
                            continue;
                        }
                        break block59;
                    }
                    catch (Exception ex) {
                        e = ex;
                        break block59;
                    }
                    catch (Throwable ex) {
                        e = ex;
                        break block59;
                    }
                    finally {
                        if (executeIntercepter != null) {
                            executeIntercepter.after(url, urlResponseHandler, triesCount, responseBody, e);
                        }
                        httpClient = null;
                        continue;
                    }
                    break;
                }
            }
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Send request {}", (Object)url);
                }
                httpClient = HttpRequestUtil.getHttpClient(config);
                if (responseHandler != null && responseHandler instanceof URLResponseHandler) {
                    urlResponseHandler.setUrl(url);
                }
                if (executeIntercepter != null) {
                    executeIntercepter.before(url, urlResponseHandler, triesCount);
                }
                responseBody = executeRequest.execute(config, httpClient, url, triesCount);
                if (executeIntercepter != null) {
                    executeIntercepter.after(url, urlResponseHandler, triesCount, responseBody, null);
                }
            }
            catch (Exception ex) {
                e = ex;
                if (executeIntercepter != null) {
                    executeIntercepter.after(url, urlResponseHandler, triesCount, responseBody, e);
                }
            }
            finally {
                httpClient = null;
            }
        }
        HttpProxyRequestException httpProxyRequestException = null;
        if (httpResponseStatusException != null) {
            if (requestBody == null) {
                if (httpResponseStatusException instanceof HttpProxyRequestException) {
                    httpProxyRequestException = (HttpProxyRequestException)httpResponseStatusException;
                } else {
                    httpProxyRequestException = new HttpProxyRequestException("Send request Url:" + url, httpResponseStatusException);
                    httpProxyRequestException.setHttpResponseStatusException(httpResponseStatusException);
                }
            } else if (httpResponseStatusException instanceof HttpProxyRequestException) {
                httpProxyRequestException = new HttpProxyRequestException(requestBody.toString(), httpResponseStatusException);
            } else {
                httpProxyRequestException = new HttpProxyRequestException(requestBody.append("\r\nSend request Url:").append(url).toString(), httpResponseStatusException);
                httpProxyRequestException.setHttpResponseStatusException(httpResponseStatusException);
            }
            throw httpProxyRequestException;
        }
        if (e != null) {
            httpProxyRequestException = requestBody == null ? (e instanceof HttpProxyRequestException ? (HttpProxyRequestException)e : new HttpProxyRequestException("Send request Url:" + url, e)) : (e instanceof HttpProxyRequestException ? new HttpProxyRequestException(requestBody.toString(), e) : new HttpProxyRequestException(requestBody.append("\r\nSend request Url:").append(url).toString(), e));
            throw httpProxyRequestException;
        }
        return (T)responseBody;
    }

    private static HttpRequestBase getHttpEntityEnclosingRequestBase(String action, ClientConfiguration config, String url, Map headers) {
        if (action.equals("post")) {
            return HttpRequestUtil.getHttpPost(config, url, null, null, headers);
        }
        if (action.equals("get")) {
            return HttpRequestUtil.getHttpGet(config, url, null, null, headers);
        }
        if (action.equals("put")) {
            return HttpRequestUtil.getHttpPut(config, url, null, null, headers);
        }
        if (action.equals("delete")) {
            return HttpRequestUtil.getHttpDelete(config, url, null, null, headers);
        }
        if (action.equals("head")) {
            return HttpRequestUtil.getHttpHead(config, url, null, null, headers);
        }
        if (action.equals("trace")) {
            return HttpRequestUtil.getHttpTrace(config, url, null, null, headers);
        }
        if (action.equals("options")) {
            return HttpRequestUtil.getHttpOptions(config, url, null, null, headers);
        }
        if (action.equals("patch")) {
            return HttpRequestUtil.getHttpPatch(config, url, null, null, headers);
        }
        throw new IllegalArgumentException("not support http action:" + action);
    }

    private static HttpProxyRequestException handleSocketTimeoutException(String poolName, String url, ClientConfiguration configuration, SocketTimeoutException ex) {
        if (configuration == null) {
            StringBuilder builder = new StringBuilder();
            builder.append("Send request to url[").append(url).append("] socket Timeout with http pool[").append(poolName).append("].");
            return new HttpProxyRequestException(builder.toString(), ex);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Send request to url[").append(url).append("]  socket Timeout for ").append(configuration.getTimeoutSocket()).append("ms with http pool[").append(poolName).append("].");
        return new HttpProxyRequestException(builder.toString(), ex);
    }

    private static HttpProxyRequestException handleConnectionPoolTimeOutException(String poolName, String url, ClientConfiguration configuration, ConnectionPoolTimeoutException ex) {
        if (configuration == null) {
            StringBuilder builder = new StringBuilder();
            builder.append("Send request to url[").append(url).append("] Wait timeout for idle http connection from http connection pool[").append(poolName).append("].");
            return new HttpProxyRequestException(builder.toString(), ex);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Send request to url[").append(url).append("] Wait timeout for ").append(configuration.getConnectionRequestTimeout()).append("ms for idle http connection from http connection pool[").append(poolName).append("].");
        return new HttpProxyRequestException(builder.toString(), ex);
    }

    private static HttpProxyRequestException handleConnectionTimeOutException(String poolName, String url, ClientConfiguration configuration, ConnectTimeoutException ex) {
        if (configuration == null) {
            StringBuilder builder = new StringBuilder();
            builder.append("Send request to url[").append(url).append("] wait timeout for idle http connection from http connection pool[").append(poolName).append("].");
            return new HttpProxyRequestException(builder.toString(), ex);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Send request to url[").append(url).append("] wait timeout  for ").append(configuration.getTimeoutConnection()).append("ms from http connection pool[").append(poolName).append("].");
        return new HttpProxyRequestException(builder.toString(), ex);
    }

    public static <T> T sendBody(String poolname, String requestBody, String url, final Map headers, ContentType contentType, ResponseHandler<T> responseHandler, final String action) throws HttpProxyRequestException {
        StringEntity httpEntity = requestBody != null ? new StringEntity(requestBody, contentType) : null;
        HttpRequestProxy.injectBody(responseHandler, requestBody);
        return HttpRequestProxy._handleRequest(poolname, url, responseHandler, new ExecuteRequest(){
            final /* synthetic */ HttpEntity val$httpEntity;
            final /* synthetic */ ResponseHandler val$responseHandler;
            {
                this.val$httpEntity = httpEntity;
                this.val$responseHandler = responseHandler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object execute(ClientConfiguration config, HttpClient httpClient, String url, int triesCount) throws Exception {
                HttpEntityEnclosingRequestBase httpPost = null;
                try {
                    httpPost = (HttpEntityEnclosingRequestBase)HttpRequestProxy.getHttpEntityEnclosingRequestBase(action, config, url, headers);
                    if (this.val$httpEntity != null) {
                        httpPost.setEntity(this.val$httpEntity);
                    }
                    Object object = httpClient.execute((HttpUriRequest)httpPost, this.val$responseHandler);
                    return object;
                }
                finally {
                    if (httpPost != null) {
                        httpPost.releaseConnection();
                    }
                }
            }
        });
    }

    public static String sendBody(String poolname, String requestBody, String url, Map headers, ContentType contentType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody(poolname, requestBody, url, headers, contentType, new BaseURLResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleStringResponse(this.url, response);
            }
        });
    }

    public static String sendBody(String poolname, String requestBody, String url, final InvokeContext invokeContext) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody(poolname, requestBody, url, invokeContext, new BaseURLResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleStringResponse(this.url, response, invokeContext);
            }
        });
    }

    public static <T> T sendBody(String poolname, String requestBody, String url, InvokeContext invokeContext, final Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody(poolname, requestBody, url, invokeContext, new BaseURLResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleResponse(this.url, response, resultType);
            }
        });
    }

    public static <T> T sendBody(String poolname, String requestBody, String url, Map headers, ContentType contentType, final Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.sendBody(poolname, requestBody, url, headers, contentType, new BaseURLResponseHandler<T>(){

            public T handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleResponse(this.url, response, resultType);
            }
        });
    }

    public static <D, T> D sendBody(String poolname, String requestBody, String url, Map headers, ContentType contentType, final Class<D> containType, final Class<T> resultType) throws HttpProxyRequestException {
        return (D)HttpRequestProxy.sendBody(poolname, requestBody, url, headers, contentType, new BaseURLResponseHandler<D>(){

            public D handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleResponse(this.url, response, containType, resultType);
            }
        });
    }

    public static <D, T> D httpPostForTypeObject(String url, Object params, Class<D> containType, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostForTypeObject("default", url, params, null, containType, resultType);
    }

    public static <D, T> D httpPostForTypeObject(String poolName, String url, Object params, Class<D> containType, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostForTypeObject(poolName, url, params, null, containType, resultType);
    }

    public static <D, T> D httpPostForTypeObjectWithHeader(String url, Object params, Map header, Class<D> containType, Class<T> resultType) throws HttpProxyRequestException {
        return HttpRequestProxy.httpPostForTypeObject("default", url, params, header, containType, resultType);
    }

    public static <D, T> D httpPostForTypeObject(String poolName, String url, Object params, Map headers, final Class<D> containType, final Class<T> resultType) throws HttpProxyRequestException {
        HttpOption httpOption = new HttpOption();
        httpOption.params = params;
        httpOption.headers = headers;
        return (D)HttpRequestProxy.httpPost(poolName, url, httpOption, new BaseURLResponseHandler<D>(){

            public D handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleResponse(this.url, response, containType, resultType);
            }
        });
    }

    public static <T> List<T> sendBodyForList(String poolname, String requestBody, String url, Map headers, ContentType contentType, final Class<T> resultType) throws HttpProxyRequestException {
        return (List)HttpRequestProxy.sendBody(poolname, requestBody, url, headers, contentType, new BaseURLResponseHandler<List<T>>(){

            public List<T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleListResponse(this.url, response, resultType);
            }
        });
    }

    public static <D, T> D sendBodyForTypeObject(String poolname, String url, String requestBody, Map headers, ContentType contentType, final Class<D> containerType, final Class<T> resultType) throws HttpProxyRequestException {
        return (D)HttpRequestProxy.sendBody(poolname, requestBody, url, headers, contentType, new BaseURLResponseHandler<D>(){

            public D handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleResponse(this.url, response, containerType, resultType);
            }
        });
    }

    public static <T> Set<T> sendBodyForSet(String poolname, String requestBody, String url, Map headers, ContentType contentType, final Class<T> resultType) throws HttpProxyRequestException {
        return (Set)HttpRequestProxy.sendBody(poolname, requestBody, url, headers, contentType, new BaseURLResponseHandler<Set<T>>(){

            public Set<T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleSetResponse(this.url, response, resultType);
            }
        });
    }

    public static <K, T> Map<K, T> sendBodyForMap(String poolname, String requestBody, String url, Map headers, ContentType contentType, final Class<K> keyType, final Class<T> resultType) throws HttpProxyRequestException {
        return (Map)HttpRequestProxy.sendBody(poolname, requestBody, url, headers, contentType, new BaseURLResponseHandler<Map<K, T>>(){

            public Map<K, T> handleResponse(HttpResponse response) throws IOException {
                return ResponseUtil.handleMapResponse(this.url, response, keyType, resultType);
            }
        });
    }

    private static void assertCheck(HttpServiceHosts httpServiceHosts, String endpoint, String poolName) {
        if (httpServiceHosts == null) {
            StringBuilder error = new StringBuilder();
            error.append("RequestInfo[").append(endpoint).append("], poolName [").append(poolName).append("], HttpServiceHosts is null,Http Request Proxy is not properly initialized, please refer to the document: https://esdoc.bbossgroups.com/#/httpproxy?id=_32-http\u8d1f\u8f7d\u5747\u8861\u5668\u914d\u7f6e\u548c\u542f\u52a8");
            String msg = error.toString();
            if (logger.isWarnEnabled()) {
                logger.warn(msg);
            }
            throw new HttpProxyRequestException(msg);
        }
    }

    public static <T> T putBody(String poolname, String requestBody, String url, final Map headers, ContentType contentType, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        StringEntity httpEntity = new StringEntity(requestBody, contentType);
        HttpRequestProxy.injectBody(responseHandler, requestBody);
        return HttpRequestProxy._handleRequest(poolname, url, responseHandler, new ExecuteRequest(){
            final /* synthetic */ HttpEntity val$httpEntity;
            final /* synthetic */ ResponseHandler val$responseHandler;
            {
                this.val$httpEntity = httpEntity;
                this.val$responseHandler = responseHandler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object execute(ClientConfiguration config, HttpClient httpClient, String url, int triesCount) throws Exception {
                HttpPut httpPost = null;
                try {
                    httpPost = HttpRequestUtil.getHttpPut(config, url, "", "", headers);
                    httpPost.setEntity(this.val$httpEntity);
                    Object object = httpClient.execute((HttpUriRequest)httpPost, this.val$responseHandler);
                    return object;
                }
                finally {
                    if (httpPost != null) {
                        httpPost.releaseConnection();
                    }
                }
            }
        });
    }

    public static String putBody(String poolname, String requestBody, String url, Map headers, ContentType contentType) throws HttpProxyRequestException {
        return HttpRequestProxy.putBody(poolname, requestBody, url, headers, contentType, new BaseURLResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws IOException {
                int status = response.getStatusLine().getStatusCode();
                if (ResponseUtil.isHttpStatusOK(status)) {
                    HttpEntity entity = response.getEntity();
                    return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                }
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("PUT Request url:" + this.url + ",status:" + status);
                    }
                    throw new HttpProxyRequestException("Request url:" + this.url + ",error:" + EntityUtils.toString((HttpEntity)entity));
                }
                throw new HttpProxyRequestException("Put request url:" + this.url + ",Unexpected response status: " + status);
            }
        });
    }

    public static <T> T putBody(String requestBody, String url, Map headers, ContentType contentType, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.putBody("default", requestBody, url, headers, contentType, responseHandler);
    }

    public static String putBody(String requestBody, String url, Map headers, ContentType contentType) throws HttpProxyRequestException {
        return HttpRequestProxy.putBody("default", requestBody, url, headers, contentType);
    }

    public static <T> T putJson(String requestBody, String url, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.putBody("default", requestBody, url, headers, ContentType.APPLICATION_JSON, responseHandler);
    }

    public static <T> T putJson(String poolName, String requestBody, String url, Map headers, ResponseHandler<T> responseHandler) throws HttpProxyRequestException {
        return HttpRequestProxy.putBody(poolName, requestBody, url, headers, ContentType.APPLICATION_JSON, responseHandler);
    }

    public static String putJson(String requestBody, String url, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.putBody("default", requestBody, url, headers, ContentType.APPLICATION_JSON);
    }

    public static String putJson(String poolName, String requestBody, String url, Map headers) throws HttpProxyRequestException {
        return HttpRequestProxy.putBody(poolName, requestBody, url, headers, ContentType.APPLICATION_JSON);
    }

    public static String putJson(String poolName, String requestBody, String url) throws HttpProxyRequestException {
        return HttpRequestProxy.putBody(poolName, requestBody, url, (Map)null, ContentType.APPLICATION_JSON);
    }

    public static interface ExecuteRequest {
        public Object execute(ClientConfiguration var1, HttpClient var2, String var3, int var4) throws Exception;
    }

    public static class HttpOption {
        public String cookie;
        public String userAgent;
        public Object params;
        public Map<String, File> files;
        public Map headers;
        public DataSerialType dataSerialType = DataSerialType.TEXT;
    }
}

