/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http;

import java.io.IOException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;
import org.frameworkset.spi.remote.http.ClientConfiguration;
import org.frameworkset.spi.remote.http.CustomHttpRequestRetryHandler;
import org.frameworkset.spi.remote.http.DefaultHttpRequestRetryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestRetryHandlerHelper
implements HttpRequestRetryHandler {
    private static Logger logger = LoggerFactory.getLogger(DefaultHttpRequestRetryHandler.class);
    private CustomHttpRequestRetryHandler httpRequestRetryHandler;
    private HttpRequestRetryHandler defaultHttpRequestRetryHandler;
    private ClientConfiguration configuration;
    private int retryTime;

    public HttpRequestRetryHandlerHelper(CustomHttpRequestRetryHandler httpRequestRetryHandler, ClientConfiguration configuration) {
        if (httpRequestRetryHandler != null) {
            this.retryTime = configuration.getRetryTime() > 0 ? configuration.getRetryTime() : 3;
            this.httpRequestRetryHandler = httpRequestRetryHandler;
        } else {
            this.defaultHttpRequestRetryHandler = configuration.getRetryTime() > 0 ? new org.apache.http.impl.client.DefaultHttpRequestRetryHandler(configuration.getRetryTime(), false) : org.apache.http.impl.client.DefaultHttpRequestRetryHandler.INSTANCE;
        }
        this.configuration = configuration;
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        if (this.httpRequestRetryHandler != null) {
            if (executionCount > this.retryTime) {
                return false;
            }
            if (this.httpRequestRetryHandler.retryRequest(exception, executionCount, context, this.configuration)) {
                if (this.configuration.getRetryInterval() > 0L) {
                    try {
                        Thread.sleep(this.configuration.getRetryInterval());
                    }
                    catch (InterruptedException e1) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        if (this.defaultHttpRequestRetryHandler.retryRequest(exception, executionCount, context)) {
            if (this.configuration.getRetryInterval() > 0L) {
                try {
                    Thread.sleep(this.configuration.getRetryInterval());
                }
                catch (InterruptedException e1) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

