/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.frameworkset.spi.remote.http.URLResponseHandler;
import org.frameworkset.spi.remote.http.callback.ExecuteIntercepter;
import org.frameworkset.spi.remote.http.proxy.HttpProxyRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StatusResponseHandler<T>
implements URLResponseHandler<T> {
    private static Logger _logger = LoggerFactory.getLogger(StatusResponseHandler.class);
    protected int reponseStatus;
    protected String url;
    private ExecuteIntercepter executeIntercepter;

    public int getReponseStatus() {
        return this.reponseStatus;
    }

    public void setReponseStatus(int reponseStatus) {
        this.reponseStatus = reponseStatus;
    }

    protected int initStatus(HttpResponse response) {
        this.reponseStatus = response.getStatusLine().getStatusCode();
        return this.reponseStatus;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public ExecuteIntercepter getExecuteIntercepter() {
        return this.executeIntercepter;
    }

    @Override
    public void setExecuteIntercepter(ExecuteIntercepter executeIntercepter) {
        this.executeIntercepter = executeIntercepter;
    }

    protected RuntimeException throwException(int status, HttpEntity entity) throws IOException {
        if (entity != null) {
            if (_logger.isErrorEnabled()) {
                _logger.error("Request url:" + this.url + ",status:" + status);
            }
            return new HttpProxyRequestException(EntityUtils.toString((HttpEntity)entity));
        }
        return new HttpProxyRequestException("Request url:" + this.url + ",Unexpected response status: " + status);
    }
}

