/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http.kerberos;

import com.frameworkset.util.SimpleStringUtil;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.frameworkset.spi.remote.http.ClientConfiguration;
import org.frameworkset.spi.remote.http.callback.HttpClientBuilderCallback;
import org.frameworkset.spi.remote.http.kerberos.KerberosCallException;
import org.frameworkset.spi.remote.http.kerberos.KerberosCallback;
import org.frameworkset.spi.remote.http.kerberos.KerberosConfig;

public abstract class BaseRequestKerberosUrlUtils
implements HttpClientBuilderCallback {
    protected KerberosConfig kerberosConfig;
    protected Configuration configuration;
    protected ClientConfiguration clientConfiguration;

    public BaseRequestKerberosUrlUtils(KerberosConfig kerberosConfig, ClientConfiguration clientConfiguration) {
        this.kerberosConfig = kerberosConfig;
        this.clientConfiguration = clientConfiguration;
        System.setProperty("java.security.krb5.conf", kerberosConfig.getKrb5Location());
        if (SimpleStringUtil.isNotEmpty((String)kerberosConfig.getUseSubjectCredsOnly())) {
            System.setProperty("javax.security.auth.useSubjectCredsOnly", kerberosConfig.getUseSubjectCredsOnly());
        }
        if (kerberosConfig.getDebug() != null && kerberosConfig.getDebug().equals("true")) {
            System.setProperty("sun.security.spnego.debug", "true");
            System.setProperty("sun.security.krb5.debug", "true");
        }
    }

    @Override
    public HttpClientBuilder customizeHttpClient(HttpClientBuilder builder, ClientConfiguration clientConfiguration) throws Exception {
        return builder;
    }

    public void buildSpengoHttpClient(HttpClientBuilder builder) {
        Registry authSchemeRegistry = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory(true)).build();
        builder.setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(null, -1, null), new Credentials(){

            public Principal getUserPrincipal() {
                return null;
            }

            public String getPassword() {
                return null;
            }
        });
        builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
    }

    protected String getLoginContextName() {
        String name = this.kerberosConfig.getLoginContextName();
        if (name == null || name.equals("")) {
            name = "Krb5Login";
        }
        return name;
    }

    protected abstract Subject getSubject() throws LoginException;

    public <T> T callRestUrl(final KerberosCallback<T> kerberosCallback) throws Exception {
        try {
            Subject serviceSubject = this.getSubject();
            return Subject.doAs(serviceSubject, new PrivilegedAction<T>(){

                @Override
                public T run() {
                    try {
                        return kerberosCallback.call();
                    }
                    catch (Exception e) {
                        throw new KerberosCallException(e);
                    }
                }
            });
        }
        catch (KerberosCallException le) {
            throw (Exception)le.getCause();
        }
        catch (Exception le) {
            throw le;
        }
    }

    public void afterStart() {
    }

    public void close() {
    }
}

