/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http.kerberos;

import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.frameworkset.spi.remote.http.ClientConfiguration;
import org.frameworkset.spi.remote.http.kerberos.BaseRequestKerberosUrlUtils;
import org.frameworkset.spi.remote.http.kerberos.KerberosConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestKerberosUrlUtilsJaasLoginConfig
extends BaseRequestKerberosUrlUtils {
    private static Logger logger = LoggerFactory.getLogger(RequestKerberosUrlUtilsJaasLoginConfig.class);

    public RequestKerberosUrlUtilsJaasLoginConfig(KerberosConfig kerberosConfig, ClientConfiguration clientConfiguration) {
        super(kerberosConfig, clientConfiguration);
        System.setProperty("java.security.auth.login.config", kerberosConfig.getLoginConfig());
    }

    @Override
    public void buildSpengoHttpClient(HttpClientBuilder builder) {
        Registry authSchemeRegistry = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory(true)).build();
        builder.setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(null, -1, null), new Credentials(){

            public Principal getUserPrincipal() {
                return null;
            }

            public String getPassword() {
                return null;
            }
        });
        builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
    }

    @Override
    protected Subject getSubject() throws LoginException {
        String property = System.getProperty("java.security.auth.login.config");
        if (null != property) {
            LoginContext lc = new LoginContext(this.getLoginContextName(), null, null, this.configuration);
            lc.login();
            return lc.getSubject();
        }
        return new Subject();
    }
}

