/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http.kerberos;

import java.util.HashSet;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.frameworkset.spi.remote.http.ClientConfiguration;
import org.frameworkset.spi.remote.http.kerberos.BaseRequestKerberosUrlUtils;
import org.frameworkset.spi.remote.http.kerberos.KerberosConfig;
import org.frameworkset.spi.remote.http.kerberos.KerberosHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestKerberosUrlUtilsParams
extends BaseRequestKerberosUrlUtils {
    public static Logger logger = LoggerFactory.getLogger(RequestKerberosUrlUtilsParams.class);

    public RequestKerberosUrlUtilsParams(final KerberosConfig kerberosConfig, ClientConfiguration clientConfiguration) {
        super(kerberosConfig, clientConfiguration);
        this.configuration = new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                return KerberosHelper.getAppConfigurationEntry(kerberosConfig);
            }
        };
    }

    @Override
    protected Subject getSubject() throws LoginException {
        HashSet<KerberosPrincipal> princ = new HashSet<KerberosPrincipal>(1);
        princ.add(new KerberosPrincipal(this.kerberosConfig.getPrincipal()));
        Subject sub = new Subject(false, princ, new HashSet(), new HashSet());
        LoginContext lc = new LoginContext(this.getLoginContextName(), sub, null, this.configuration);
        lc.login();
        Subject serviceSubject = lc.getSubject();
        return serviceSubject;
    }
}

