/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.spi.remote.http.proxy;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.frameworkset.spi.remote.http.proxy.HttpAddress;
import org.frameworkset.spi.remote.http.proxy.HttpServiceHosts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinList {
    private static Logger logger = LoggerFactory.getLogger(RoundRobinList.class);
    private final List<HttpAddress> elements;
    private Iterator<HttpAddress> iterator;
    private HttpServiceHosts httpServiceHosts;
    private Lock lock = new ReentrantLock();

    public RoundRobinList(HttpServiceHosts httpServiceHosts, List<HttpAddress> elements) {
        this.elements = elements;
        this.iterator = this.elements.iterator();
        this.httpServiceHosts = httpServiceHosts;
    }

    public void addAddresses(List<HttpAddress> address) {
        this.lock.lock();
        try {
            this.elements.addAll(address);
            this.iterator = this.elements.iterator();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpAddress get() {
        this.lock.lock();
        try {
            HttpAddress address2 = null;
            HttpAddress temp = null;
            while (this.iterator.hasNext()) {
                address2 = this.iterator.next();
                if (!address2.ok()) continue;
                temp = address2;
                break;
            }
            if (temp != null) {
                HttpAddress httpAddress = temp;
                return httpAddress;
            }
            for (HttpAddress address2 : this.elements) {
                if (!address2.ok()) continue;
                temp = address2;
                break;
            }
            HttpAddress httpAddress = temp;
            return httpAddress;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        if (this.elements != null) {
            return this.elements.toString();
        }
        return "[]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpAddress getOkOrFailed() {
        this.lock.lock();
        try {
            HttpAddress address2 = null;
            HttpAddress temp = null;
            while (this.iterator.hasNext()) {
                address2 = this.iterator.next();
                if (!address2.okOrFailed()) continue;
                temp = address2;
                break;
            }
            if (temp != null) {
                HttpAddress httpAddress = temp;
                return httpAddress;
            }
            for (HttpAddress address2 : this.elements) {
                if (!address2.okOrFailed()) continue;
                temp = address2;
                break;
            }
            HttpAddress httpAddress = temp;
            return httpAddress;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpAddress getOkOrFailedFromRouting() {
        this.lock.lock();
        try {
            HttpAddress address2 = null;
            HttpAddress temp = null;
            while (this.iterator.hasNext()) {
                address2 = this.iterator.next();
                if (!address2.okOrFailed()) continue;
                temp = address2;
                break;
            }
            if (temp != null) {
                HttpAddress httpAddress = temp;
                return httpAddress;
            }
            for (HttpAddress address2 : this.elements) {
                if (!address2.okOrFailed()) continue;
                temp = address2;
                break;
            }
            if (temp == null && logger.isDebugEnabled()) {
                String message = "All Http Server " + this.elements.toString() + " can't been connected.";
                logger.debug(message);
            }
            HttpAddress httpAddress = temp;
            return httpAddress;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpAddress getFromRouting() {
        this.lock.lock();
        try {
            HttpAddress address2 = null;
            HttpAddress temp = null;
            while (this.iterator.hasNext()) {
                address2 = this.iterator.next();
                if (!address2.ok()) continue;
                temp = address2;
                break;
            }
            if (temp != null) {
                HttpAddress httpAddress = temp;
                return httpAddress;
            }
            for (HttpAddress address2 : this.elements) {
                if (!address2.ok()) continue;
                temp = address2;
                break;
            }
            if (temp == null && logger.isDebugEnabled()) {
                String message = "All Http Server " + this.elements.toString() + " can't been connected.";
                logger.debug(message);
            }
            HttpAddress httpAddress = temp;
            return httpAddress;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        this.lock.lock();
        try {
            int n = this.elements.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }
}

