/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman;

import com.frameworkset.common.poolman.BatchHandler;
import com.frameworkset.common.poolman.GetCUDResult;
import com.frameworkset.common.poolman.ListSQLParams;
import com.frameworkset.common.poolman.PreparedDBUtil;
import com.frameworkset.common.poolman.SQLInfoExecutor;
import com.frameworkset.common.poolman.SQLParams;
import com.frameworkset.common.poolman.SetSQLParamException;
import com.frameworkset.common.poolman.handle.FieldRowHandler;
import com.frameworkset.common.poolman.handle.NullRowHandler;
import com.frameworkset.common.poolman.handle.RowHandler;
import com.frameworkset.common.poolman.util.DBOptions;
import com.frameworkset.util.ListInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.frameworkset.persitent.util.SQLInfo;
import org.frameworkset.persitent.util.SQLUtil;

public class DBOPtionsSQLExecutor {
    protected String statement;
    protected String action;
    public static final String ACTION_INSERT = "insert";
    public static final String ACTION_UPDATE = "update";
    public static final String ACTION_DELETE = "delete";
    public static final String BATCH_COMMON = "common";
    public static final String BATCH_PREPARED = "prepared";
    private List<SQLParams> batchsqlparams;
    private List<String> batchsqls;
    private String batchtype = "common";
    protected SQLParams sqlparams;
    private String batchDBName;
    private boolean batchOptimize = false;

    public SQLParams getSQLParams() throws SetSQLParamException {
        if (this.sqlparams != null && (this.getPretoken() == null && this.getEndtoken() != null || this.getPretoken() != null && this.getEndtoken() == null)) {
            throw new SetSQLParamException("\u975e\u6cd5\u7684\u7ed1\u5b9a\u53d8\u91cf\u5206\u5272\u7b26\u8bbe\u7f6e:pretoken = " + this.getPretoken() + "endtoken =" + this.getEndtoken());
        }
        return this.sqlparams;
    }

    public void addSQLParam(String name, String value, String type) throws SetSQLParamException {
        this.addSQLParam(name, value, type, null);
    }

    private void init() {
        if (this.sqlparams == null) {
            this.sqlparams = new SQLParams();
        }
    }

    public void addSQLParam(String name, Object value, String type, String dataformat) throws SetSQLParamException {
        this.init();
        DBOPtionsSQLExecutor.addSQLParam(this.sqlparams, name, value, type, dataformat);
    }

    public void addSQLParam(String name, Object value, String type, String dataformat, String charset) throws SetSQLParamException {
        this.init();
        DBOPtionsSQLExecutor.addSQLParam(this.sqlparams, name, value, type, dataformat, charset);
    }

    public static void addSQLParam(SQLParams sqlparams, String name, Object value, String type, String dataformat) throws SetSQLParamException {
        sqlparams.addSQLParam(name, value, type, dataformat);
    }

    public static void addSQLParam(SQLParams sqlparams, String name, Object value, String type, String dataformat, String charset) throws SetSQLParamException {
        sqlparams.addSQLParam(name, value, type, dataformat, charset);
    }

    public String getDbname() {
        this.init();
        return this.sqlparams.getDbname();
    }

    public void setDbname(String dbname) {
        this.init();
        this.sqlparams.setDbname(dbname);
    }

    public String getStatement() {
        return this.statement;
    }

    public void setStatement(String statement) {
        this.statement = statement;
    }

    public String getPretoken() {
        this.init();
        return this.sqlparams.getPretoken();
    }

    public void setPretoken(String pretoken) {
        this.init();
        this.sqlparams.setPretoken(pretoken);
    }

    public String getEndtoken() {
        this.init();
        return this.sqlparams.getEndtoken();
    }

    public void setEndtoken(String endtoken) {
        this.init();
        this.sqlparams.setEndtoken(endtoken);
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Object execute(DBOptions dbOptions) throws SQLException {
        if (this.batchsqlparams == null && this.batchsqls == null) {
            this.action = this.action.toLowerCase();
            PreparedDBUtil dbutil = new PreparedDBUtil();
            if (this.action.equals(ACTION_INSERT)) {
                if (this.getSQLParams().size() > 0) {
                    dbutil.preparedInsert(this.getSQLParams(), this.getDbname(), SQLUtil.getGlobalSQLUtil().getSQLInfo(this.getStatement(), true, true));
                } else {
                    dbutil.executeInsert(this.getDbname(), this.getStatement());
                }
            } else if (this.action.equals(ACTION_UPDATE)) {
                if (this.getSQLParams().size() > 0) {
                    dbutil.preparedUpdate(this.getSQLParams(), this.getDbname(), SQLUtil.getGlobalSQLUtil().getSQLInfo(this.getStatement(), true, true));
                } else {
                    dbutil.executeUpdate(this.getDbname(), this.getStatement());
                }
            } else if (this.action.equals(ACTION_DELETE)) {
                if (this.getSQLParams().size() > 0) {
                    dbutil.preparedDelete(this.getSQLParams(), this.getDbname(), SQLUtil.getGlobalSQLUtil().getSQLInfo(this.getStatement(), true, true));
                } else {
                    dbutil.executeDelete(this.getDbname(), this.getStatement());
                }
            } else {
                throw new SQLException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u64cd\u4f5c\uff1a" + this.action);
            }
            return dbutil.executePrepared(dbOptions);
        }
        if (this.batchtype.equals(BATCH_PREPARED)) {
            PreparedDBUtil dbutil = new PreparedDBUtil();
            dbutil.setBatchOptimize(this.isBatchOptimize());
            dbutil.setPrepareDBName(this.batchDBName);
            dbutil.addPreparedBatch(new ListSQLParams(this.batchsqlparams, null));
            dbutil.executePreparedBatch(dbOptions);
        } else {
            PreparedDBUtil dbutil = new PreparedDBUtil();
            dbutil.addBatch(this.batchsqls);
            dbutil.executeBatch(this.getBatchDBName());
        }
        return null;
    }

    public void addPreparedBatch() {
        if (this.batchsqlparams == null) {
            this.batchsqlparams = new ArrayList<SQLParams>();
        }
        this.batchsqlparams.add(this.sqlparams);
        SQLInfo old = this.sqlparams.getOldsql();
        String oldendtoken = this.sqlparams.getEndtoken();
        String oldpretoken = this.sqlparams.getPretoken();
        this.sqlparams = this.buildParams();
        this.sqlparams.setOldsql(old);
        this.sqlparams.setEndtoken(oldendtoken);
        this.sqlparams.setPretoken(oldpretoken);
    }

    public void addBatch(String statement) {
        if (this.batchsqls == null) {
            this.batchsqls = new ArrayList<String>();
        }
        this.batchsqls.add(statement);
    }

    private SQLParams buildParams() {
        return new SQLParams();
    }

    public String getBatchDBName() {
        return this.batchDBName;
    }

    public void setBatchDBName(String batchDBName) {
        this.batchDBName = batchDBName;
    }

    public boolean isBatchOptimize() {
        return this.batchOptimize;
    }

    public void setBatchOptimize(boolean batchOptimize) {
        this.batchOptimize = batchOptimize;
    }

    public void init(String statement, String pretoken, String endtoken, String action) {
        this.sqlparams = new SQLParams();
        SQLInfoExecutor.init(this.sqlparams, SQLUtil.getGlobalSQLUtil().getSQLInfo(statement, true, true), pretoken, endtoken, action);
    }

    public String getBatchtype() {
        return this.batchtype;
    }

    public void setBatchtype(String batchtype) {
        this.batchtype = batchtype;
    }

    public static void insertBeans(DBOptions dbOptions, String dbname, String sql, List beans) throws SQLException {
        if (beans == null || beans.size() == 0) {
            return;
        }
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, true);
        SQLInfoExecutor.insertBeans(dbOptions, dbname, sqlinfo, beans);
    }

    public static void insertBeans(DBOptions dbOptions, String dbname, String sql, List beans, GetCUDResult getCUDResult) throws SQLException {
        if (beans == null || beans.size() == 0) {
            return;
        }
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, true);
        SQLInfoExecutor.insertBeans(dbOptions, dbname, sqlinfo, beans, getCUDResult);
    }

    public static Object update(DBOptions dbOptions, String sql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        return SQLInfoExecutor.update(dbOptions, sqlinfo, fields);
    }

    public static Object delete(DBOptions dbOptions, String sql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        return SQLInfoExecutor.delete(dbOptions, sqlinfo, fields);
    }

    public static void deleteByKeys(DBOptions dbOptions, String sql, int ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        SQLInfoExecutor.deleteByKeys(dbOptions, sqlinfo, fields);
    }

    public static void deleteByKeysWithDBName(DBOptions dbOptions, String dbname, String sql, int ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        SQLInfoExecutor.deleteByKeysWithDBName(dbOptions, dbname, sqlinfo, fields);
    }

    public static void deleteByLongKeys(DBOptions dbOptions, String sql, long ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        SQLInfoExecutor.deleteByLongKeys(dbOptions, sqlinfo, fields);
    }

    public static void deleteByLongKeysWithDBName(DBOptions dbOptions, String dbname, String sql, long ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        SQLInfoExecutor.deleteByLongKeysWithDBName(dbOptions, dbname, sqlinfo, fields);
    }

    public static <T> void executeBatch(DBOptions dbOptions, String sql, List<T> datas, int batchsize, BatchHandler<T> batchHandler) throws SQLException {
        DBOPtionsSQLExecutor.executeBatch(dbOptions, null, sql, datas, batchsize, batchHandler);
    }

    public static <T> void executeBatch(DBOptions dbOptions, String dbname, String sql, List<T> datas, int batchsize, BatchHandler<T> batchHandler) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        SQLInfoExecutor.executeBatch(dbOptions, dbname, sqlinfo, datas, batchsize, batchHandler);
    }

    public static void updateByKeys(DBOptions dbOptions, String sql, int ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        SQLInfoExecutor.updateByKeys(dbOptions, sqlinfo, fields);
    }

    public static void updateByKeysWithDBName(DBOptions dbOptions, String dbname, String sql, int ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        SQLInfoExecutor.updateByKeysWithDBName(dbOptions, dbname, sqlinfo, fields);
    }

    public static void updateByLongKeys(DBOptions dbOptions, String sql, long ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        SQLInfoExecutor.updateByLongKeys(dbOptions, sqlinfo, fields);
    }

    public static void updateByLongKeysWithDBName(DBOptions dbOptions, String dbname, String sql, long ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        SQLInfoExecutor.updateByLongKeysWithDBName(dbOptions, dbname, sqlinfo, fields);
    }

    public static void updateByKeys(DBOptions dbOptions, String sql, String ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        SQLInfoExecutor.updateByKeys(dbOptions, sqlinfo, fields);
    }

    public static void updateByKeysWithDBName(DBOptions dbOptions, String dbname, String sql, String ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        SQLInfoExecutor.updateByKeysWithDBName(dbOptions, dbname, sqlinfo, fields);
    }

    public static void deleteByKeys(DBOptions dbOptions, String sql, String ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        SQLInfoExecutor.deleteByKeys(dbOptions, sqlinfo, fields);
    }

    public static void deleteByKeysWithDBName(DBOptions dbOptions, String dbname, String sql, String ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        SQLInfoExecutor.deleteByKeysWithDBName(dbOptions, dbname, sqlinfo, fields);
    }

    public static void deleteByShortKeys(DBOptions dbOptions, String sql, short ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        SQLInfoExecutor.deleteByShortKeys(dbOptions, sqlinfo, fields);
    }

    public static void deleteByShortKeysWithDBName(DBOptions dbOptions, String dbname, String sql, short ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        SQLInfoExecutor.deleteByShortKeysWithDBName(dbOptions, dbname, sqlinfo, fields);
    }

    public static void updateByShortKeys(DBOptions dbOptions, String sql, short ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        SQLInfoExecutor.updateByShortKeys(dbOptions, sqlinfo, fields);
    }

    public static void updateByShortKeysWithDBName(DBOptions dbOptions, String dbname, String sql, short ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        SQLInfoExecutor.updateByShortKeysWithDBName(dbOptions, dbname, sqlinfo, fields);
    }

    public static Object insert(DBOptions dbOptions, String sql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        return SQLInfoExecutor.insert(dbOptions, sqlinfo, fields);
    }

    public static Object updateWithDBName(DBOptions dbOptions, String dbname, String sql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        return SQLInfoExecutor.updateWithDBName(dbOptions, dbname, sqlinfo, fields);
    }

    public static Object deleteWithDBName(DBOptions dbOptions, String dbname, String sql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        return SQLInfoExecutor.deleteWithDBName(dbOptions, dbname, sqlinfo, fields);
    }

    public static Object insertWithDBName(DBOptions dbOptions, String dbname, String sql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        return SQLInfoExecutor.insertWithDBName(dbOptions, dbname, sqlinfo, fields);
    }

    public static void updateBeans(DBOptions dbOptions, String dbname, String sql, List beans) throws SQLException {
        if (beans == null || beans.size() == 0) {
            return;
        }
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, true);
        SQLInfoExecutor.updateBeans(dbOptions, dbname, sqlinfo, beans);
    }

    public static void updateBeans(DBOptions dbOptions, String dbname, String sql, List beans, GetCUDResult GetCUDResult2) throws SQLException {
        if (beans == null || beans.size() == 0) {
            return;
        }
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, true);
        SQLInfoExecutor.updateBeans(dbOptions, dbname, sqlinfo, beans, GetCUDResult2);
    }

    public static void deleteBeans(DBOptions dbOptions, String dbname, String sql, List beans) throws SQLException {
        if (beans == null || beans.size() == 0) {
            return;
        }
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, true);
        SQLInfoExecutor.deleteBeans(dbOptions, dbname, sqlinfo, beans);
    }

    public static void deleteBeans(DBOptions dbOptions, String dbname, String sql, List beans, GetCUDResult GetCUDResult2) throws SQLException {
        if (beans == null || beans.size() == 0) {
            return;
        }
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, true);
        SQLInfoExecutor.deleteBeans(dbOptions, dbname, sqlinfo, beans, GetCUDResult2);
    }

    public static void insertBean(DBOptions dbOptions, String dbname, String sql, Object bean) throws SQLException {
        if (bean == null) {
            return;
        }
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        SQLInfoExecutor.insertBean(dbOptions, dbname, sqlinfo, bean);
    }

    public static void insertBean(DBOptions dbOptions, String dbname, String sql, Object bean, GetCUDResult getCUDResult) throws SQLException {
        if (bean == null) {
            return;
        }
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        SQLInfoExecutor.insertBean(dbOptions, dbname, sqlinfo, bean, getCUDResult);
    }

    public static void updateBean(DBOptions dbOptions, String dbname, String sql, Object bean) throws SQLException {
        if (bean == null) {
            return;
        }
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        SQLInfoExecutor.updateBean(dbOptions, dbname, sqlinfo, bean);
    }

    public static void updateBean(DBOptions dbOptions, String dbname, String sql, Object bean, GetCUDResult getCUDResult) throws SQLException {
        if (bean == null) {
            return;
        }
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        SQLInfoExecutor.updateBean(dbOptions, dbname, sqlinfo, bean, getCUDResult);
    }

    public static void updateBean(DBOptions dbOptions, String sql, Object bean, GetCUDResult getCUDResult) throws SQLException {
        DBOPtionsSQLExecutor.updateBean(dbOptions, null, sql, bean, getCUDResult);
    }

    public static void deleteBean(DBOptions dbOptions, String sql, Object bean, GetCUDResult getCUDResult) throws SQLException {
        DBOPtionsSQLExecutor.deleteBean(dbOptions, null, sql, bean, getCUDResult);
    }

    public static void deleteBean(DBOptions dbOptions, String dbname, String sql, Object bean) throws SQLException {
        if (bean == null) {
            return;
        }
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        SQLInfoExecutor.deleteBean(dbOptions, dbname, sqlinfo, bean);
    }

    public static void deleteBean(DBOptions dbOptions, String dbname, String sql, Object bean, GetCUDResult getCUDResult) throws SQLException {
        if (bean == null) {
            return;
        }
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        SQLInfoExecutor.deleteBean(dbOptions, dbname, sqlinfo, bean, getCUDResult);
    }

    public static void insertBeans(DBOptions dbOptions, String sql, List beans) throws SQLException {
        DBOPtionsSQLExecutor.insertBeans(dbOptions, (String)null, sql, beans);
    }

    public static void insertBeans(DBOptions dbOptions, String sql, List beans, GetCUDResult getCUDResult) throws SQLException {
        DBOPtionsSQLExecutor.insertBeans(dbOptions, null, sql, beans, getCUDResult);
    }

    public static void updateBeans(DBOptions dbOptions, String sql, List beans) throws SQLException {
        DBOPtionsSQLExecutor.updateBeans(dbOptions, null, sql, beans);
    }

    public static void deleteBeans(DBOptions dbOptions, String sql, List beans) throws SQLException {
        DBOPtionsSQLExecutor.deleteBeans(dbOptions, null, sql, beans);
    }

    public static void insertBean(DBOptions dbOptions, String sql, Object bean) throws SQLException {
        DBOPtionsSQLExecutor.insertBean(dbOptions, (String)null, sql, bean);
    }

    public static void insertBean(DBOptions dbOptions, String sql, Object bean, GetCUDResult getCUDResult) throws SQLException {
        DBOPtionsSQLExecutor.insertBean(dbOptions, null, sql, bean, getCUDResult);
    }

    public static void updateBean(DBOptions dbOptions, String sql, Object bean) throws SQLException {
        DBOPtionsSQLExecutor.updateBean(dbOptions, (String)null, sql, bean);
    }

    public static void deleteBean(DBOptions dbOptions, String sql, Object bean) throws SQLException {
        DBOPtionsSQLExecutor.deleteBean(dbOptions, (String)null, sql, bean);
    }

    public static <T> List<T> queryList(DBOptions dbOptions, Class<T> beanType, String sql, Object ... fields) throws SQLException {
        return DBOPtionsSQLExecutor.queryListWithDBName(dbOptions, beanType, null, sql, fields);
    }

    public static ListInfo queryListInfoWithDBName(DBOptions dbOptions, Class<?> beanType, String dbname, String sql, long offset, int pagesize, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        return SQLInfoExecutor.queryListInfoWithDBName(dbOptions, beanType, dbname, sqlinfo, offset, pagesize, fields);
    }

    public static ListInfo queryListInfoWithDBName2ndTotalsize(DBOptions dbOptions, Class<?> beanType, String dbname, String sql, long offset, int pagesize, long totalsize, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        return SQLInfoExecutor.queryListInfoWithDBName2ndTotalsize(dbOptions, beanType, dbname, sqlinfo, offset, pagesize, totalsize, fields);
    }

    public static ListInfo queryListInfoWithDBName2ndTotalsizesql(DBOptions dbOptions, Class<?> beanType, String dbname, String sql, long offset, int pagesize, String totalsizesql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        SQLInfo totalsizesqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(totalsizesql);
        return SQLInfoExecutor.queryListInfoWithDBName2ndTotalsizesql(dbOptions, beanType, dbname, sqlinfo, offset, pagesize, totalsizesqlinfo, fields);
    }

    public static ListInfo queryListInfo(DBOptions dbOptions, Class<?> beanType, String sql, long offset, int pagesize, Object ... fields) throws SQLException {
        return DBOPtionsSQLExecutor.queryListInfoWithDBName(dbOptions, beanType, null, sql, offset, pagesize, fields);
    }

    public static ListInfo queryListInfoWithTotalsize(DBOptions dbOptions, Class<?> beanType, String sql, long offset, int pagesize, long totalsize, Object ... fields) throws SQLException {
        return DBOPtionsSQLExecutor.queryListInfoWithDBName2ndTotalsize(dbOptions, beanType, null, sql, offset, pagesize, totalsize, fields);
    }

    public static ListInfo queryListInfoWithTotalsizesql(DBOptions dbOptions, Class<?> beanType, String sql, long offset, int pagesize, String totalsizesql, Object ... fields) throws SQLException {
        return DBOPtionsSQLExecutor.queryListInfoWithDBName2ndTotalsizesql(dbOptions, beanType, null, sql, offset, pagesize, totalsizesql, fields);
    }

    public static <T> T queryObject(DBOptions dbOptions, Class<T> beanType, String sql, Object ... fields) throws SQLException {
        return DBOPtionsSQLExecutor.queryObjectWithDBName(dbOptions, beanType, null, sql, fields);
    }

    public static <T> List<T> queryListWithDBName(DBOptions dbOptions, Class<T> beanType, String dbname, String sql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        return SQLInfoExecutor.queryListWithDBName(dbOptions, beanType, dbname, sqlinfo, fields);
    }

    public static <T> T queryObjectWithDBName(DBOptions dbOptions, Class<T> beanType, String dbname, String sql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        return SQLInfoExecutor.queryObjectWithDBName(dbOptions, beanType, dbname, sqlinfo, fields);
    }

    public static <T> List<T> queryListByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<T> beanType, String sql, Object ... fields) throws SQLException {
        return DBOPtionsSQLExecutor.queryListWithDBNameByRowHandler(dbOptions, rowhandler, beanType, null, sql, fields);
    }

    public static ListInfo queryListInfoWithDBNameByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, String dbname, String sql, long offset, int pagesize, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        return SQLInfoExecutor.queryListInfoWithDBNameByRowHandler(dbOptions, rowhandler, beanType, dbname, sqlinfo, offset, pagesize, fields);
    }

    public static ListInfo queryListInfoWithDBName2ndTotalsizeByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, String dbname, String sql, long offset, int pagesize, long totalsize, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        return SQLInfoExecutor.queryListInfoWithDBName2ndTotalsizeByRowHandler(dbOptions, rowhandler, beanType, dbname, sqlinfo, offset, pagesize, totalsize, fields);
    }

    public static ListInfo queryListInfoWithDBName2ndTotalsizesqlByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, String dbname, String sql, long offset, int pagesize, String totalsizesql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        SQLInfo totalsizesqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(totalsizesql);
        return SQLInfoExecutor.queryListInfoWithDBName2ndTotalsizesqlByRowHandler(dbOptions, rowhandler, beanType, dbname, sqlinfo, offset, pagesize, totalsizesqlinfo, fields);
    }

    public static ListInfo queryListInfoByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, String sql, long offset, int pagesize, Object ... fields) throws SQLException {
        return DBOPtionsSQLExecutor.queryListInfoWithDBNameByRowHandler(dbOptions, rowhandler, beanType, null, sql, offset, pagesize, fields);
    }

    public static ListInfo queryListInfoWithTotalsizeByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, String sql, long offset, int pagesize, long totalsize, Object ... fields) throws SQLException {
        return DBOPtionsSQLExecutor.queryListInfoWithDBName2ndTotalsizeByRowHandler(dbOptions, rowhandler, beanType, null, sql, offset, pagesize, totalsize, fields);
    }

    public static ListInfo queryListInfoWithTotalsizesqlByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, String sql, long offset, int pagesize, String totalsizesql, Object ... fields) throws SQLException {
        return DBOPtionsSQLExecutor.queryListInfoWithDBName2ndTotalsizesqlByRowHandler(dbOptions, rowhandler, beanType, null, sql, offset, pagesize, totalsizesql, fields);
    }

    public static <T> T queryObjectByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<T> beanType, String sql, Object ... fields) throws SQLException {
        return DBOPtionsSQLExecutor.queryObjectWithDBNameByRowHandler(dbOptions, rowhandler, beanType, null, sql, fields);
    }

    public static <T> List<T> queryListWithDBNameByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<T> beanType, String dbname, String sql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        return SQLInfoExecutor.queryListWithDBNameByRowHandler(dbOptions, rowhandler, beanType, dbname, sqlinfo, fields);
    }

    public static <T> T queryObjectWithDBNameByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<T> beanType, String dbname, String sql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        return SQLInfoExecutor.queryObjectWithDBNameByRowHandler(dbOptions, rowhandler, beanType, dbname, sqlinfo, fields);
    }

    public static void queryByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String sql, Object ... fields) throws SQLException {
        DBOPtionsSQLExecutor.queryWithDBNameByNullRowHandler(dbOptions, rowhandler, null, sql, fields);
    }

    public static ListInfo queryListInfoWithDBNameByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String dbname, String sql, long offset, int pagesize, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        return SQLInfoExecutor.queryListInfoWithDBNameByNullRowHandler(dbOptions, rowhandler, dbname, sqlinfo, offset, pagesize, fields);
    }

    public static ListInfo queryListInfoWithDBName2ndTotalsizeByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String dbname, String sql, long offset, int pagesize, long totalsize, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        return SQLInfoExecutor.queryListInfoWithDBName2ndTotalsizeByNullRowHandler(dbOptions, rowhandler, dbname, sqlinfo, offset, pagesize, totalsize, fields);
    }

    public static ListInfo queryListInfoWithDBName2ndTotalsizesqlByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String dbname, String sql, long offset, int pagesize, String totalsizesql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        SQLInfo totalsizesqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(totalsizesql);
        return SQLInfoExecutor.queryListInfoWithDBName2ndTotalsizesqlByNullRowHandler(dbOptions, rowhandler, dbname, sqlinfo, offset, pagesize, totalsizesqlinfo, fields);
    }

    public static ListInfo queryListInfoByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String sql, long offset, int pagesize, Object ... fields) throws SQLException {
        return DBOPtionsSQLExecutor.queryListInfoWithDBNameByNullRowHandler(dbOptions, rowhandler, null, sql, offset, pagesize, fields);
    }

    public static ListInfo queryListInfoWithTotalsizeByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String sql, long offset, int pagesize, long totalsize, Object ... fields) throws SQLException {
        return DBOPtionsSQLExecutor.queryListInfoWithDBName2ndTotalsizeByNullRowHandler(dbOptions, rowhandler, null, sql, offset, pagesize, totalsize, fields);
    }

    public static ListInfo queryListInfoWithTotalsizesqlByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String sql, long offset, int pagesize, String totalsizesql, Object ... fields) throws SQLException {
        return DBOPtionsSQLExecutor.queryListInfoWithDBName2ndTotalsizesqlByNullRowHandler(dbOptions, rowhandler, null, sql, offset, pagesize, totalsizesql, fields);
    }

    public static void queryWithDBNameByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String dbname, String sql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        SQLInfoExecutor.queryWithDBNameByNullRowHandler(dbOptions, rowhandler, dbname, sqlinfo, fields);
    }

    public static <T> List<T> queryListBean(DBOptions dbOptions, Class<T> beanType, String sql, Object bean) throws SQLException {
        return DBOPtionsSQLExecutor.queryListBeanWithDBName(dbOptions, beanType, null, sql, bean);
    }

    public static ListInfo queryListInfoBeanWithDBName(DBOptions dbOptions, Class<?> beanType, String dbname, String sql, long offset, int pagesize, long totalsize, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.queryListInfoBeanWithDBName(dbOptions, beanType, dbname, sqlinfo, offset, pagesize, totalsize, bean);
    }

    public static ListInfo queryListInfoBeanWithDBName(DBOptions dbOptions, Class<?> beanType, String dbname, String sql, long offset, int pagesize, String totalsizesql, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        SQLInfo totalsizesqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(totalsizesql, true, false);
        return SQLInfoExecutor.queryListInfoBeanWithDBName(dbOptions, beanType, dbname, sqlinfo, offset, pagesize, totalsizesqlinfo, bean);
    }

    public static ListInfo queryListInfoBeanWithDBName(DBOptions dbOptions, Class<?> beanType, String dbname, String sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.queryListInfoBeanWithDBName(dbOptions, beanType, dbname, sqlinfo, offset, pagesize, bean);
    }

    public static ListInfo queryListInfoBean(DBOptions dbOptions, Class<?> beanType, String sql, long offset, int pagesize, long totalsize, Object bean) throws SQLException {
        return DBOPtionsSQLExecutor.queryListInfoBeanWithDBName(dbOptions, beanType, (String)null, sql, offset, pagesize, totalsize, bean);
    }

    public static ListInfo queryListInfoBean(DBOptions dbOptions, Class<?> beanType, String sql, long offset, int pagesize, String totalsizesql, Object bean) throws SQLException {
        return DBOPtionsSQLExecutor.queryListInfoBeanWithDBName(dbOptions, beanType, (String)null, sql, offset, pagesize, totalsizesql, bean);
    }

    public static ListInfo queryListInfoBean(DBOptions dbOptions, Class<?> beanType, String sql, long offset, int pagesize, Object bean) throws SQLException {
        return DBOPtionsSQLExecutor.queryListInfoBeanWithDBName(dbOptions, beanType, (String)null, sql, offset, pagesize, -1L, bean);
    }

    public static String queryField(DBOptions dbOptions, String sql, Object ... fields) throws SQLException {
        return DBOPtionsSQLExecutor.queryFieldWithDBName(dbOptions, null, sql, fields);
    }

    public static String queryFieldBean(DBOptions dbOptions, String sql, Object bean) throws SQLException {
        return DBOPtionsSQLExecutor.queryFieldBeanWithDBName(dbOptions, null, sql, bean);
    }

    public static String queryFieldBeanWithDBName(DBOptions dbOptions, String dbname, String sql, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.queryFieldBeanWithDBName(dbOptions, dbname, sqlinfo, bean);
    }

    public static String queryFieldWithDBName(DBOptions dbOptions, String dbname, String sql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        return SQLInfoExecutor.queryFieldWithDBName(dbOptions, dbname, sqlinfo, fields);
    }

    public static <T> T queryTField(DBOptions dbOptions, Class<T> type, String sql, Object ... fields) throws SQLException {
        return DBOPtionsSQLExecutor.queryTFieldWithDBName(dbOptions, (String)null, type, sql, fields);
    }

    public static <T> T queryTFieldBean(DBOptions dbOptions, Class<T> type, String sql, Object bean) throws SQLException {
        return DBOPtionsSQLExecutor.queryTFieldBeanWithDBName(dbOptions, null, type, sql, bean);
    }

    public static <T> T queryTFieldBeanWithDBName(DBOptions dbOptions, String dbname, Class<T> type, String sql, Object bean) throws SQLException {
        return DBOPtionsSQLExecutor.queryTFieldBeanWithDBName(dbOptions, dbname, type, null, sql, bean);
    }

    public static <T> T queryTFieldWithDBName(DBOptions dbOptions, String dbname, Class<T> type, String sql, Object ... fields) throws SQLException {
        return DBOPtionsSQLExecutor.queryTFieldWithDBName(dbOptions, dbname, type, (FieldRowHandler)null, sql, fields);
    }

    public static <T> T queryTField(DBOptions dbOptions, Class<T> type, FieldRowHandler<T> fieldRowHandler, String sql, Object ... fields) throws SQLException {
        return DBOPtionsSQLExecutor.queryTFieldWithDBName(dbOptions, (String)null, type, fieldRowHandler, sql, fields);
    }

    public static <T> T queryTFieldBean(DBOptions dbOptions, Class<T> type, FieldRowHandler<T> fieldRowHandler, String sql, Object bean) throws SQLException {
        return DBOPtionsSQLExecutor.queryTFieldBeanWithDBName(dbOptions, null, type, fieldRowHandler, sql, bean);
    }

    public static <T> T queryTFieldBeanWithDBName(DBOptions dbOptions, String dbname, Class<T> type, FieldRowHandler<T> fieldRowHandler, String sql, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.queryTFieldBeanWithDBName(dbOptions, dbname, type, fieldRowHandler, sqlinfo, bean);
    }

    public static <T> T queryTFieldWithDBName(DBOptions dbOptions, String dbname, Class<T> type, FieldRowHandler<T> fieldRowHandler, String sql, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        return SQLInfoExecutor.queryTFieldWithDBName(dbOptions, dbname, type, fieldRowHandler, sqlinfo, fields);
    }

    public static <T> T queryObjectBean(DBOptions dbOptions, Class<T> beanType, String sql, Object bean) throws SQLException {
        return DBOPtionsSQLExecutor.queryObjectBeanWithDBName(dbOptions, beanType, null, sql, bean);
    }

    public static <T> List<T> queryListBeanWithDBName(DBOptions dbOptions, Class<T> beanType, String dbname, String sql, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.queryListBeanWithDBName(dbOptions, beanType, dbname, sqlinfo, bean);
    }

    public static <T> T queryObjectBeanWithDBName(DBOptions dbOptions, Class<T> beanType, String dbname, String sql, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.queryObjectBeanWithDBName(dbOptions, beanType, dbname, sqlinfo, bean);
    }

    public static <T> List<T> queryListBeanByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<T> beanType, String sql, Object bean) throws SQLException {
        return DBOPtionsSQLExecutor.queryListBeanWithDBNameByRowHandler(dbOptions, rowhandler, beanType, null, sql, bean);
    }

    public static ListInfo queryListInfoBeanWithDBNameByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, String dbname, String sql, long offset, int pagesize, long totalsize, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.queryListInfoBeanWithDBNameByRowHandler(dbOptions, rowhandler, beanType, dbname, sqlinfo, offset, pagesize, totalsize, bean);
    }

    public static ListInfo queryListInfoBeanWithDBNameByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, String dbname, String sql, long offset, int pagesize, String totalsizesql, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        SQLInfo totalsizesqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(totalsizesql, true, false);
        return SQLInfoExecutor.queryListInfoBeanWithDBNameByRowHandler(dbOptions, rowhandler, beanType, dbname, sqlinfo, offset, pagesize, totalsizesqlinfo, bean);
    }

    public static ListInfo queryListInfoBeanWithDBNameByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, String dbname, String sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.queryListInfoBeanWithDBNameByRowHandler(dbOptions, rowhandler, beanType, dbname, sqlinfo, offset, pagesize, bean);
    }

    public static ListInfo queryListInfoBeanByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, String sql, long offset, int pagesize, long totalsize, Object bean) throws SQLException {
        return DBOPtionsSQLExecutor.queryListInfoBeanWithDBNameByRowHandler(dbOptions, rowhandler, beanType, (String)null, sql, offset, pagesize, totalsize, bean);
    }

    public static ListInfo queryListInfoBeanByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, String sql, long offset, int pagesize, String totalsizesql, Object bean) throws SQLException {
        return DBOPtionsSQLExecutor.queryListInfoBeanWithDBNameByRowHandler(dbOptions, rowhandler, beanType, (String)null, sql, offset, pagesize, totalsizesql, bean);
    }

    public static ListInfo queryListInfoBeanByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, String sql, long offset, int pagesize, Object bean) throws SQLException {
        return DBOPtionsSQLExecutor.queryListInfoBeanWithDBNameByRowHandler(dbOptions, rowhandler, beanType, (String)null, sql, offset, pagesize, -1L, bean);
    }

    public static <T> T queryObjectBeanByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<T> beanType, String sql, Object bean) throws SQLException {
        return DBOPtionsSQLExecutor.queryObjectBeanWithDBNameByRowHandler(dbOptions, rowhandler, beanType, null, sql, bean);
    }

    public static <T> List<T> queryListBeanWithDBNameByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<T> beanType, String dbname, String sql, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.queryListBeanWithDBNameByRowHandler(dbOptions, rowhandler, beanType, dbname, sqlinfo, bean);
    }

    public static <T> T queryObjectBeanWithDBNameByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<T> beanType, String dbname, String sql, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.queryObjectBeanWithDBNameByRowHandler(dbOptions, rowhandler, beanType, dbname, sqlinfo, bean);
    }

    public static void queryBeanByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String sql, Object bean) throws SQLException {
        DBOPtionsSQLExecutor.queryBeanWithDBNameByNullRowHandler(dbOptions, rowhandler, null, sql, bean);
    }

    public static ListInfo queryListInfoBeanWithDBNameByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String dbname, String sql, long offset, int pagesize, long totalsize, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.queryListInfoBeanWithDBNameByNullRowHandler(dbOptions, rowhandler, dbname, sqlinfo, offset, pagesize, totalsize, bean);
    }

    public static ListInfo queryListInfoBeanWithDBNameByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String dbname, String sql, long offset, int pagesize, String totalsizesql, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        SQLInfo totalsizesqlsqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(totalsizesql, true, false);
        return SQLInfoExecutor.queryListInfoBeanWithDBNameByNullRowHandler(dbOptions, rowhandler, dbname, sqlinfo, offset, pagesize, totalsizesqlsqlinfo, bean);
    }

    public static ListInfo queryListInfoBeanWithDBNameByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String dbname, String sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.queryListInfoBeanWithDBNameByNullRowHandler(dbOptions, rowhandler, dbname, sqlinfo, offset, pagesize, bean);
    }

    public static ListInfo queryListInfoBeanByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String sql, long offset, int pagesize, long totalsize, Object bean) throws SQLException {
        return DBOPtionsSQLExecutor.queryListInfoBeanWithDBNameByNullRowHandler(dbOptions, rowhandler, (String)null, sql, offset, pagesize, totalsize, bean);
    }

    public static ListInfo queryListInfoBeanByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String sql, long offset, int pagesize, String totalsizesql, Object bean) throws SQLException {
        return DBOPtionsSQLExecutor.queryListInfoBeanWithDBNameByNullRowHandler(dbOptions, rowhandler, (String)null, sql, offset, pagesize, totalsizesql, bean);
    }

    public static ListInfo queryListInfoBeanByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String sql, long offset, int pagesize, Object bean) throws SQLException {
        return DBOPtionsSQLExecutor.queryListInfoBeanWithDBNameByNullRowHandler(dbOptions, rowhandler, (String)null, sql, offset, pagesize, -1L, bean);
    }

    public static void queryBeanWithDBNameByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String dbname, String sql, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        SQLInfoExecutor.queryBeanWithDBNameByNullRowHandler(dbOptions, rowhandler, dbname, sqlinfo, bean);
    }

    public static ListInfo moreListInfoWithDBNameByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, String dbname, String sql, long offset, int pagesize, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        return SQLInfoExecutor.moreListInfoWithDBNameByRowHandler(dbOptions, rowhandler, beanType, dbname, sqlinfo, offset, pagesize, fields);
    }

    public static ListInfo moreListInfoWithDBNameByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String dbname, String sql, long offset, int pagesize, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        return SQLInfoExecutor.moreListInfoWithDBNameByNullRowHandler(dbOptions, rowhandler, dbname, sqlinfo, offset, pagesize, fields);
    }

    public static ListInfo moreListInfoWithDBName(DBOptions dbOptions, Class<?> beanType, String dbname, String sql, long offset, int pagesize, Object ... fields) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getPureSQLInfo(sql);
        return SQLInfoExecutor.moreListInfoWithDBName(dbOptions, beanType, dbname, sqlinfo, offset, pagesize, fields);
    }

    public static ListInfo moreListInfoByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, String sql, long offset, int pagesize, Object ... fields) throws SQLException {
        return DBOPtionsSQLExecutor.moreListInfoWithDBNameByRowHandler(dbOptions, rowhandler, beanType, null, sql, offset, pagesize, fields);
    }

    public static ListInfo moreListInfoByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String sql, long offset, int pagesize, Object ... fields) throws SQLException {
        return DBOPtionsSQLExecutor.moreListInfoWithDBNameByNullRowHandler(dbOptions, rowhandler, null, sql, offset, pagesize, fields);
    }

    public static ListInfo moreListInfoBeanWithDBNameByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, String dbname, String sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.moreListInfoBeanWithDBNameByRowHandler(dbOptions, rowhandler, beanType, dbname, sqlinfo, offset, pagesize, bean);
    }

    public static ListInfo moreListInfoBeanWithDBNameByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String dbname, String sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.moreListInfoBeanWithDBNameByNullRowHandler(dbOptions, rowhandler, dbname, sqlinfo, offset, pagesize, bean);
    }

    public static ListInfo moreListInfoBeanWithDBName(DBOptions dbOptions, Class<?> beanType, String dbname, String sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.moreListInfoBeanWithDBName(dbOptions, beanType, dbname, sqlinfo, offset, pagesize, bean);
    }

    public static ListInfo moreListInfoBeanByRowHandler(DBOptions dbOptions, RowHandler rowhandler, Class<?> beanType, String sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.moreListInfoBeanWithDBNameByRowHandler(dbOptions, rowhandler, beanType, null, sqlinfo, offset, pagesize, bean);
    }

    public static ListInfo moreListInfoBeanByNullRowHandler(DBOptions dbOptions, NullRowHandler rowhandler, String sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.moreListInfoBeanWithDBNameByNullRowHandler(dbOptions, rowhandler, null, sqlinfo, offset, pagesize, bean);
    }

    public static ListInfo moreListInfoBean(DBOptions dbOptions, Class<?> beanType, String sql, long offset, int pagesize, Object bean) throws SQLException {
        SQLInfo sqlinfo = SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, true, false);
        return SQLInfoExecutor.moreListInfoBeanWithDBName(dbOptions, beanType, null, sqlinfo, offset, pagesize, bean);
    }

    public static ListInfo moreListInfo(DBOptions dbOptions, Class<?> beanType, String sql, long offset, int pagesize, Object ... fields) throws SQLException {
        return DBOPtionsSQLExecutor.moreListInfoWithDBName(dbOptions, beanType, null, sql, offset, pagesize, fields);
    }
}

