/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.orm.engine.transform;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DTDResolver
implements EntityResolver,
Serializable {
    public static final String WEB_SITE_DTD = "http://db.apache.org/torque/dtd/database_3_2.dtd";
    private InputSource databaseDTD = null;
    private static Logger log = LoggerFactory.getLogger(DTDResolver.class);

    public DTDResolver() throws SAXException {
        try {
            InputStream dtdStream = this.getClass().getResourceAsStream("database.dtd");
            if (dtdStream != null) {
                this.databaseDTD = new InputSource(dtdStream);
            } else {
                log.warn("Could not locate database.dtd");
            }
        }
        catch (Exception ex) {
            throw new SAXException("Could not get stream for database.dtd", ex);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException {
        if (this.databaseDTD != null && WEB_SITE_DTD.equals(systemId)) {
            String pkg = this.getClass().getName().substring(0, this.getClass().getName().lastIndexOf(46));
            log.info("Resolver: used database.dtd from '" + pkg + "' package");
            return this.databaseDTD;
        }
        if (systemId == null || "".equals(systemId.trim())) {
            log.info("Resolver: used 'http://db.apache.org/torque/dtd/database_3_2.dtd'");
            return this.getInputSource(WEB_SITE_DTD);
        }
        log.info("Resolver: used '" + systemId + '\'');
        return this.getInputSource(systemId);
    }

    private InputSource getInputSource(String urlString) throws IOException {
        URL url = new URL(urlString);
        return new InputSource(url.openStream());
    }
}

