/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.persitent.datasource;

import com.frameworkset.commons.dbcp.BasicDataSourceFactory;
import com.frameworkset.orm.adapter.DB;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import javax.sql.DataSource;
import org.frameworkset.persitent.datasource.BalanceDatasource;
import org.frameworkset.persitent.datasource.BalanceDatasourceConfig;

public class RandomBalanceDatasource
extends BalanceDatasource {
    private final ThreadLocal<Random> randomThreadLocal = new ThreadLocal();

    public RandomBalanceDatasource(BalanceDatasourceConfig balanceDatasourceConfig, String url, DB db, Properties properties) {
        super(balanceDatasourceConfig, url, db, properties);
    }

    @Override
    protected void buildAddress() throws Exception {
        DataSource currentDatasource = null;
        for (String node : this.nodes) {
            currentDatasource = BasicDataSourceFactory.createDBCP2DataSource(node, this.properties);
            this.balanceDatasources.put(node, currentDatasource);
            if (this.currentDatasource != null) continue;
            this.currentDatasource = currentDatasource;
        }
    }

    @Override
    protected String getAnyUrl() throws SQLException {
        List localEnabledUrls = this.nodes;
        if (localEnabledUrls.isEmpty()) {
            throw new SQLException("Unable to get connection: there are no enabled urls");
        }
        Random random = this.randomThreadLocal.get();
        if (random == null) {
            this.randomThreadLocal.set(new Random());
            random = this.randomThreadLocal.get();
        }
        int index = random.nextInt(localEnabledUrls.size());
        return (String)localEnabledUrls.get(index);
    }
}

