/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.cache;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class EdenConcurrentCache<K, V> {
    private final int size;
    public final int DEFAULT_SIZE = 1000;
    private final Map<K, V> eden;
    private final AtomicLong missing;
    private final Lock cacheLock = new ReentrantLock();
    private final Map<K, V> longterm;

    public EdenConcurrentCache() {
        this.size = 1000;
        this.eden = new ConcurrentHashMap();
        this.longterm = new WeakHashMap();
        this.missing = new AtomicLong();
    }

    public EdenConcurrentCache(int size) {
        this.size = size;
        this.eden = new ConcurrentHashMap();
        this.longterm = new WeakHashMap();
        this.missing = new AtomicLong();
    }

    public V get(K k) {
        V v = this.eden.get(k);
        if (v == null) {
            this.cacheLock.lock();
            try {
                v = this.longterm.get(k);
            }
            finally {
                this.cacheLock.unlock();
            }
            if (v != null) {
                this.eden.put(k, v);
            }
        }
        return v;
    }

    public int getMaxSize() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(K k, V v) {
        boolean outOfSize = false;
        if (this.eden.size() >= this.size) {
            this.cacheLock.lock();
            try {
                this.longterm.putAll(this.eden);
            }
            finally {
                this.cacheLock.unlock();
            }
            outOfSize = true;
            this.eden.clear();
        }
        this.eden.put(k, v);
        return outOfSize;
    }

    public int longtermSize() {
        return this.longterm.size();
    }

    public int edenSize() {
        return this.eden.size();
    }

    public void clear() {
        this.eden.clear();
        this.cacheLock.lock();
        try {
            this.longterm.clear();
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    public long increamentMissing() {
        return this.missing.incrementAndGet();
    }

    public boolean needLogWarn(long misses, long warnInterval) {
        return misses >= (long)this.size && misses % warnInterval == 0L;
    }
}

