/*
 * Decompiled with CFR 0.152.
 */
package bboss.org.apache.velocity.app.event.implement;

import bboss.org.apache.velocity.app.event.MethodExceptionEventHandler;
import bboss.org.apache.velocity.context.Context;
import bboss.org.apache.velocity.runtime.RuntimeServices;
import bboss.org.apache.velocity.util.RuntimeServicesAware;
import bboss.org.apache.velocity.util.introspection.Info;
import java.io.PrintWriter;
import java.io.StringWriter;

public class PrintExceptions
implements MethodExceptionEventHandler,
RuntimeServicesAware {
    private static String SHOW_TEMPLATE_INFO = "eventhandler.methodexception.templateinfo";
    private static String SHOW_STACK_TRACE = "eventhandler.methodexception.stacktrace";
    private RuntimeServices rs = null;

    @Override
    public Object methodException(Context context, Class<?> claz, String method, Exception e, Info info) {
        boolean showTemplateInfo = this.rs.getBoolean(SHOW_TEMPLATE_INFO, false);
        boolean showStackTrace = this.rs.getBoolean(SHOW_STACK_TRACE, false);
        StringBuilder st = new StringBuilder();
        st.append("Exception while executing method ").append(claz.toString()).append(".").append(method);
        st.append(": ").append(e.getClass().getName()).append(": ").append(e.getMessage());
        if (showTemplateInfo) {
            st.append(" at ").append(info.getTemplateName()).append(" (line ").append(info.getLine()).append(", column ").append(info.getColumn()).append(")");
        }
        if (showStackTrace) {
            st.append(System.lineSeparator()).append(PrintExceptions.getStackTrace(e));
        }
        return st.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStackTrace(Throwable throwable) {
        try (PrintWriter printWriter = null;){
            StringWriter stackTraceWriter = new StringWriter();
            printWriter = new PrintWriter(stackTraceWriter);
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            String string = stackTraceWriter.toString();
            return string;
        }
    }

    @Override
    public void setRuntimeServices(RuntimeServices rs) {
        this.rs = rs;
    }
}

