/*
 * Decompiled with CFR 0.152.
 */
package bboss.org.apache.velocity.runtime.directive;

import bboss.org.apache.velocity.Template;
import bboss.org.apache.velocity.context.InternalContextAdapter;
import bboss.org.apache.velocity.exception.MethodInvocationException;
import bboss.org.apache.velocity.exception.ParseErrorException;
import bboss.org.apache.velocity.exception.ResourceNotFoundException;
import bboss.org.apache.velocity.exception.TemplateInitException;
import bboss.org.apache.velocity.exception.VelocityException;
import bboss.org.apache.velocity.runtime.Renderable;
import bboss.org.apache.velocity.runtime.RuntimeConstants;
import bboss.org.apache.velocity.runtime.RuntimeServices;
import bboss.org.apache.velocity.runtime.directive.Directive;
import bboss.org.apache.velocity.runtime.directive.StopCommand;
import bboss.org.apache.velocity.runtime.directive.VelocimacroProxy;
import bboss.org.apache.velocity.runtime.parser.Token;
import bboss.org.apache.velocity.runtime.parser.node.ASTDirective;
import bboss.org.apache.velocity.runtime.parser.node.Node;
import bboss.org.apache.velocity.util.StringUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class RuntimeMacro
extends Directive {
    private String macroName;
    private String literal = null;
    private Node node = null;
    protected boolean strictRef = false;
    private String badArgsErrorMsg = null;

    @Override
    public String getName() {
        return this.macroName;
    }

    @Override
    public String getScopeName() {
        return "macro";
    }

    @Override
    public int getType() {
        return 2;
    }

    public void init(RuntimeServices rs, String name, InternalContextAdapter context, Node node) {
        super.init(rs, context, node);
        this.macroName = (String)Validate.notNull((Object)name);
        this.macroName = this.rsvc.useStringInterning() ? this.macroName.intern() : this.macroName;
        this.node = node;
        Token t = node.getLastToken();
        if (t.image.startsWith(")") || t.image.startsWith(this.rsvc.getParserConfiguration().getHashChar() + "end")) {
            this.strictRef = this.rsvc.getBoolean("runtime.strict_mode.enable", false);
        }
        for (int n = 0; n < node.jjtGetNumChildren(); ++n) {
            Node child = node.jjtGetChild(n);
            if (child.getType() != 11) continue;
            this.badArgsErrorMsg = "Invalid arg '" + child.getFirstTokenImage() + "' in macro #" + this.macroName + " at " + StringUtils.formatFileString(child);
            if (!this.strictRef) continue;
            throw new TemplateInitException(this.badArgsErrorMsg, null, this.rsvc.getLogContext().getStackTrace(), context.getCurrentTemplateName(), 0, 0);
        }
        this.getLiteral();
    }

    private String getLiteral() {
        RuntimeConstants.SpaceGobbling spaceGobbling = this.rsvc.getSpaceGobbling();
        ASTDirective directive = (ASTDirective)this.node;
        String morePrefix = directive.getMorePrefix();
        if (this.literal == null) {
            StringBuilder buffer = new StringBuilder();
            Token t = this.node.getFirstToken();
            int pos = -1;
            while (t != null && t != this.node.getLastToken()) {
                if (pos == -1) {
                    pos = t.image.lastIndexOf(this.rsvc.getParserConfiguration().getHashChar());
                }
                if (pos != -1) {
                    buffer.append(t.image.substring(pos));
                    pos = 0;
                } else if (morePrefix.length() == 0 && spaceGobbling.compareTo(RuntimeConstants.SpaceGobbling.LINES) >= 0) {
                    buffer.append(t.image);
                }
                t = t.next;
            }
            if (t != null) {
                if (pos == -1) {
                    pos = t.image.lastIndexOf(this.rsvc.getParserConfiguration().getHashChar());
                }
                if (pos != -1) {
                    buffer.append(t.image.substring(pos));
                }
            }
            this.literal = buffer.toString();
            String postfix = directive.getPostfix();
            if ((morePrefix.length() > 0 || spaceGobbling == RuntimeConstants.SpaceGobbling.NONE) && this.literal.endsWith(postfix)) {
                this.literal = this.literal.substring(0, this.literal.length() - postfix.length());
            }
        }
        return this.literal;
    }

    @Override
    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        return this.render(context, writer, node, null);
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node, Renderable body) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        List<Template> macroLibraries2;
        VelocimacroProxy vmProxy = null;
        Template renderingTemplate = (Template)context.getCurrentResource();
        Directive o = this.rsvc.getVelocimacro(this.macroName, renderingTemplate, this.getTemplate());
        if (o != null) {
            vmProxy = (VelocimacroProxy)o;
        }
        if (vmProxy == null && (macroLibraries2 = context.getMacroLibraries()) != null) {
            for (int i = macroLibraries2.size() - 1; i >= 0; --i) {
                o = this.rsvc.getVelocimacro(this.macroName, renderingTemplate, macroLibraries2.get(i));
                if (o == null) continue;
                vmProxy = (VelocimacroProxy)o;
                break;
            }
        }
        if (vmProxy != null) {
            if (this.badArgsErrorMsg != null) {
                throw new TemplateInitException(this.badArgsErrorMsg, null, this.rsvc.getLogContext().getStackTrace(), context.getCurrentTemplateName(), node.getColumn(), node.getLine());
            }
            try {
                this.preRender(context);
                boolean macroLibraries2 = vmProxy.render(context, writer, node, body);
                return macroLibraries2;
            }
            catch (StopCommand stop) {
                if (!stop.isFor(this)) {
                    throw stop;
                }
                boolean bl = true;
                return bl;
            }
            catch (IOException | RuntimeException e) {
                this.log.error("Exception in macro #{} called at {}", (Object)this.macroName, (Object)StringUtils.formatFileString(node));
                throw e;
            }
            finally {
                this.postRender(context);
            }
        }
        if (this.strictRef) {
            throw new VelocityException("Macro '#" + this.macroName + "' is not defined at " + StringUtils.formatFileString(node), null, this.rsvc.getLogContext().getStackTrace());
        }
        writer.write(this.getLiteral());
        return true;
    }
}

