/*
 * Decompiled with CFR 0.152.
 */
package bboss.org.apache.velocity.runtime.parser.node;

import bboss.org.apache.velocity.context.InternalContextAdapter;
import bboss.org.apache.velocity.exception.MethodInvocationException;
import bboss.org.apache.velocity.exception.ParseErrorException;
import bboss.org.apache.velocity.exception.ResourceNotFoundException;
import bboss.org.apache.velocity.exception.TemplateInitException;
import bboss.org.apache.velocity.exception.VelocityException;
import bboss.org.apache.velocity.runtime.RuntimeConstants;
import bboss.org.apache.velocity.runtime.directive.BlockMacro;
import bboss.org.apache.velocity.runtime.directive.Directive;
import bboss.org.apache.velocity.runtime.directive.RuntimeMacro;
import bboss.org.apache.velocity.runtime.parser.ParseException;
import bboss.org.apache.velocity.runtime.parser.Parser;
import bboss.org.apache.velocity.runtime.parser.Token;
import bboss.org.apache.velocity.runtime.parser.node.NodeUtils;
import bboss.org.apache.velocity.runtime.parser.node.SimpleNode;
import bboss.org.apache.velocity.runtime.parser.node.StandardParserVisitor;
import bboss.org.apache.velocity.util.introspection.Info;
import java.io.IOException;
import java.io.Writer;

public class ASTDirective
extends SimpleNode {
    private Directive directive = null;
    private String directiveName = "";
    private boolean isDirective;
    private boolean isInitialized;
    private String prefix = "";
    private String postfix = "";
    private String morePrefix = "";

    public ASTDirective(int id) {
        super(id);
    }

    public ASTDirective(Parser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(StandardParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public synchronized Object init(InternalContextAdapter context, Object data) throws TemplateInitException {
        if (!this.isInitialized) {
            super.init(context, data);
            Token t = this.getFirstToken();
            int pos = -1;
            while (t != null && (pos = t.image.lastIndexOf(this.rsvc.getParserConfiguration().getHashChar())) == -1) {
                t = t.next;
            }
            if (t != null && pos > 0) {
                this.morePrefix = t.image.substring(0, pos);
            }
            if (this.parser.isDirective(this.directiveName)) {
                this.isDirective = true;
                try {
                    this.directive = (Directive)this.parser.getDirective(this.directiveName).getClass().newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new VelocityException("Couldn't initialize directive of class " + this.parser.getDirective(this.directiveName).getClass().getName(), e, this.rsvc.getLogContext().getStackTrace());
                }
                t = this.getFirstToken();
                if (t.kind == 32) {
                    t = t.next;
                }
                this.directive.setLocation(t.beginLine, t.beginColumn, this.getTemplate());
                this.directive.init(this.rsvc, context, this);
            } else if (this.directiveName.startsWith(String.valueOf(this.rsvc.getParserConfiguration().getAtChar()))) {
                if (this.jjtGetNumChildren() > 0) {
                    this.directiveName = this.directiveName.substring(1);
                    this.directive = new BlockMacro();
                    this.directive.setLocation(this.getLine(), this.getColumn(), this.getTemplate());
                    try {
                        ((BlockMacro)this.directive).init(this.rsvc, this.directiveName, context, this);
                    }
                    catch (TemplateInitException die) {
                        throw new TemplateInitException(die.getMessage(), (ParseException)die.getCause(), this.rsvc.getLogContext().getStackTrace(), die.getTemplateName(), die.getColumnNumber() + this.getColumn(), die.getLineNumber() + this.getLine());
                    }
                    this.isDirective = true;
                } else {
                    this.isDirective = false;
                }
            } else {
                this.directive = new RuntimeMacro();
                this.directive.setLocation(this.getLine(), this.getColumn(), this.getTemplate());
                try {
                    ((RuntimeMacro)this.directive).init(this.rsvc, this.directiveName, context, this);
                }
                catch (TemplateInitException die) {
                    throw new TemplateInitException(die.getMessage(), (ParseException)die.getCause(), this.rsvc.getLogContext().getStackTrace(), die.getTemplateName(), die.getColumnNumber() + this.getColumn(), die.getLineNumber() + this.getLine());
                }
                this.isDirective = true;
            }
            this.isInitialized = true;
            this.saveTokenImages();
            this.cleanupParserAndTokens();
        }
        if (this.morePrefix.length() == 0 && this.rsvc.getSpaceGobbling() == RuntimeConstants.SpaceGobbling.STRUCTURED && this.isInitialized && this.isDirective && this.directive.getType() == 1) {
            NodeUtils.fixIndentation(this, this.prefix);
        }
        return data;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }

    public String getPostfix() {
        return this.postfix;
    }

    public String getMorePrefix() {
        return this.morePrefix;
    }

    public int getDirectiveType() {
        return this.directive.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean render(InternalContextAdapter context, Writer writer) throws IOException, MethodInvocationException, ResourceNotFoundException, ParseErrorException {
        RuntimeConstants.SpaceGobbling spaceGobbling = this.rsvc.getSpaceGobbling();
        if (this.isDirective) {
            if (this.morePrefix.length() > 0 || spaceGobbling.compareTo(RuntimeConstants.SpaceGobbling.LINES) < 0) {
                writer.write(this.prefix);
            }
            writer.write(this.morePrefix);
            try {
                this.rsvc.getLogContext().pushLogContext(this, new Info(this.getTemplateName(), this.getLine(), this.getColumn()));
                this.directive.render(context, writer, this);
            }
            finally {
                this.rsvc.getLogContext().popLogContext();
            }
            if (this.morePrefix.length() > 0 || spaceGobbling == RuntimeConstants.SpaceGobbling.NONE) {
                writer.write(this.postfix);
            }
        } else {
            writer.write(this.prefix);
            writer.write(this.morePrefix);
            writer.write(this.rsvc.getParserConfiguration().getHashChar());
            writer.write(this.directiveName);
            writer.write(this.postfix);
        }
        return true;
    }

    public void setDirectiveName(String str) {
        this.directiveName = str;
    }

    public String getDirectiveName() {
        return this.directiveName;
    }

    @Override
    public String toString() {
        return "ASTDirective [" + super.toString() + ", directiveName=" + this.directiveName + "]";
    }

    @Override
    public String literal() {
        if (this.literal != null) {
            return this.literal;
        }
        StringBuilder builder = new StringBuilder();
        builder.append('#').append(this.getDirectiveName()).append("(...)");
        this.literal = builder.toString();
        return this.literal;
    }
}

