/*
 * Decompiled with CFR 0.152.
 */
package bboss.org.apache.velocity.runtime.parser.node;

import bboss.org.apache.velocity.context.InternalContextAdapter;
import bboss.org.apache.velocity.exception.MathException;
import bboss.org.apache.velocity.exception.TemplateInitException;
import bboss.org.apache.velocity.runtime.parser.Parser;
import bboss.org.apache.velocity.runtime.parser.node.ASTMathNode;
import bboss.org.apache.velocity.runtime.parser.node.MathUtils;

public class ASTModNode
extends ASTMathNode {
    public ASTModNode(int id) {
        super(id);
    }

    public ASTModNode(Parser p, int id) {
        super(p, id);
    }

    @Override
    public Number perform(Number left, Number right, InternalContextAdapter context) {
        if (MathUtils.isZero(right)) {
            String msg = "Right side of modulus operation is zero. Must be non-zero. " + this.getLocation(context);
            if (this.strictMode) {
                this.log.error(msg);
                throw new MathException(msg, this.rsvc.getLogContext().getStackTrace());
            }
            this.log.debug(msg);
            return null;
        }
        return MathUtils.modulo(left, right);
    }

    @Override
    public Object init(InternalContextAdapter context, Object data) throws TemplateInitException {
        Object obj = super.init(context, data);
        this.cleanupParserAndTokens();
        return obj;
    }

    @Override
    public String getLiteralOperator() {
        return "%";
    }
}

