/*
 * Decompiled with CFR 0.152.
 */
package bboss.org.apache.velocity.runtime.resource;

import bboss.org.apache.velocity.context.Context;
import bboss.org.apache.velocity.exception.MethodInvocationException;
import bboss.org.apache.velocity.exception.ParseErrorException;
import bboss.org.apache.velocity.exception.ResourceNotFoundException;
import bboss.org.apache.velocity.runtime.RuntimeServices;
import bboss.org.apache.velocity.runtime.resource.loader.ResourceLoader;
import java.io.Writer;
import org.slf4j.Logger;

public abstract class Resource
implements Cloneable {
    protected RuntimeServices rsvc = null;
    protected Logger log = null;
    protected ResourceLoader resourceLoader;
    protected static final long MILLIS_PER_SECOND = 1000L;
    protected long modificationCheckInterval = 0L;
    protected long lastModified = 0L;
    protected long nextCheck = 0L;
    protected String name;
    protected String encoding = "UTF-8";
    protected Object data = null;
    protected int type;

    public void setRuntimeServices(RuntimeServices rs) {
        this.rsvc = rs;
        this.log = this.rsvc.getLog("loader");
    }

    public void merge(Context context, Writer writer) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException {
    }

    public abstract boolean process() throws ResourceNotFoundException, ParseErrorException;

    public boolean isSourceModified() {
        return this.resourceLoader.isSourceModified(this);
    }

    public void setModificationCheckInterval(long modificationCheckInterval) {
        this.modificationCheckInterval = modificationCheckInterval;
    }

    public boolean requiresChecking() {
        if (this.modificationCheckInterval <= 0L) {
            return false;
        }
        return System.currentTimeMillis() >= this.nextCheck;
    }

    public void touch() {
        this.nextCheck = System.currentTimeMillis() + 1000L * this.modificationCheckInterval;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public Object clone() {
        try {
            Resource clone = (Resource)super.clone();
            clone.deepCloneData();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("cloning not supported");
        }
    }

    protected void deepCloneData() throws CloneNotSupportedException {
    }
}

