/*
 * Decompiled with CFR 0.152.
 */
package bboss.org.apache.velocity.runtime.resource;

import bboss.org.apache.velocity.exception.ParseErrorException;
import bboss.org.apache.velocity.exception.ResourceNotFoundException;
import bboss.org.apache.velocity.exception.VelocityException;
import bboss.org.apache.velocity.runtime.RuntimeServices;
import bboss.org.apache.velocity.runtime.resource.Resource;
import bboss.org.apache.velocity.runtime.resource.ResourceCache;
import bboss.org.apache.velocity.runtime.resource.ResourceCacheImpl;
import bboss.org.apache.velocity.runtime.resource.ResourceFactory;
import bboss.org.apache.velocity.runtime.resource.ResourceManager;
import bboss.org.apache.velocity.runtime.resource.loader.ResourceLoader;
import bboss.org.apache.velocity.runtime.resource.loader.ResourceLoaderFactory;
import bboss.org.apache.velocity.util.ClassUtils;
import bboss.org.apache.velocity.util.ExtProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class ResourceManagerImpl
implements ResourceManager {
    protected ResourceCache globalCache = null;
    protected final List<ResourceLoader> resourceLoaders = new ArrayList<ResourceLoader>();
    private final List<ExtProperties> sourceInitializerList = new ArrayList<ExtProperties>();
    private boolean isInit = false;
    private boolean logWhenFound = true;
    protected RuntimeServices rsvc = null;
    protected Logger log = null;

    @Override
    public synchronized void initialize(RuntimeServices rs) {
        if (this.isInit) {
            this.log.debug("Re-initialization of ResourceLoader attempted and ignored.");
            return;
        }
        ResourceLoader resourceLoader = null;
        this.rsvc = rs;
        this.log = this.rsvc.getLog("loader");
        this.log.trace("ResourceManager initializing: {}", this.getClass());
        this.assembleResourceLoaderInitializers();
        for (ExtProperties configuration : this.sourceInitializerList) {
            String loaderClass = StringUtils.trim((String)configuration.getString("class"));
            ResourceLoader loaderInstance = (ResourceLoader)configuration.get("instance");
            if (loaderInstance != null) {
                resourceLoader = loaderInstance;
            } else if (loaderClass != null) {
                resourceLoader = ResourceLoaderFactory.getLoader(this.rsvc, loaderClass);
            } else {
                String msg = "Unable to find 'resource.loader." + configuration.getString("_RESOURCE_LOADER_IDENTIFIER_") + ".class' specification in configuration. This is a critical value.  Please adjust configuration.";
                this.log.error(msg);
                throw new VelocityException(msg, null, this.rsvc.getLogContext().getStackTrace());
            }
            resourceLoader.commonInit(this.rsvc, configuration);
            resourceLoader.init(configuration);
            this.resourceLoaders.add(resourceLoader);
        }
        this.logWhenFound = this.rsvc.getBoolean("resource.manager.log_when_found", true);
        String cacheClassName = this.rsvc.getString("resource.manager.cache.class");
        Object cacheObject = null;
        if (StringUtils.isNotEmpty((CharSequence)cacheClassName)) {
            try {
                cacheObject = ClassUtils.getNewInstance(cacheClassName);
            }
            catch (ClassNotFoundException cnfe) {
                String msg = "The specified class for ResourceCache (" + cacheClassName + ") does not exist or is not accessible to the current classloader.";
                this.log.error(msg, (Throwable)cnfe);
                throw new VelocityException(msg, cnfe);
            }
            catch (IllegalAccessException ae) {
                throw new VelocityException("Could not access class '" + cacheClassName + "'", ae);
            }
            catch (InstantiationException ie) {
                throw new VelocityException("Could not instantiate class '" + cacheClassName + "'", ie);
            }
            if (!(cacheObject instanceof ResourceCache)) {
                String msg = "The specified resource cache class (" + cacheClassName + ") must implement " + ResourceCache.class.getName();
                this.log.error(msg);
                throw new RuntimeException(msg);
            }
        }
        if (cacheObject == null) {
            cacheObject = new ResourceCacheImpl();
        }
        this.globalCache = (ResourceCache)cacheObject;
        this.globalCache.initialize(this.rsvc);
        this.isInit = true;
        this.log.trace("Default ResourceManager initialization complete.");
    }

    private void assembleResourceLoaderInitializers() {
        Vector resourceLoaderNames = this.rsvc.getConfiguration().getVector("resource.loaders");
        ListIterator<String> it = resourceLoaderNames.listIterator();
        while (it.hasNext()) {
            String loaderName = StringUtils.trim((String)((String)it.next()));
            it.set(loaderName);
            StringBuilder loaderID = new StringBuilder();
            loaderID.append("resource.loader").append('.').append(loaderName);
            ExtProperties loaderConfiguration = this.rsvc.getConfiguration().subset(loaderID.toString());
            if (loaderConfiguration == null) {
                this.log.debug("ResourceManager : No configuration information found for resource loader named '{}' (id is {}). Skipping it...", (Object)loaderName, (Object)loaderID);
                continue;
            }
            loaderConfiguration.setProperty("_RESOURCE_LOADER_IDENTIFIER_", loaderName);
            this.sourceInitializerList.add(loaderConfiguration);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Resource getResource(String resourceName, int resourceType, String encoding) throws ResourceNotFoundException, ParseErrorException {
        String resourceKey = resourceType + resourceName;
        Resource resource = this.globalCache.get(resourceKey);
        if (resource != null) {
            try {
                if (!resource.requiresChecking()) return resource;
                return this.refreshResource(resource, encoding);
            }
            catch (ResourceNotFoundException rnfe) {
                this.globalCache.remove(resourceKey);
                return this.getResource(resourceName, resourceType, encoding);
            }
            catch (RuntimeException re) {
                this.log.error("ResourceManager.getResource() exception", (Throwable)re);
                throw re;
            }
        }
        try {
            resource = this.loadResource(resourceName, resourceType, encoding);
            if (!resource.getResourceLoader().isCachingOn()) return resource;
            this.globalCache.put(resourceKey, resource);
            return resource;
        }
        catch (ResourceNotFoundException rnfe) {
            this.log.error("ResourceManager: unable to find resource '{}' in any resource loader.", (Object)resourceName);
            throw rnfe;
        }
        catch (ParseErrorException pee) {
            this.log.error("ResourceManager: parse exception: {}", (Object)pee.getMessage());
            throw pee;
        }
        catch (RuntimeException re) {
            this.log.error("ResourceManager.getResource() load exception", (Throwable)re);
            throw re;
        }
    }

    protected Resource createResource(String resourceName, int resourceType) {
        return ResourceFactory.getResource(resourceName, resourceType);
    }

    protected Resource loadResource(String resourceName, int resourceType, String encoding) throws ResourceNotFoundException, ParseErrorException {
        Resource resource = this.createResource(resourceName, resourceType);
        resource.setRuntimeServices(this.rsvc);
        resource.setName(resourceName);
        resource.setEncoding(encoding);
        long howOldItWas = 0L;
        for (ResourceLoader resourceLoader : this.resourceLoaders) {
            resource.setResourceLoader(resourceLoader);
            try {
                if (!resource.process()) continue;
                if (this.logWhenFound) {
                    this.log.debug("ResourceManager: found {} with loader {}", (Object)resourceName, (Object)resourceLoader.getClassName());
                }
                howOldItWas = resourceLoader.getLastModified(resource);
                break;
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
            }
        }
        if (resource.getData() == null) {
            throw new ResourceNotFoundException("Unable to find resource '" + resourceName + "'", null, this.rsvc.getLogContext().getStackTrace());
        }
        resource.setLastModified(howOldItWas);
        resource.setModificationCheckInterval(resource.getResourceLoader().getModificationCheckInterval());
        resource.touch();
        return resource;
    }

    @Override
    public void initTemplate(Resource resource, String encoding) {
        resource.setRuntimeServices(this.rsvc);
        resource.setEncoding(encoding);
    }

    protected Resource refreshResource(Resource resource, String encoding) throws ResourceNotFoundException, ParseErrorException {
        String name;
        String resourceKey = resource.getType() + resource.getName();
        resource.touch();
        ResourceLoader loader = resource.getResourceLoader();
        if (this.resourceLoaders.size() > 0 && this.resourceLoaders.indexOf(loader) > 0 && loader != this.getLoaderForResource(name = resource.getName()) && (resource = this.loadResource(name, resource.getType(), encoding)).getResourceLoader().isCachingOn()) {
            this.globalCache.put(resourceKey, resource);
        }
        if (resource.isSourceModified()) {
            if (!StringUtils.equals((CharSequence)resource.getEncoding(), (CharSequence)encoding)) {
                this.log.warn("Declared encoding for template '{}' is different on reload. Old = '{}' New = '{}'", new Object[]{resource.getName(), resource.getEncoding(), encoding});
                resource.setEncoding(encoding);
            }
            long howOldItWas = loader.getLastModified(resource);
            Resource newResource = ResourceFactory.getResource(resource.getName(), resource.getType());
            newResource.setRuntimeServices(this.rsvc);
            newResource.setName(resource.getName());
            newResource.setEncoding(resource.getEncoding());
            newResource.setResourceLoader(loader);
            newResource.setModificationCheckInterval(loader.getModificationCheckInterval());
            newResource.process();
            newResource.setLastModified(howOldItWas);
            resource = newResource;
            resource.touch();
            this.globalCache.put(resourceKey, newResource);
        }
        return resource;
    }

    public Resource getResource(String resourceName, int resourceType) throws ResourceNotFoundException, ParseErrorException, Exception {
        return this.getResource(resourceName, resourceType, "UTF-8");
    }

    @Override
    public String getLoaderNameForResource(String resourceName) {
        ResourceLoader loader = this.getLoaderForResource(resourceName);
        if (loader == null) {
            return null;
        }
        return loader.getClass().toString();
    }

    private ResourceLoader getLoaderForResource(String resourceName) {
        for (ResourceLoader loader : this.resourceLoaders) {
            if (!loader.resourceExists(resourceName)) continue;
            return loader;
        }
        return null;
    }
}

