/*
 * Decompiled with CFR 0.152.
 */
package bboss.org.apache.velocity.util.introspection;

import bboss.org.apache.velocity.util.introspection.ClassFieldMap;
import bboss.org.apache.velocity.util.introspection.ClassMap;
import bboss.org.apache.velocity.util.introspection.IntrospectorCache;
import bboss.org.apache.velocity.util.introspection.MethodMap;
import bboss.org.apache.velocity.util.introspection.TypeConversionHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public abstract class IntrospectorBase {
    protected final Logger log;
    private final IntrospectorCache introspectorCache;

    protected IntrospectorBase(Logger log, TypeConversionHandler conversionHandler) {
        this.log = log;
        this.introspectorCache = new IntrospectorCache(log, conversionHandler);
    }

    public Method getMethod(Class<?> c, String name, Object[] params) throws MethodMap.AmbiguousException {
        IntrospectorCache ic = this.getIntrospectorCache();
        ClassMap classMap = ic.get((Class)Validate.notNull(c, (String)"class object is null!", (Object[])new Object[0]));
        if (classMap == null) {
            classMap = ic.put(c);
        }
        return classMap.findMethod(name, (Object[])Validate.notNull((Object)params, (String)"params object is null!", (Object[])new Object[0]));
    }

    public Field getField(Class<?> c, String name) throws IllegalArgumentException {
        IntrospectorCache ic = this.getIntrospectorCache();
        ClassFieldMap classFieldMap = ic.getFieldMap((Class)Validate.notNull(c, (String)"class object is null!", (Object[])new Object[0]));
        if (classFieldMap == null) {
            ic.put(c);
            classFieldMap = ic.getFieldMap(c);
        }
        return classFieldMap.findField(name);
    }

    protected IntrospectorCache getIntrospectorCache() {
        return this.introspectorCache;
    }
}

