/*
 * Decompiled with CFR 0.152.
 */
package bboss.org.apache.velocity.util.introspection;

import bboss.org.apache.velocity.util.introspection.ClassFieldMap;
import bboss.org.apache.velocity.util.introspection.ClassMap;
import bboss.org.apache.velocity.util.introspection.TypeConversionHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public final class IntrospectorCache {
    public static final String CACHEDUMP_MSG = "IntrospectorCache detected classloader change. Dumping cache.";
    private final Logger log;
    private final Map<Class<?>, ClassMap> classMapCache = new HashMap();
    private final Map<Class<?>, ClassFieldMap> classFieldMapCache = new HashMap();
    private final Set<String> classNameCache = new HashSet<String>();
    private final TypeConversionHandler conversionHandler;

    public IntrospectorCache(Logger log, TypeConversionHandler conversionHandler) {
        this.log = log;
        this.conversionHandler = conversionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<Class<?>, ClassMap> map = this.classMapCache;
        synchronized (map) {
            this.classMapCache.clear();
            this.classFieldMapCache.clear();
            this.classNameCache.clear();
            this.log.debug(CACHEDUMP_MSG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassMap get(Class<?> c) {
        ClassMap classMap = this.classMapCache.get(Validate.notNull(c));
        if (classMap == null) {
            Map<Class<?>, ClassMap> map = this.classMapCache;
            synchronized (map) {
                if (this.classNameCache.contains(c.getName())) {
                    this.clear();
                }
            }
        }
        return classMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassFieldMap getFieldMap(Class<?> c) {
        ClassFieldMap classFieldMap = this.classFieldMapCache.get(Validate.notNull(c));
        if (classFieldMap == null) {
            Map<Class<?>, ClassMap> map = this.classMapCache;
            synchronized (map) {
                if (this.classNameCache.contains(c.getName())) {
                    this.clear();
                }
            }
        }
        return classFieldMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassMap put(Class<?> c) {
        ClassMap classMap = new ClassMap(c, this.log, this.conversionHandler);
        ClassFieldMap classFieldMap = new ClassFieldMap(c, this.log);
        Map<Class<?>, ClassMap> map = this.classMapCache;
        synchronized (map) {
            this.classMapCache.put(c, classMap);
            this.classFieldMapCache.put(c, classFieldMap);
            this.classNameCache.add(c.getName());
        }
        return classMap;
    }
}

