/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.frameworkset.tran.AsynTranResultSet;
import org.frameworkset.tran.Data;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.DefaultTranMetaData;
import org.frameworkset.tran.LastValue;
import org.frameworkset.tran.Record;
import org.frameworkset.tran.TranMeta;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.record.NextAssert;
import org.frameworkset.tran.record.TranMetaDataLazeLoad;

public abstract class AsynBaseTranResultSet
extends LastValue
implements AsynTranResultSet {
    private List records;
    private int pos = 0;
    private int size;
    private BlockingQueue<Data> queue;
    private boolean preReachEOFRecord;
    private boolean reachEnd;
    private Long pollStartTime;

    public AsynBaseTranResultSet(ImportContext importContext) {
        this.queue = new ArrayBlockingQueue<Data>(importContext.getTranDataBufferQueue());
        this.importContext = importContext;
    }

    protected abstract Record buildRecord(Object var1);

    @Override
    public Object getKeys() {
        return this.record.getKeys();
    }

    @Override
    public void destroy() {
        this.clearQueue();
    }

    @Override
    public Object getValue(int i, String colName, int sqlType) throws DataImportException {
        return this.record.getValue(i, colName, sqlType);
    }

    @Override
    public Object getValue(String colName, int sqlType) throws DataImportException {
        return this.record.getValue(colName, sqlType);
    }

    @Override
    public Object getMetaValue(String fieldName) {
        return this.record.getMetaValue(fieldName);
    }

    public void reachEend() {
        this.reachEnd = true;
    }

    private boolean stopIterator() {
        return this.isStop() || this.importContext.getDataTranPlugin().checkTranToStop();
    }

    private boolean reachEOFRecord() {
        return this.record.reachEOFRecord();
    }

    private boolean recordsCheckForceFlush() {
        Object record;
        boolean needCheckForceFlush = false;
        if (this.records == null || this.records.size() == 0) {
            needCheckForceFlush = true;
        } else if (this.records.size() == 1 && (record = this.records.get(0)) instanceof Record) {
            needCheckForceFlush = ((Record)record).getAction() == 3;
        }
        return needCheckForceFlush;
    }

    private boolean checkForceFlush(NextAssert nextAssert) {
        long interval;
        if (this.importContext.getFlushInterval() > 0L && (interval = System.currentTimeMillis() - this.pollStartTime) > this.importContext.getFlushInterval()) {
            nextAssert.setNeedFlush(true);
            this.pollStartTime = null;
            return true;
        }
        return false;
    }

    @Override
    public void appendData(Data datas) throws InterruptedException {
        try {
            if (this.isStop() || this.queue == null) {
                if (!this.isStopFromException()) {
                    throw new InterruptedException("AsynBaseTranResultSet already stopped.");
                }
                throw new InterruptedException("AsynBaseTranResultSet already stopped by exception.");
            }
            this.queue.put(datas);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void clearQueue() {
        if (this.queue == null) {
            return;
        }
        try {
            this.queue.clear();
            while (true) {
                Data datas;
                if ((datas = this.queue.poll(this.importContext.getAsynResultPollTimeOut(), TimeUnit.MILLISECONDS)) == null) {
                    this.queue = null;
                    break;
                }
                this.queue.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public NextAssert next() throws DataImportException {
        NextAssert nextAssert = new NextAssert();
        if (this.preReachEOFRecord) {
            this.stop(false);
            this.clearQueue();
            return nextAssert;
        }
        if (this.baseDataTran.getDataTranPlugin().checkTranToStop()) {
            this.stop(false);
            this.clearQueue();
            return nextAssert;
        }
        if (this.pos < this.size) {
            this.record = this.buildRecord(this.records.get(this.pos));
            this.record.setTranMeta(this.getMetaData());
            this.preReachEOFRecord = this.reachEOFRecord();
            ++this.pos;
            nextAssert.setHasNext(true);
            return nextAssert;
        }
        try {
            Data datas = this.queue.poll(this.importContext.getAsynResultPollTimeOut(), TimeUnit.MILLISECONDS);
            boolean needCheckForceFlush = false;
            if (datas != null) {
                this.records = datas.getDatas();
                this.size = this.records != null ? this.records.size() : 0;
                needCheckForceFlush = this.recordsCheckForceFlush();
            } else {
                this.records = null;
                this.size = 0;
                needCheckForceFlush = true;
            }
            if (needCheckForceFlush) {
                if (this.pollStartTime == null) {
                    this.pollStartTime = System.currentTimeMillis();
                }
            } else {
                this.pollStartTime = null;
            }
            if (datas == null || this.size == 0) {
                block26: {
                    if (this.stopIterator()) {
                        this.stop(false);
                        this.clearQueue();
                        return nextAssert;
                    }
                    while (true) {
                        if (this.queue == null) {
                            return nextAssert;
                        }
                        datas = this.queue.poll(this.importContext.getAsynResultPollTimeOut(), TimeUnit.MILLISECONDS);
                        if (this.isStopFromException()) {
                            this.clearQueue();
                            return nextAssert;
                        }
                        if (datas == null) {
                            if (!this.reachEnd) {
                                if (this.stopIterator()) {
                                    this.stop(false);
                                    this.clearQueue();
                                    return nextAssert;
                                }
                                if (!this.checkForceFlush(nextAssert)) continue;
                                return nextAssert;
                            }
                            break block26;
                        }
                        this.records = datas.getDatas();
                        this.size = this.records != null ? this.records.size() : 0;
                        needCheckForceFlush = this.recordsCheckForceFlush();
                        if (needCheckForceFlush) {
                            if (this.pollStartTime == null) {
                                this.pollStartTime = System.currentTimeMillis();
                            }
                        } else {
                            this.pollStartTime = null;
                        }
                        if (this.size > 0) {
                            if (needCheckForceFlush) {
                                this.checkForceFlush(nextAssert);
                            }
                            break block26;
                        }
                        if (this.stopIterator()) break;
                    }
                    this.stop(false);
                    this.clearQueue();
                    return nextAssert;
                }
                if (datas == null && this.reachEnd) {
                    return nextAssert;
                }
            } else if (needCheckForceFlush) {
                this.checkForceFlush(nextAssert);
            }
            this.pos = 0;
            this.record = this.buildRecord(this.records.get(this.pos));
            this.record.setTranMeta(this.getMetaData());
            this.preReachEOFRecord = this.reachEOFRecord();
            ++this.pos;
            nextAssert.setHasNext(true);
            return nextAssert;
        }
        catch (InterruptedException e) {
            this.stop(false);
            this.clearQueue();
            return nextAssert;
        }
    }

    @Override
    public TranMeta getMetaData() {
        return new DefaultTranMetaData(new TranMetaDataLazeLoad(){

            @Override
            public String[] lazeLoad() {
                return DefaultTranMetaData.convert(AsynBaseTranResultSet.this.record.getKeys());
            }
        });
    }

    @Override
    public Object getRecord() {
        return this.record.getData();
    }
}

