/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.frameworkset.elasticsearch.scroll.BreakableScrollHandler;
import org.frameworkset.soa.BBossStringWriter;
import org.frameworkset.tran.AsynTranResultSet;
import org.frameworkset.tran.CommonRecord;
import org.frameworkset.tran.Data;
import org.frameworkset.tran.DataImportException;
import org.frameworkset.tran.DataTran;
import org.frameworkset.tran.DataTranPlugin;
import org.frameworkset.tran.JobCountDownLatch;
import org.frameworkset.tran.TranErrorWrapper;
import org.frameworkset.tran.TranResultSet;
import org.frameworkset.tran.WaitTasksCompleteCallBack;
import org.frameworkset.tran.config.OutputConfig;
import org.frameworkset.tran.context.ImportContext;
import org.frameworkset.tran.exception.ImportExceptionUtil;
import org.frameworkset.tran.metrics.ImportCount;
import org.frameworkset.tran.plugin.OutputPlugin;
import org.frameworkset.tran.record.AsynSplitTranResultSet;
import org.frameworkset.tran.record.SplitTranResultSet;
import org.frameworkset.tran.schedule.Status;
import org.frameworkset.tran.schedule.TaskContext;
import org.frameworkset.tran.status.LastValueWrapper;
import org.frameworkset.tran.task.BaseTranJob;
import org.frameworkset.tran.task.ParrelTranCommand;
import org.frameworkset.tran.task.SerialTranCommand;
import org.frameworkset.tran.task.TaskCommand;
import org.frameworkset.tran.task.TaskCommandContext;
import org.frameworkset.tran.task.TranJob;
import org.frameworkset.tran.task.TranStopReadEOFCallback;
import org.frameworkset.tran.task.TranStopReadEOFCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDataTran
implements DataTran {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ImportContext importContext;
    protected TranResultSet tranResultSet;
    protected boolean dataTranStopped;
    protected OutputPlugin outputPlugin;
    protected OutputConfig outputConfig;
    protected AsynTranResultSet asynTranResultSet;
    protected TaskContext taskContext;
    protected SerialTranCommand serialTranCommand;
    protected ParrelTranCommand parrelTranCommand;
    protected String taskInfo;
    protected TranJob tranJob;
    protected JobCountDownLatch countDownLatch;
    protected Status currentStatus;
    protected volatile boolean tranFinished;
    private TranStopReadEOFCallback tranStopReadEOFCallback;
    private BreakableScrollHandler breakableScrollHandler;
    protected BaseDataTran parent;
    private Object stopLock = new Object();
    public static final Class[] basePrimaryTypes = new Class[]{Integer.TYPE, Long.TYPE, Boolean.TYPE, Float.TYPE, Short.TYPE, Double.TYPE, Character.TYPE, Byte.TYPE, BigInteger.class, BigDecimal.class};

    public abstract TaskCommand buildTaskCommand(TaskCommandContext var1);

    @Override
    public void setOutputPlugin(OutputPlugin outputPlugin) {
        this.outputPlugin = outputPlugin;
        this.outputConfig = outputPlugin.getOutputConfig();
    }

    @Override
    public OutputConfig getOutputConfig() {
        return this.outputConfig;
    }

    @Override
    public OutputPlugin getOutputPlugin() {
        return this.outputPlugin;
    }

    protected TaskCommand _buildTaskCommand(TaskCommandContext taskCommandContext) {
        this.initTaskCommandContext(taskCommandContext);
        return this.buildTaskCommand(taskCommandContext);
    }

    @Override
    public void beforeOutputData(BBossStringWriter writer) {
    }

    protected void initTaskCommandContext(TaskCommandContext taskCommandContext) {
        taskCommandContext.setTaskContext(this.taskContext);
        taskCommandContext.setJobNo(this.taskContext.getJobNo());
        taskCommandContext.setCurrentStatus(this.currentStatus);
        taskCommandContext.setTaskInfo(this.taskInfo);
        taskCommandContext.evalDataSize();
    }

    @Override
    public Object buildSerialDatas(Object data, CommonRecord record) {
        return data;
    }

    @Override
    public ImportContext getImportContext() {
        return this.importContext;
    }

    public void logTaskStart(Logger logger) {
        logger.info(this.taskInfo + " start.");
    }

    public TaskContext getTaskContext() {
        return this.taskContext;
    }

    @Override
    public AsynTranResultSet getAsynTranResultSet() {
        return this.asynTranResultSet;
    }

    public void setTranStopReadEOFCallback(TranStopReadEOFCallback tranStopReadEOFCallback) {
        this.tranStopReadEOFCallback = tranStopReadEOFCallback;
    }

    public TranStopReadEOFCallback getTranStopReadEOFCallback() {
        return this.tranStopReadEOFCallback;
    }

    public void appendData(Data data) throws InterruptedException {
        if (this.asynTranResultSet != null) {
            this.asynTranResultSet.appendData(data);
        }
    }

    public Status getCurrentStatus() {
        return this.currentStatus;
    }

    @Override
    public BreakableScrollHandler getBreakableScrollHandler() {
        return this.breakableScrollHandler;
    }

    public void setBreakableScrollHandler(BreakableScrollHandler breakableScrollHandler) {
        this.breakableScrollHandler = breakableScrollHandler;
    }

    public BaseDataTran(TaskContext taskContext, TranResultSet tranResultSet, ImportContext importContext, Status currentStatus) {
        this.currentStatus = currentStatus;
        this.taskContext = taskContext;
        this.outputPlugin = importContext.getOutputPlugin();
        this.outputConfig = this.outputPlugin.getOutputConfig();
        if (importContext.getSplitHandler() != null) {
            if (tranResultSet instanceof AsynTranResultSet) {
                AsynSplitTranResultSet asynSplitTranResultSet = new AsynSplitTranResultSet(importContext, (AsynTranResultSet)tranResultSet);
                this.asynTranResultSet = asynSplitTranResultSet;
                this.tranResultSet = asynSplitTranResultSet;
            } else {
                this.tranResultSet = new SplitTranResultSet(importContext, tranResultSet);
            }
        } else {
            this.tranResultSet = tranResultSet;
            if (tranResultSet instanceof AsynTranResultSet) {
                this.asynTranResultSet = (AsynTranResultSet)tranResultSet;
            }
        }
        this.importContext = importContext;
        tranResultSet.setBaseDataTran(this);
    }

    public BaseDataTran(BaseDataTran parent) {
        this.parent = parent;
        this.taskContext = parent.getTaskContext();
    }

    @Override
    public boolean isMultiOutputTran() {
        return this.outputConfig.isMultiOutputTran();
    }

    protected abstract void initTranTaskCommand();

    public void init() {
    }

    public void afterInit() {
        this.initTranJob();
        this.initTranTaskCommand();
    }

    public void initTran() {
        this.init();
        this.afterInit();
    }

    public void stop(boolean fromException) {
        this.innerStop(fromException, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerStop(boolean fromException, boolean cleanQueue) {
        if (this.dataTranStopped) {
            return;
        }
        Object object = this.stopLock;
        synchronized (object) {
            if (this.dataTranStopped) {
                return;
            }
            this.dataTranStopped = true;
        }
        if (this.asynTranResultSet != null) {
            this.asynTranResultSet.stop(fromException);
            if (cleanQueue) {
                this.asynTranResultSet.clearQueue();
            }
            this.asynTranResultSet = null;
        }
        if (this.breakableScrollHandler != null) {
            this.breakableScrollHandler.setBreaked(true);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("DataTran load data completed fromException[{}] and ClearResultsetQueue[{}].", (Object)fromException, (Object)cleanQueue);
        }
    }

    public void stop2ndClearResultsetQueue(boolean fromException) {
        this.innerStop(fromException, true);
    }

    public String tran() throws DataImportException {
        try {
            String string = this.commonTran();
            return string;
        }
        catch (DataImportException dataImportException) {
            if (this.countDownLatch != null) {
                this.countDownLatch.attachException(dataImportException);
            }
            throw dataImportException;
        }
        catch (Exception dataImportException) {
            if (this.countDownLatch != null) {
                this.countDownLatch.attachException(dataImportException);
            }
            throw ImportExceptionUtil.buildDataImportException(this.importContext, dataImportException);
        }
        catch (Throwable dataImportException) {
            if (this.countDownLatch != null) {
                this.countDownLatch.attachException(dataImportException);
            }
            throw ImportExceptionUtil.buildDataImportException(this.importContext, dataImportException);
        }
        finally {
            if (this.countDownLatch != null) {
                this.countDownLatch.countDown();
            }
        }
    }

    protected String commonTran() throws DataImportException {
        try {
            this.getDataTranPlugin().setHasTran();
            if (this.tranResultSet == null) {
                String string = null;
                return string;
            }
            if (this.isPrintTaskLog()) {
                this.logTaskStart(this.logger);
            }
            if (this.importContext.getStoreBatchSize() <= 0) {
                String string = this.serialExecute();
                return string;
            }
            if (this.importContext.getThreadCount() > 0 && this.importContext.isParallel()) {
                String string = this.parallelBatchExecute();
                return string;
            }
            String string = this.batchExecute();
            return string;
        }
        finally {
            this.tranFinished = true;
            this.getDataTranPlugin().setNoTran();
        }
    }

    private void flush(Throwable exception, LastValueWrapper lastValue, TranErrorWrapper tranErrorWrapper, Status currentStatus, boolean reachEOFClosed) {
        if (reachEOFClosed) {
            if (tranErrorWrapper.assertCondition(exception)) {
                if (tranErrorWrapper.exceptionOccur(exception)) {
                    this.importContext.reportJobMetricErrorLog("Excetion occur but continue on error,so flushLastValue last status to job status registry table.", tranErrorWrapper.getError(exception));
                }
                this.importContext.flushLastValue(lastValue, currentStatus, reachEOFClosed);
            } else if (!tranErrorWrapper.exceptionOccur(exception)) {
                this.importContext.flushLastValue(lastValue, currentStatus, reachEOFClosed);
            }
        }
    }

    protected void jobComplete(ExecutorService service, Throwable exception, LastValueWrapper lastValue, TranErrorWrapper tranErrorWrapper, Status currentStatus, boolean reachEOFClosed) {
        this.flush(exception, lastValue, tranErrorWrapper, currentStatus, reachEOFClosed);
        this.stop2ndClearResultsetQueue(tranErrorWrapper.exceptionOccur(exception));
    }

    public void endJob(boolean reachEOFClosed, ImportCount importCount, Throwable errorStop) {
        Date endTime = new Date();
        if (this.getTaskContext() != null) {
            this.getTaskContext().setJobEndTime(endTime);
        }
        if (this.tranStopReadEOFCallback != null) {
            TranStopReadEOFCallbackContext tranStopReadEOFCallbackContext = new TranStopReadEOFCallbackContext(errorStop, reachEOFClosed);
            this.tranStopReadEOFCallback.call(tranStopReadEOFCallbackContext);
        }
    }

    public boolean isPrintTaskLog() {
        return this.importContext.isPrintTaskLog() && this.logger.isInfoEnabled();
    }

    @Override
    public void waitTasksComplete(final List<Future> tasks, final ExecutorService service, final Throwable exception, final LastValueWrapper lastValue, final ImportCount totalCount, final TranErrorWrapper tranErrorWrapper, final WaitTasksCompleteCallBack waitTasksCompleteCallBack, final boolean reachEOFClosed) {
        totalCount.setSubmitTasksEndTime(System.currentTimeMillis());
        if (this.isPrintTaskLog()) {
            StringBuilder stringBuilder = BaseTranJob.builderJobInfo(this.importContext.getInputPlugin(), this.outputPlugin, new StringBuilder(), this.importContext);
            this.logger.info(stringBuilder.append("Parallel batch import submit tasks:").append(tasks.size()).append(" and take times:").append(totalCount.getSubmitTasksElapsed()).append("ms.").toString());
        }
        Consumer<Object> function = new Consumer<Object>(){

            @Override
            public void accept(Object o) {
                Throwable _exception;
                int count;
                block12: {
                    count = 0;
                    _exception = exception;
                    for (Future future : tasks) {
                        try {
                            future.get();
                            ++count;
                        }
                        catch (ExecutionException e) {
                            if (_exception == null) {
                                _exception = e;
                            }
                            if (!BaseDataTran.this.logger.isErrorEnabled()) continue;
                            if (e.getCause() != null) {
                                BaseDataTran.this.logger.error("", e.getCause());
                                continue;
                            }
                            BaseDataTran.this.logger.error("", (Throwable)e);
                        }
                        catch (Exception e) {
                            if (_exception == null) {
                                _exception = e;
                            }
                            if (!BaseDataTran.this.logger.isErrorEnabled()) continue;
                            BaseDataTran.this.logger.error("", (Throwable)e);
                        }
                    }
                    if (waitTasksCompleteCallBack != null) {
                        try {
                            waitTasksCompleteCallBack.call();
                        }
                        catch (Throwable throwable) {
                            if (_exception == null) {
                                _exception = throwable;
                            }
                            if (!BaseDataTran.this.logger.isErrorEnabled()) break block12;
                            BaseDataTran.this.logger.error("", throwable);
                        }
                    }
                }
                totalCount.setEndTime(System.currentTimeMillis());
                if (BaseDataTran.this.isPrintTaskLog()) {
                    StringBuilder stringBuilder = BaseTranJob.builderJobInfo(BaseDataTran.this.importContext.getInputPlugin(), BaseDataTran.this.outputPlugin, new StringBuilder(), BaseDataTran.this.importContext);
                    BaseDataTran.this.logger.info(stringBuilder.append("Parallel batch import Complete tasks:").append(count).append(",Total success import ").append(totalCount.getSuccessCount()).append(" records,Ignore Total ").append(totalCount.getIgnoreTotalCount()).append(" records,failed total ").append(totalCount.getFailedCount()).append(" records,Take times:").append(totalCount.getElapsed()).append("ms.").toString());
                }
                BaseDataTran.this.jobComplete(service, _exception, lastValue, tranErrorWrapper, BaseDataTran.this.currentStatus, reachEOFClosed);
                BaseDataTran.this.endJob(reachEOFClosed, totalCount, _exception);
            }
        };
        function.accept(null);
    }

    public static boolean isBasePrimaryType(Class type) {
        if (!type.isArray()) {
            if (type.isEnum()) {
                return true;
            }
            for (Class primaryType : basePrimaryTypes) {
                if (!primaryType.isAssignableFrom(type)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public DataTranPlugin getDataTranPlugin() {
        return this.importContext.getDataTranPlugin();
    }

    public Object getLastValue() throws DataImportException {
        return this.tranResultSet.getLastValue();
    }

    public boolean isTranFinished() {
        return this.tranFinished;
    }

    public boolean isRecordDirectIgnore() {
        return this.tranResultSet.getAction() == 3;
    }

    protected void initTranJob() {
        this.tranJob = this.importContext.getInputPlugin().getTranJob();
    }

    @Override
    public BaseDataTran getParent() {
        return this.parent;
    }
}

