/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.frameworkset.elasticsearch.client.ResultUtil;
import org.frameworkset.tran.cdc.TableMapping;
import org.frameworkset.tran.config.OutputConfig;
import org.frameworkset.tran.plugin.OutputPlugin;
import org.frameworkset.tran.record.RecordColumnInfo;
import org.frameworkset.tran.record.RecordOutpluginSpecialConfig;
import org.frameworkset.tran.record.RecordOutpluginSpecialConfigs;
import org.frameworkset.tran.record.ValueConvert;
import org.frameworkset.tran.schedule.timer.TimeUtil;

public class CommonRecord {
    private RecordOutpluginSpecialConfigs recordOutpluginSpecialConfigs;
    private RecordOutpluginSpecialConfig recordOutpluginSpecialConfig;
    private int action = 0;
    private Map<String, Object> metaDatas;
    private Object recordKey;
    private String recordKeyField;
    private Object keys;
    private Map<String, Object> updateFromDatas;
    private Object oringeData;
    private Map<String, Object> datas;
    private Map<String, Object> tempDatas;
    private TableMapping tableMapping;

    public Object getOringeData() {
        return this.oringeData;
    }

    public void setOringeData(Object oringeData) {
        this.oringeData = oringeData;
    }

    public Map<String, Object> getDatas() {
        return this.datas;
    }

    public void setDatas(Map<String, Object> datas) {
        this.datas = datas;
    }

    public void setRecordOutpluginSpecialConfigs(RecordOutpluginSpecialConfigs recordOutpluginSpecialConfigs) {
        this.recordOutpluginSpecialConfigs = recordOutpluginSpecialConfigs;
    }

    public RecordOutpluginSpecialConfig getRecordOutpluginSpecialConfig(OutputConfig outputConfig) {
        return this.recordOutpluginSpecialConfigs != null ? this.recordOutpluginSpecialConfigs.getRecordOutpluginSpecialConfig(outputConfig) : this.recordOutpluginSpecialConfig;
    }

    public RecordOutpluginSpecialConfig getRecordOutpluginSpecialConfig(OutputPlugin outputPlugin) {
        return this.recordOutpluginSpecialConfigs != null ? this.recordOutpluginSpecialConfigs.getRecordOutpluginSpecialConfig(outputPlugin) : this.recordOutpluginSpecialConfig;
    }

    public RecordColumnInfo getRecordColumnInfo(OutputConfig outputConfig, String name) {
        if (this.recordOutpluginSpecialConfig != null) {
            return this.recordOutpluginSpecialConfig.getRecordColumnInfo(name);
        }
        return this.recordOutpluginSpecialConfigs.getRecordColumnInfo(outputConfig, name);
    }

    public void addData(String name, Object value) {
        if (this.datas == null) {
            this.datas = new LinkedHashMap<String, Object>();
        }
        this.datas.put(name, value);
    }

    public Object getData(String name) {
        if (this.datas != null) {
            return this.datas.get(name);
        }
        return null;
    }

    public boolean containKey(String name) {
        if (this.datas != null) {
            return this.datas.containsKey(name);
        }
        return false;
    }

    public Object getRecordKey() {
        return this.recordKey;
    }

    public void setRecordKey(Object recordKey) {
        this.recordKey = recordKey;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public boolean isInsert() {
        return this.action == 0;
    }

    public boolean isDelete() {
        return this.action == 2;
    }

    public boolean isDDL() {
        return this.action == 5;
    }

    public boolean isUpdate() {
        return this.action == 1;
    }

    public boolean isReplace() {
        return this.action == 6;
    }

    public Map<String, Object> getMetaDatas() {
        return this.metaDatas;
    }

    public void setMetaDatas(Map<String, Object> metaDatas) {
        this.metaDatas = metaDatas;
    }

    public Object getMetaValue(String colName) {
        if (this.metaDatas != null) {
            return this.metaDatas.get(colName);
        }
        return null;
    }

    public Map<String, Object> getUpdateFromDatas() {
        return this.updateFromDatas;
    }

    public void setUpdateFromDatas(Map<String, Object> updateFromDatas) {
        this.updateFromDatas = updateFromDatas;
    }

    public Map<String, Object> getTempDatas() {
        return this.tempDatas;
    }

    public void setTempDatas(Map<String, Object> tempDatas) {
        this.tempDatas = tempDatas;
    }

    public Object getTempData(String name) {
        return this.tempDatas != null ? this.tempDatas.get(name) : null;
    }

    public TableMapping getTableMapping() {
        return this.tableMapping;
    }

    public void setTableMapping(TableMapping tableMapping) {
        this.tableMapping = tableMapping;
    }

    public String getRecordKeyField() {
        return this.recordKeyField;
    }

    public void setRecordKeyField(String recordKeyField) {
        this.recordKeyField = recordKeyField;
    }

    public long getLongValue(String fieldName) throws Exception {
        Object value = this.getData(fieldName);
        return ResultUtil.longValue((Object)value, (Long)0L);
    }

    public String getStringValue(String fieldName) throws Exception {
        Object value = this.getData(fieldName);
        return ResultUtil.stringValue((Object)value, null);
    }

    public String getStringValue(String fieldName, ValueConvert valueConvert) throws Exception {
        Object value = this.getData(fieldName);
        return (String)valueConvert.convert(value);
    }

    public String getStringValue(String fieldName, String defaultValue) throws Exception {
        Object value = this.getData(fieldName);
        return ResultUtil.stringValue((Object)value, (String)defaultValue);
    }

    public boolean getBooleanValue(String fieldName) throws Exception {
        Object value = this.getData(fieldName);
        return ResultUtil.booleanValue((Object)value, (boolean)false);
    }

    public boolean getBooleanValue(String fieldName, ValueConvert valueConvert) throws Exception {
        Object value = this.getData(fieldName);
        return (Boolean)valueConvert.convert(value);
    }

    public boolean getBooleanValue(String fieldName, boolean defaultValue) throws Exception {
        Object value = this.getData(fieldName);
        return ResultUtil.booleanValue((Object)value, (boolean)defaultValue);
    }

    public double getDoubleValue(String fieldName) throws Exception {
        Object value = this.getData(fieldName);
        return ResultUtil.doubleValue((Object)value, (Double)0.0);
    }

    public float getFloatValue(String fieldName) throws Exception {
        Object value = this.getData(fieldName);
        return ResultUtil.floatValue((Object)value, (Float)Float.valueOf(0.0f)).floatValue();
    }

    public int getIntegerValue(String fieldName) throws Exception {
        Object value = this.getData(fieldName);
        return ResultUtil.intValue((Object)value, (Integer)0);
    }

    public Date getDateValue(String fieldName) throws Exception {
        Object value = this.getData(fieldName);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        if (value instanceof String) {
            LocalDateTime localDateTime = TimeUtil.localDateTime((String)((String)value));
            return TimeUtil.convertLocalDatetime((LocalDateTime)localDateTime);
        }
        if (value instanceof LocalDateTime) {
            return TimeUtil.convertLocalDatetime((LocalDateTime)((LocalDateTime)value));
        }
        if (value instanceof LocalDate) {
            return TimeUtil.convertLocalDate((LocalDate)((LocalDate)value));
        }
        if (value instanceof BigDecimal) {
            return new Date(((BigDecimal)value).longValue());
        }
        throw new IllegalArgumentException("Convert date value failed:" + value);
    }

    public LocalDateTime getLocalDateTime(String fieldName) throws Exception {
        Object value = this.getData(fieldName);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return TimeUtil.localDateTime((String)((String)value));
        }
        if (value instanceof Date) {
            return TimeUtil.date2LocalDateTime((Date)((Date)value));
        }
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        if (value instanceof LocalDate) {
            return TimeUtil.date2LocalDateTime((Date)TimeUtil.convertLocalDate((LocalDate)((LocalDate)value)));
        }
        if (value instanceof BigDecimal) {
            return TimeUtil.date2LocalDateTime((Date)new Date(((BigDecimal)value).longValue()));
        }
        if (value instanceof Long) {
            return TimeUtil.date2LocalDateTime((Date)new Date((Long)value));
        }
        throw new IllegalArgumentException("Convert date value failed:" + value);
    }

    public Date getDateValue(String fieldName, String dateFormat) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
        return this.getDateValue(fieldName, simpleDateFormat);
    }

    public Date getDateValue(String fieldName, DateFormat dateFormat) throws Exception {
        Object value = this.getData(fieldName);
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof LocalDateTime) {
            return TimeUtil.convertLocalDatetime((LocalDateTime)((LocalDateTime)value));
        }
        if (value instanceof LocalDate) {
            return TimeUtil.convertLocalDate((LocalDate)((LocalDate)value));
        }
        if (value instanceof BigDecimal) {
            return new Date(((BigDecimal)value).longValue());
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        if (value instanceof String) {
            return dateFormat.parse((String)value);
        }
        throw new IllegalArgumentException("Convert date value failed:" + value);
    }

    public Object getKeys() {
        return this.keys;
    }

    public void setKeys(Object keys) {
        this.keys = keys;
    }

    public RecordOutpluginSpecialConfig getRecordOutpluginSpecialConfig() {
        return this.recordOutpluginSpecialConfig;
    }

    public void setRecordOutpluginSpecialConfig(RecordOutpluginSpecialConfig recordOutpluginSpecialConfig) {
        this.recordOutpluginSpecialConfig = recordOutpluginSpecialConfig;
    }
}

